/*
 * Decompiled with CFR 0.152.
 */
package fxterm.utils;

import ru.softlogic.reference.currency.CurrencyRate;

public class CRWrap {
    private CurrencyRate cr;
    private boolean inverse;

    public CRWrap(CurrencyRate cr, boolean inverse) {
        if (cr == null) {
            throw new NullPointerException("CurrencyRate is null");
        }
        this.cr = cr;
        this.inverse = inverse;
    }

    public CurrencyRate getCr() {
        return this.cr;
    }

    public void setCr(CurrencyRate cr) {
        this.cr = cr;
    }

    public boolean isInverse() {
        return this.inverse;
    }

    public void setInverse(boolean inverse) {
        this.inverse = inverse;
    }

    public double getRate() {
        return this.inverse ? this.cr.getRate() : 1.0 / this.cr.getBid();
    }

    public double getRateView() {
        return this.inverse ? this.cr.getRate() : this.cr.getBid();
    }

    public int getNominal() {
        return this.cr.getNominal();
    }

    public String getBaseCurrency() {
        return this.inverse ? this.cr.getCurrency() : this.cr.getBaseCurrency();
    }

    public String getCurrency() {
        return this.inverse ? this.cr.getBaseCurrency() : this.cr.getCurrency();
    }

    public CRWrap inverse() {
        return new CRWrap(this.cr, !this.inverse);
    }

    public String toString() {
        return "CRWrap{cr=" + this.cr + ", inverse=" + this.inverse + '}';
    }
}

