/*
 * Decompiled with CFR 0.152.
 */
package fxterm.session;

import fxterm.session.Session;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import plfx.GuiNotifier;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.advanced.AdvancedScreenDescription;
import ru.softlogic.input.model.advanced.Scenario;
import ru.softlogic.input.model.advanced.actions.Action;
import ru.softlogic.input.model.advanced.actions.ActionElement;
import ru.softlogic.input.model.advanced.actions.ActionMap;
import ru.softlogic.input.model.advanced.actions.conditional.Case;
import ru.softlogic.input.model.advanced.actions.conditional.If;
import ru.softlogic.input.model.advanced.actions.conditional.Switch;
import ru.softlogic.input.model.advanced.actions.dialog.DialogAction;
import ru.softlogic.input.model.advanced.actions.request.DefaultOnlineRequest;
import ru.softlogic.input.model.advanced.actions.simple.Modify;
import ru.softlogic.input.model.advanced.actions.simple.Set;
import ru.softlogic.input.model.field.FieldSequence;
import ru.softlogic.input.model.field.IdentityField;
import ru.softlogic.input.model.field.ScreenSequence;
import ru.softlogic.input.model.field.selector.SelectorField;
import ru.softlogic.input.model.field.selector.SelectorItem;
import ru.softlogic.input.model.form.Form;
import ru.softlogic.input.model.screen.description.ScreenDescription;

@Deprecated
public final class TextIdProcessor {
    private TextIdProcessor() {
    }

    public static void process(Form form) {
        System.out.println("Process " + form);
        if (form == null) {
            return;
        }
        ResourceBundle bundle = Session.getCurrentBundle();
        ScreenSequence screenSequence = form.getScreenSequence();
        List screens = screenSequence.getScreens();
        for (ScreenDescription sd : screens) {
            TextIdProcessor.processScreenTitle(bundle, sd);
            FieldSequence sequence = sd.getSequence();
            if (sequence == null) continue;
            for (IdentityField fields : sequence.getFields()) {
                TextIdProcessor.processField(bundle, fields);
            }
        }
        List fields = screenSequence.getFields();
        for (InputElement field : fields) {
            String text = TextIdProcessor.getText(bundle, field.getKeyTitleId());
            if (text != null) {
                field.setKeyTitle(text);
            }
            if ((text = TextIdProcessor.getText(bundle, field.getValueTitleId())) == null) continue;
            field.setValueTitle(text);
        }
    }

    public static void process(Scenario scenario) {
        if (scenario == null) {
            return;
        }
        ResourceBundle bundle = Session.getCurrentBundle();
        ArrayList screens = new ArrayList(scenario.getScreens().values());
        for (AdvancedScreenDescription asd : screens) {
            ScreenDescription sd = asd.getDescription();
            TextIdProcessor.processScreenTitle(bundle, sd);
            FieldSequence sequence = sd.getSequence();
            if (sequence != null) {
                for (IdentityField fields : sequence.getFields()) {
                    TextIdProcessor.processField(bundle, fields);
                }
            }
            ActionMap actionMap = asd.getActionMap();
            List actions = actionMap.getActions();
            for (Action action : actions) {
                TextIdProcessor.processActionTitle(bundle, action);
                List actionElements = action.getSequence();
                for (ActionElement actionElement : actionElements) {
                    TextIdProcessor.processActionElement(bundle, actionElement);
                }
            }
        }
    }

    private static void processScreenTitle(ResourceBundle bundle, ScreenDescription sd) {
        String text;
        if (sd != null && (text = TextIdProcessor.getText(bundle, sd.getTitleId())) != null) {
            sd.setTitle(text);
        }
    }

    private static void processField(ResourceBundle bundle, IdentityField field) {
        System.out.println("PROCESS FIELD: " + field);
        if (field == null || bundle == null) {
            return;
        }
        String text = TextIdProcessor.getText(bundle, field.getTitleId());
        if (text != null) {
            field.setTitle(text);
        }
        if ((text = TextIdProcessor.getText(bundle, field.getMessageId())) != null) {
            field.setMessage(text);
        }
        if ((text = TextIdProcessor.getText(bundle, field.getErrorMessageId())) != null) {
            field.setErrorMessage(text);
        }
        if ((text = TextIdProcessor.getText(bundle, field.getHelpId())) != null) {
            field.setHelp(text);
        }
        if (field instanceof SelectorField) {
            System.out.println("    > selector");
            SelectorField selectorFiled = (SelectorField)field;
            for (SelectorItem item : selectorFiled.getItems()) {
                text = TextIdProcessor.getText(bundle, item.getTitleId());
                System.out.println("       > " + item.getTitleId() + "->" + text);
                if (text == null) continue;
                item.setTitle(text);
            }
        }
    }

    private static void processActionTitle(ResourceBundle bundle, Action action) {
        String text;
        if (action != null && (text = TextIdProcessor.getText(bundle, action.getTitleId())) != null) {
            action.setTitle(text);
        }
    }

    private static void processActionElement(ResourceBundle bundle, ActionElement actionElement) {
        if (actionElement instanceof DialogAction) {
            TextIdProcessor.processDialogAction(bundle, (DialogAction)actionElement);
        } else if (actionElement instanceof If) {
            TextIdProcessor.processIfAction(bundle, (If)actionElement);
        } else if (actionElement instanceof Switch) {
            TextIdProcessor.processSwitchAction(bundle, (Switch)actionElement);
        } else if (actionElement instanceof Modify) {
            TextIdProcessor.processModifyAction(bundle, (Modify)actionElement);
        } else if (actionElement instanceof Set) {
            TextIdProcessor.processSetAction(bundle, (Set)actionElement);
        } else if (actionElement instanceof DefaultOnlineRequest) {
            TextIdProcessor.processDefaultOnlineRequest(bundle, (DefaultOnlineRequest)actionElement);
        }
    }

    private static void processDefaultOnlineRequest(ResourceBundle bundle, DefaultOnlineRequest defaultOnlineRequest) {
        ActionMap actionMap = defaultOnlineRequest.getActionMap();
        List actions = actionMap.getActions();
        for (Action action : actions) {
            TextIdProcessor.processActionTitle(bundle, action);
            List actionElements = action.getSequence();
            for (ActionElement actionElement : actionElements) {
                TextIdProcessor.processActionElement(bundle, actionElement);
            }
        }
    }

    private static void processDialogAction(ResourceBundle bundle, DialogAction dialogAction) {
        String text = TextIdProcessor.getText(bundle, dialogAction.getMessageId());
        if (text != null) {
            dialogAction.setMessage(text);
        }
        if ((text = TextIdProcessor.getText(bundle, dialogAction.getTitleId())) != null) {
            dialogAction.setTitle(text);
        }
        for (Action action : dialogAction.getActionMap().getActions()) {
            TextIdProcessor.processActionTitle(bundle, action);
        }
    }

    private static void processIfAction(ResourceBundle bundle, If ifAction) {
        for (ActionElement element : ifAction.getElseElements()) {
            TextIdProcessor.processActionElement(bundle, element);
        }
        for (ActionElement element : ifAction.getThenElements()) {
            TextIdProcessor.processActionElement(bundle, element);
        }
    }

    private static void processSetAction(ResourceBundle bundle, Set setAction) {
        InputElement value = setAction.getElement();
        String text = TextIdProcessor.getText(bundle, value.getValueTitleId());
        if (text != null) {
            value.setValueTitle(text);
        }
        if ((text = TextIdProcessor.getText(bundle, value.getKeyTitleId())) != null) {
            value.setKeyTitle(text);
        }
    }

    private static void processSwitchAction(ResourceBundle bundle, Switch switchAction) {
        for (Case caseAction : switchAction.getCases()) {
            for (ActionElement element : caseAction.getSequence()) {
                TextIdProcessor.processActionElement(bundle, element);
            }
        }
    }

    private static void processModifyAction(ResourceBundle bundle, Modify modifyAction) {
        InputElement value = modifyAction.getValue();
        if (value != null) {
            String text = TextIdProcessor.getText(bundle, value.getValueTitleId());
            if (text != null) {
                value.setValueTitle(text);
            }
            if ((text = TextIdProcessor.getText(bundle, value.getKeyTitleId())) != null) {
                value.setKeyTitle(text);
            }
        }
    }

    private static String getText(ResourceBundle bundle, String titleId) {
        if (titleId != null && !titleId.isEmpty()) {
            try {
                return bundle.getString(titleId);
            }
            catch (Exception ex) {
                GuiNotifier.notifyProblemOnce((String)("Wrong form field resource id: " + titleId));
            }
        }
        return null;
    }
}

