/*
 * Decompiled with CFR 0.152.
 */
package fxterm.session;

import fxterm.session.Session;
import fxterm.session.VelocityListener;
import fxterm.session.VelocitySumFormatter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.app.event.EventCartridge;
import org.apache.velocity.app.event.EventHandler;
import org.apache.velocity.app.event.ReferenceInsertionEventHandler;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import plfx.GuiNotifier;

public class TemplateProcessor {
    public static String processTextQuietly(String templatePath) {
        return TemplateProcessor.processTextQuietly(templatePath, Session.getLocale(), Session.getData());
    }

    public static String processTextQuietly(String templatePath, Locale locale, Map<String, Object> data) {
        if (templatePath == null) {
            throw new NullPointerException("Template path is not found");
        }
        if (locale == null) {
            throw new NullPointerException("Locale path is not found");
        }
        String path = MessageFormat.format(templatePath, "_" + locale.getLanguage() + "_" + locale.getCountry());
        if (!new File(path).canRead() && !new File(path = MessageFormat.format(templatePath, "_" + locale.getLanguage())).canRead()) {
            path = MessageFormat.format(templatePath, "");
        }
        try {
            return TemplateProcessor.processText(FileUtils.readFileToString((File)new File(path), (String)"UTF-8"), data, path);
        }
        catch (IOException ex) {
            GuiNotifier.notifyError((String)("Error on locate template: " + path + ", error=" + ex.getMessage()));
            return "";
        }
    }

    public static String processText(String text, Map<String, Object> data, String path) {
        VelocityContext context = new VelocityContext();
        for (Map.Entry<String, Object> e : data.entrySet()) {
            context.put(e.getKey(), e.getValue());
        }
        EventCartridge ec = new EventCartridge();
        ec.addEventHandler((EventHandler)new VelocityListener(path));
        ec.attachToContext((Context)context);
        ec.addReferenceInsertionEventHandler((ReferenceInsertionEventHandler)new VelocitySumFormatter());
        try {
            StringWriter sw = new StringWriter();
            Velocity.evaluate((Context)context, (Writer)sw, (String)"", (String)text);
            String result = sw.toString().trim();
            return result;
        }
        catch (MethodInvocationException | ParseErrorException | ResourceNotFoundException ex) {
            GuiNotifier.notifyError((String)("Error on parce template: " + path + ", error=" + ex.getMessage()));
            return text;
        }
    }
}

