/*
 * Decompiled with CFR 0.152.
 */
package fxterm.session;

import fxterm.app.id.LoggerId;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.cash.unit.CashUnitGroup;

class SessionHelper {
    private static final Logger log = LoggerId.DEBUG;
    private static final Logger logP = LoggerId.PAY;
    private static final List<String> keys = new LinkedList<String>();
    private static final List<String> bkeys;

    SessionHelper() {
    }

    public static void printContent(Map<String, Object> map) {
        if (map != null && !map.isEmpty() && log.isDebugEnabled()) {
            log.debug((Object)"  Data store:");
            for (String string : keys) {
                SessionHelper.printObj(string, map.get(string));
            }
            for (Map.Entry entry : map.entrySet()) {
                if (keys.contains(entry.getKey()) || bkeys.contains(entry.getKey())) continue;
                SessionHelper.printObj((String)entry.getKey(), entry.getValue());
            }
        }
    }

    private static void printObj(String key, Object obj) {
        if (obj != null && obj instanceof String) {
            String str = (String)obj;
            if (str.length() > 50) {
                log.debug((Object)("    " + key + "=" + str.substring(0, 50).replace("\n", "").replace("\r", "") + ".."));
            } else {
                log.debug((Object)("    " + key + "=" + str.replace("\n", "").replace("\r", "")));
            }
        } else {
            log.debug((Object)("    " + key + "=" + obj));
        }
    }

    public static void printUnits(String key, CashUnit[] units) {
        log.info((Object)key);
        if (units != null && units.length > 0) {
            for (CashUnit cu : units) {
                log.info((Object)("    " + cu));
            }
        } else {
            log.info((Object)"    -");
        }
    }

    public static void printUnits(String key, CashUnitGroup[] units) {
        log.info((Object)key);
        if (units != null && units.length > 0) {
            for (CashUnitGroup cug : units) {
                log.info((Object)("    " + cug));
            }
        } else {
            log.info((Object)"    -");
        }
    }

    static {
        keys.add("terminal_state");
        keys.add("terminal_version");
        keys.add("java_version");
        keys.add("javafx_version");
        keys.add("dealer");
        keys.add("point");
        keys.add("ps");
        keys.add("menuitem");
        keys.add("st");
        keys.add("stl");
        keys.add("service");
        keys.add("service_lang");
        keys.add("commission");
        keys.add("operator");
        keys.add("provider");
        bkeys = new LinkedList<String>();
        bkeys.add("df");
        bkeys.add("df_date");
        bkeys.add("df_time");
        bkeys.add("fu");
        bkeys.add("mu");
        bkeys.add("sf");
        bkeys.add("su");
        bkeys.add("env");
        bkeys.add("pf");
        bkeys.add("decf");
        bkeys.add("string");
    }
}

