/*
 * Decompiled with CFR 0.152.
 */
package fxterm.session;

import fxterm.app.FxEnv;
import fxterm.app.id.LoggerId;
import fxterm.app.plt2.ReturnService;
import fxterm.core.BaseCommissionCalculator;
import fxterm.core.activity.UserAction;
import fxterm.core.cash.CompatCashFactory;
import fxterm.core.cash.CompatCashProfile;
import fxterm.core.hdw.modem.ModemStateInfo;
import fxterm.core.menu.MenuByServiceIdVisitor;
import fxterm.module.ModuleStore;
import fxterm.module.PayEnv;
import fxterm.module.Payment;
import fxterm.module.PaymentEndingState;
import fxterm.module.PaymentTemplateState;
import fxterm.session.BarcodeUtils;
import fxterm.session.Change;
import fxterm.session.FileControl;
import fxterm.session.SessionHelper;
import fxterm.session.SessionListener;
import fxterm.session.SumFormatter;
import fxterm.session.TemplateProcessor;
import fxterm.session.TextHelper;
import fxterm.utils.FinUtils;
import fxterm.utils.GeoUtils;
import fxterm.utils.SaveUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import plfx.GuiNotifier;
import plfx.controller.lang.Lang;
import plfx.msg.MessageProcessor;
import plfx.util.Locator;
import ru.softlogic.app.DaemonVersion;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.cash.unit.CashUnitGroup;
import ru.softlogic.cash.unit.CashUnitProfile;
import ru.softlogic.hardware.currency.CashProfileException;
import ru.softlogic.hdw.dev.modem.NetworkInfo;
import ru.softlogic.hdw.handling.DeviceInfo;
import ru.softlogic.input.model.advanced.configuration.SoftwareType;
import ru.softlogic.input.model.advanced.messages.B;
import ru.softlogic.input.model.field.FieldSequence;
import ru.softlogic.input.model.field.IdentityField;
import ru.softlogic.input.model.field.InputField;
import ru.softlogic.input.model.field.numeric.Range;
import ru.softlogic.input.model.field.text.NumericExternalValidator;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.reference.References;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.point.Dealer;
import ru.softlogic.reference.point.PaymentSystem;
import ru.softlogic.reference.point.Point;
import ru.softlogic.reference.service.Service;
import ru.softlogic.reference.service.ServiceLang;
import ru.softlogic.reference.service.ServiceType;
import ru.softlogic.reference.service.ServiceTypeLang;
import ru.softlogic.reference.weather.Weather;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.service.comission.CommissionStep;
import ru.softlogic.service.comission.CommissionUnit;
import ru.softlogic.system.util.DaemonUtil;
import ru.softlogic.system.util.PathUtils;

public class Session {
    public static final String JAVA_VERSION = "java_version";
    public static final String JAVAFX_VERSION = "javafx_version";
    public static final String TERMINAL_VERSION = "terminal_version";
    public static final String TERMINAL_HOME = "terminal_home";
    public static final String DATE_FORMAT = "df";
    public static final String DECIMAL_FORMAT = "decf";
    public static final String DATE_FORMAT_DATE = "df_date";
    public static final String DATE_FORMAT_TIME = "df_time";
    public static final String MENU_UTILS = "mu";
    public static final String LOCALIZATION_UTILS = "lu";
    public static final String FIELD_UTILS = "fu";
    public static final String STRING_UTILS = "su";
    public static final String PIN_FORMATTER = "pf";
    public static final String SUM_FORMATTER = "sf";
    public static final String STRING = "string";
    public static final String ENV_UTILS = "env";
    public static final String UPDATE_SIZE = "update_size";
    public static final String DEALER_BALANCE = "dealer_balance";
    public static final String USSD_RESULT = "ussd_result";
    public static final String MODEM_USSD = "modem_ussd";
    public static final String CBC_ERROR = "pay_cbc_error";
    public static final String PAYMENT_STATE = "payment_state";
    public static final String TERMINAL_STATE = "terminal_state";
    public static final String TERMINAL_STATE_ERROR = "terminal_state_error";
    public static final String TERMINAL_STATE_WARNING = "terminal_state_warning";
    public static final String TERMINAL_STATE_RECOM = "terminal_recommendation";
    public static final String COMMISSION_VIEW = "commission_view";
    public static final String COMMISSION_VIEW_FULL = "commission_view_full";
    public static final String INPUT_NUMBER = "input_number";
    public static final String MENU_USER = "menu_user";
    public static final String PAY_DELAY = "pay_delay";
    public static final String PRN_ERROR = "prn_error";
    public static final String PRN_ERROR_CONFIRM = "prn_error_confirm";
    public static final String PRN_AD = "adv";
    public static final String MULTYCASH = "multycash";
    public static final String COUNT_FROM = "count_from";
    public static final String COUNT_TO = "count_to";
    public static final String BARCODE = "barcode";
    public static final String PAYMENTS_VIEW = "payments_view";
    public static final String PAYMENT_ENDING_STATE = "pes";
    public static final String PAYMENT_TEMPLATE_STATE = "pts";
    public static final String SUM_0 = "s0";
    public static final String IN_CURR = "in_curr";
    public static final String IN_CURR_NAME = "in_curr_name";
    public static final String KKM_MESSAGE = "kkm_message";
    public static final String FIELDS_LAST_PAGE = "fields_last_page";
    public static final String KEEPER_LOGIN = "keeper.login";
    public static final String LAST_BOX_REFILL = "box.refill";
    public static final String LAST_BOX_COLLECTION = "box.collection";
    public static final String CURRENT_MODULE = "current_module";
    public static final String DEALER = "dealer";
    public static final String DEALER_PARAMS = "dealer_params";
    public static final String MENUITEM = "menuitem";
    public static final String POINT = "point";
    public static final String WEATHER = "weather";
    public static final String POINT_PARAMS = "point_params";
    public static final String PAYMENT_SYSTEM = "ps";
    public static final String MENU = "menu";
    public static final String SUMCHANGE = "sumchange";
    public static final String MAXCASH = "maxcash";
    public static final String MINCASH = "mincash";
    public static final String CASHLIST = "cashlist";
    public static final String OPERATION = "operation";
    public static final String SERVICE_TYPE = "st";
    public static final String SERVICE_TYPE_LANG = "stl";
    public static final String SERVICE = "service";
    public static final String SERVICE_PARAMS = "service_params";
    public static final String SERVICE_COUNTRY = "service_country";
    public static final String SERVICE_AREA = "service_area";
    public static final String SERVICE_LANG = "service_lang";
    public static final String OPERATOR = "operator";
    public static final String PROVIDER = "provider";
    public static final String SERVICE_DONATE = "service_donate";
    public static final String MONEY_COLLECTION = "mc";
    public static final String COMMISSION = "commission";
    public static final String VERIFY_RESULT = "ver_result";
    public static final String OPERATION_TIME = "date";
    public static final String ENDING_MESSAGE = "ending_message";
    public static final String SUM_INCOME = "sum_income";
    public static final String SUM_OUTCOME = "sum_outcome";
    public static final String SUM_COMM = "sum_comm";
    public static final String SUM_CHANGE = "sum_change";
    public static final String SUM_MAX = "sum_max";
    public static final String SUM_MIN = "sum_min";
    public static final String SUM_NEED = "sum_need";
    public static final String SUM_PURCHASE = "sum_purchase";
    public static final String SUM_RECOMMEND = "sum_recommend";
    public static final String SUM_DONATE = "sum_donate";
    public static final String MIN_CASH = "min_cash";
    public static final String MAX_CASH = "max_cash";
    public static final String CHANGE_NUMBER = "chnumber";
    public static final String CHANGE_SERVICE = "chservice";
    public static final String CHANGE_MOB_NUMBER = "change_number";
    public static final String CASH_DEV_ENABLED = "cash_dev_enabled";
    public static final String MIN_SUM_PURCHASE = "min_sum_purchase";
    public static final String MAX_SUM_PURCHASE = "max_sum_purchase";
    public static final String PAYMENT_SOURCE = "payment_source";
    public static final String BILL_STATE = "bill_acceptor_state";
    public static final String PRINTER_STATE = "printer_state";
    public static final String LAST_COLLECTION_DATE = "last_collection_date";
    public static final String CURRENT_COLLECTION_SUM = "bill_collection_sum";
    public static final String MODEM_STATE = "modem_state";
    public static final String MODEM_NETWORK = "modem_network";
    public static final String MODEM_INFO = "modem_info";
    public static final String MODEM_LAST_CHECK = "modem_last_check";
    public static final String EXCHANGE_AVAILABLE_NOMINALS = "available_nominal";
    public static final String EXCHANGE_ACCEPTED_SUM = "accepted_sum";
    public static final String EXCHANGE_DISPENSED_SUM = "dispensed_sum";
    private static volatile TreeSet<CashUnit> allowedNotes;
    private static volatile TreeSet<CashUnit> allowedCoins;
    private static String currency;
    private static boolean printerError;
    private static Change change;
    private static PayEnv payEnv;
    private static Locale currentLocale;
    private static Locale defaultLocale;
    private static List<String> locales;
    private static int indexlocale;
    private static ServiceType serviceType;
    private static ServiceTypeLang serviceTypeLang;
    private static MenuItem selectedItem;
    private static MenuItem activeItem;
    private static MenuItem redirectItem;
    private static PaymentEndingState paymentEndingState;
    private static List<Payment> payments;
    private static Date lastPaymentDate;
    private static Service service;
    private static ServiceLang serviceLang;
    private static Service serviceDonate;
    private static Integer fraudLock;
    private static Commission commission;
    private static Dealer dealer;
    private static Point point;
    private static Weather weather;
    private static PaymentTemplateState pts;
    private static Map<String, Object> dealerAttributes;
    private static Map<String, Object> pointAttributes;
    private static Map<String, Object> serviceAttributes;
    private static PaymentSystem paymentSystem;
    private static volatile ResourceBundle bundle;
    private static final File bundlePath;
    private static Map<String, Map<String, String>> menuTitles;
    private static ScreenDescription sd;
    private static int activeField;
    private static int fieldPage;
    private static int fieldPageSize;
    private static int fieldPagesCount;
    private static UserAction paymentAction;
    private static ReturnService returnService;
    private static String currentPaymentSource;
    private static final Map<String, Object> data;
    private static final Map<String, Object> defData;
    private static final List<SessionListener> listeners;
    private static final Logger log;
    private static final Logger logDbg;
    private static final SimpleDateFormat weatherSDF;

    public static void resetSession(String lang, String langs) {
        log.debug((Object)("Request lang: " + lang));
        log.debug((Object)("Request langs: " + langs));
        if (lang != null && lang.matches("[a-z]{2}")) {
            if (!currentLocale.getLanguage().equals(lang)) {
                currentLocale = new Locale(lang, defaultLocale.getCountry());
            }
        } else {
            currentLocale = defaultLocale;
        }
        log.debug((Object)("Current locale: " + currentLocale));
        locales = new LinkedList<String>();
        locales.add(currentLocale.getLanguage());
        if (langs != null) {
            Stream.of(langs.trim().split(";")).filter(l -> l.trim().matches("[a-z]{2}")).filter(l -> !locales.contains(l)).forEach(l -> locales.add(l.trim()));
        }
        log.debug((Object)("List locales: " + locales));
        indexlocale = 0;
        Session.resetSession();
    }

    public static synchronized void resetSession() {
        log.info((Object)"Session reset");
        serviceType = null;
        serviceTypeLang = null;
        selectedItem = null;
        activeItem = null;
        service = null;
        serviceLang = null;
        commission = null;
        dealer = null;
        point = null;
        weather = null;
        paymentSystem = null;
        menuTitles = null;
        redirectItem = null;
        data.clear();
        currency = null;
        payments = null;
        Session.setPaymentTemplateState(new PaymentTemplateState());
        Session.setCurrentPaymentSource(null);
        Session.setPaymentEndingState(new PaymentEndingState());
        Session.setServiceDonate(null);
        Session.prefillStore();
        Session.updateSensivityObjects();
        Locale.setDefault(currentLocale);
    }

    private static void prefillStore() {
        data.putAll(defData);
        Session.setItem(MENU, References.getMenu());
        Session.setDealer(References.getDealer());
        Session.setPoint(References.getPoint());
        Session.setPaymentSystem(References.getPaymentSystem());
        Session.setWeather(References.getWeathers());
        Session.setItem(OPERATION_TIME, new Date());
    }

    private static void updateSensivityObjects() {
        B.setLocale((Locale)currentLocale);
        Session.setItem(DATE_FORMAT, DateFormat.getDateTimeInstance(2, 2, currentLocale));
        Session.setItem(DATE_FORMAT_DATE, DateFormat.getDateInstance(2, currentLocale));
        Session.setItem(DATE_FORMAT_TIME, DateFormat.getTimeInstance(2, currentLocale));
        if (bundlePath.exists()) {
            log.debug((Object)("Recreate bundle for locale: " + currentLocale));
            try {
                bundle = ResourceBundle.getBundle("input", currentLocale, new FileControl(bundlePath));
                MessageProcessor.setFormBundle((ResourceBundle)bundle);
            }
            catch (Exception ex) {
                bundle = null;
                MessageProcessor.setFormBundle(null);
                log.error((Object)("updateSensivityObjects -> " + ex.getMessage()));
                GuiNotifier.notifyErrorOnce((String)ex.getMessage());
            }
        }
    }

    public static ResourceBundle getCurrentBundle() {
        return bundle;
    }

    private static void processServiceTypeLang() {
        serviceTypeLang = Session.getServiceTypeLang(serviceType);
        data.put(SERVICE_TYPE_LANG, serviceTypeLang);
    }

    private static ServiceTypeLang getServiceTypeLang(ServiceType st) {
        String lang = currentLocale.getLanguage();
        if (st != null) {
            if (st.getLangs() != null && st.getLangs().containsKey(lang)) {
                return (ServiceTypeLang)st.getLangs().get(lang);
            }
            return new ServiceTypeLang(lang, st.getName(), st.getInvitation());
        }
        return new ServiceTypeLang(lang, "", "");
    }

    private static void processServiceLang() {
        serviceLang = Session.getServiceLang(service);
        data.put(SERVICE_LANG, serviceLang);
    }

    private static ServiceLang getServiceLang(Service srv) {
        String lang = currentLocale.getLanguage();
        if (srv != null) {
            if (srv.getLangs() != null && srv.getLangs().containsKey(lang)) {
                return (ServiceLang)srv.getLangs().get(lang);
            }
            return new ServiceLang(lang, srv.getName(), srv.getPrintName(), srv.getPrintText(), srv.getWarning());
        }
        return new ServiceLang(lang, "", "", "", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateCommissionView() {
        Session.setItem(COMMISSION_VIEW, "");
        Session.setItem(COMMISSION_VIEW_FULL, "");
        Session.setItem("coins", null);
        Session.setItem("notes", null);
        Session.setItem("coins_same_p_value", null);
        Session.setItem("notes_same_p_value", null);
        if (commission != null && activeItem != null) {
            Sum voidSum = FinUtils.createVoidSum();
            Session.setItem("sum_01", new Sum(1, currency));
            if (commission.getUnits() != null && commission.getUnits().size() > 0) {
                HashMap<Integer, CashUnit> unitsList = new HashMap<Integer, CashUnit>();
                for (CashUnit cu : FinUtils.convert(FxEnv.getCashManager().getHdwDenomination(currency))) {
                    unitsList.put(cu.getId(), cu);
                }
                TreeMap<Sum, Sum> coins = new TreeMap<Sum, Sum>();
                TreeMap<Sum, Sum> notes = new TreeMap<Sum, Sum>();
                for (CommissionUnit unit : commission.getUnits()) {
                    if (unit.getFixedValue().getValue() == 0) continue;
                    CashUnit cu = (CashUnit)unitsList.get(unit.getCashUnit());
                    if (cu != null && cu.getType() == 4) {
                        coins.put(cu.getNominal(), unit.getFixedValue());
                        continue;
                    }
                    if (cu == null || cu.getType() != 3) continue;
                    notes.put(cu.getNominal(), unit.getFixedValue());
                }
                if (coins.size() > 0) {
                    Session.setItem("coins", coins);
                    Session.setItem("coins_same_p_value", Session.processPercentNominalComm(coins));
                }
                if (notes.size() > 0) {
                    Session.setItem("notes", notes);
                    Session.setItem("notes_same_p_value", Session.processPercentNominalComm(notes));
                }
            }
            if (commission.getSteps() != null && commission.getSteps().size() > 0) {
                TreeSet<CommissionStep> steps = new TreeSet<CommissionStep>();
                if (!((CommissionStep)commission.getSteps().first()).getSum().equals((Object)voidSum)) {
                    steps.add(new CommissionStep(voidSum, commission.getPercentValue(), commission.getFixedValue()));
                }
                steps.addAll(commission.getSteps());
                Sum mins = service.getMinSum() != null ? service.getMinSum() : new Sum(0, Session.getInCurrency());
                Sum maxs = service.getMaxSum();
                Iterator is = steps.iterator();
                CommissionStep stepmin = null;
                while (is.hasNext()) {
                    CommissionStep step = (CommissionStep)is.next();
                    if (step.getSum().compareTo(maxs) > 0) {
                        is.remove();
                    }
                    if (step.getSum().compareTo(mins) > 0) continue;
                    stepmin = new CommissionStep(mins, step.getPercentValue(), step.getFixedValue());
                    is.remove();
                }
                if (stepmin != null) {
                    steps.add(stepmin);
                }
                if (steps.size() > 0) {
                    Session.setItem("steps", new LinkedList(steps));
                }
            }
            InputStream common = Locator.getInputStream((String)"/gui/skin/{name}/i18n/comm//common{0}.vm", (Locale)Session.getLocale());
            InputStream simple = Locator.getInputStream((String)"/gui/skin/{name}/i18n/comm//simple{0}.vm", (Locale)Session.getLocale());
            if (common == null) {
                common = Locator.getInputStream((String)"/plfx/i18n/comm/common{0}.vm", (Locale)Session.getLocale());
            }
            if (simple == null) {
                simple = Locator.getInputStream((String)"/plfx/i18n/comm/simple{0}.vm", (Locale)Session.getLocale());
            }
            try {
                if (commission.isSimple()) {
                    Session.setItem(COMMISSION_VIEW, TemplateProcessor.processText(IOUtils.toString((InputStream)simple, (String)"UTF-8"), Session.getData(), "simple{0}.vm"));
                    Session.setItem(COMMISSION_VIEW_FULL, TemplateProcessor.processText(IOUtils.toString((InputStream)common, (String)"UTF-8"), Session.getData(), "common{0}.vm"));
                } else {
                    Session.setItem(COMMISSION_VIEW_FULL, TemplateProcessor.processText(IOUtils.toString((InputStream)common, (String)"UTF-8"), Session.getData(), "common{0}.vm"));
                }
            }
            catch (Exception ex) {
                log.info((Object)ex, (Throwable)ex);
            }
            finally {
                IOUtils.closeQuietly((InputStream)common);
                IOUtils.closeQuietly((InputStream)simple);
            }
        }
    }

    private static Double processPercentNominalComm(TreeMap<Sum, Sum> src) {
        if (src == null || src.isEmpty()) {
            return null;
        }
        boolean first = true;
        Double prev = null;
        for (Sum s : src.keySet()) {
            Double current = (double)src.get(s).getValue() / (double)s.getValue() * 100.0;
            if (first) {
                prev = current;
                first = false;
                continue;
            }
            if (current.equals(prev)) continue;
            return null;
        }
        return prev;
    }

    private static void updatePaymentsView() {
        Session.setItem(PAYMENTS_VIEW, "");
        if (payments != null) {
            Session.setItem("payments", payments);
            InputStream paysTpl = Locator.getInputStream((String)"/gui/skin/{name}/i18n/pays//payments{0}.vm", (Locale)Session.getLocale());
            if (paysTpl == null) {
                paysTpl = Locator.getInputStream((String)"/plfx/i18n/pays/payments{0}.vm", (Locale)Session.getLocale());
            }
            try {
                Session.setItem(PAYMENTS_VIEW, TemplateProcessor.processText(IOUtils.toString((InputStream)paysTpl, (String)"UTF-8"), Session.getData(), "payments{0}.vm"));
            }
            catch (Exception ex) {
                log.info((Object)ex, (Throwable)ex);
            }
            finally {
                IOUtils.closeQuietly((InputStream)paysTpl);
            }
        }
    }

    public static void calculatePurchaseRange() {
        Sum maxSum;
        Service srv = Session.getService();
        if (srv == null) {
            throw new IllegalStateException("Service is not set");
        }
        if (srv.getMaxSum().isEmpty() || srv.getMaxSum().compareTo(srv.getMinSum()) < 0) {
            throw new IllegalArgumentException("Max service sum is wrong, srv: " + srv.getId() + ", max:" + srv.getMaxSum());
        }
        Commission comm = Session.getCommission();
        if (comm == null) {
            Session.setItem(MIN_SUM_PURCHASE, srv.getMinSum());
            Session.setItem(MAX_SUM_PURCHASE, srv.getMaxSum());
            return;
        }
        Sum minSum = srv.getMinSum();
        try {
            maxSum = BaseCommissionCalculator.calculateMaxPurchase(srv.getMaxSum(), comm);
        }
        catch (IllegalArgumentException ex) {
            maxSum = srv.getMaxSum();
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        Session.calculatePurchaseRange(minSum, maxSum);
    }

    public static void calculatePurchaseRange(Sum minSum, Sum maxSum) {
        Session.setItem(MIN_SUM_PURCHASE, minSum);
        Session.setItem(MAX_SUM_PURCHASE, maxSum);
        NumericExternalValidator.setRange((Range)new Range((float)minSum.getValue() / 100.0f, (float)maxSum.getValue() / 100.0f));
    }

    @Deprecated
    public static Set<CashUnit> getAllowedUnits(MenuItem menuItem, int type) {
        return Session.getAllowedUnits(menuItem, type, null);
    }

    public static TreeSet<CashUnit> getAllowedUnits(MenuItem menuItem, int type, Date date) {
        CashUnitProfile cupPoint = null;
        try {
            cupPoint = References.getPointOptions().getCashUnitProfile();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (cupPoint != null) {
            log.info((Object)"Use new method");
            CashUnitProfile cupMenu = menuItem != null ? menuItem.getCashUnitProfile() : null;
            return Session.getAllowedUnitsNew(menuItem, cupPoint, cupMenu, type, date);
        }
        log.info((Object)"Use old method");
        CashUnit[] pointUnits = null;
        try {
            pointUnits = References.getPointOptions().getUnits();
        }
        catch (Exception exception) {
            // empty catch block
        }
        CashUnit[] menuUnits = menuItem.getUnits();
        SessionHelper.printUnits("Point restriction: ", pointUnits);
        SessionHelper.printUnits("Menu restriction: ", menuUnits);
        return Session.getAllowedUnitsOld(menuItem, pointUnits, menuUnits, type);
    }

    public static TreeSet<CashUnit> getAllowedUnitsNew(MenuItem menuItem, CashUnitProfile cupPoint, CashUnitProfile cupMenu, int type, Date date) {
        if (type != 4 && type != 3) {
            throw new IllegalArgumentException("Type is wrong");
        }
        TreeSet<CashUnit> allowed = new TreeSet<CashUnit>();
        try {
            SessionHelper.printUnits("Point restriction: ", cupPoint.getCashUnitGroups());
            SessionHelper.printUnits("Menu restriction: ", cupMenu == null ? null : cupMenu.getCashUnitGroups());
            CompatCashProfile cp = CompatCashFactory.getProfile(menuItem.getService().getInCurrency());
            CashUnit[] currUnits = type == 4 ? cp.getCoinUnits() : cp.getCashUnits();
            SessionHelper.printUnits("Currency set:", currUnits);
            for (CashUnit cu : currUnits) {
                if (!Session.present(cu, cupPoint, date) || !Session.present(cu, cupMenu, date)) continue;
                allowed.add(cu);
            }
            if (allowed.isEmpty() && Session.isEmptyCashUnitProfile(type, cupPoint) && Session.isEmptyCashUnitProfile(type, cupMenu)) {
                allowed.addAll(Arrays.asList(currUnits));
            }
        }
        catch (CashProfileException ex) {
            log.error((Object)"Error on process cash units", (Throwable)ex);
        }
        SessionHelper.printUnits("Result:", allowed.toArray(new CashUnit[allowed.size()]));
        return allowed;
    }

    public static TreeSet<CashUnit> getAllowedUnitsOld(MenuItem menuItem, CashUnit[] pointUnits, CashUnit[] menuUnits, int type) {
        if (type != 4 && type != 3) {
            throw new IllegalArgumentException("Type is wrong");
        }
        TreeSet<CashUnit> allowed = new TreeSet<CashUnit>();
        try {
            CompatCashProfile cp = CompatCashFactory.getProfile(menuItem.getService().getInCurrency());
            CashUnit[] currUnits = type == 4 ? cp.getCoinUnits() : cp.getCashUnits();
            SessionHelper.printUnits("Currency set:", currUnits);
            for (CashUnit cu : currUnits) {
                if (!Session.present(cu, pointUnits) || !Session.present(cu, menuUnits)) continue;
                allowed.add(cu);
            }
            if (allowed.isEmpty()) {
                allowed.addAll(Arrays.asList(currUnits));
            }
        }
        catch (CashProfileException ex) {
            log.error((Object)"Error on process cash units", (Throwable)ex);
        }
        SessionHelper.printUnits("Result:", allowed.toArray(new CashUnit[allowed.size()]));
        return allowed;
    }

    private static boolean present(CashUnit cu, CashUnit[] units) {
        if (units == null || units.length == 0) {
            return true;
        }
        if (cu == null) {
            return false;
        }
        for (CashUnit unit : units) {
            if (!cu.equals((Object)unit)) continue;
            return true;
        }
        return false;
    }

    private static boolean present(CashUnit cu, CashUnitProfile cup, Date date) {
        if (cup == null) {
            return true;
        }
        if (cu == null) {
            return false;
        }
        if (cu.getType() == 4 && !cup.hasFlag((short)2) || cu.getType() == 3 && !cup.hasFlag((short)1)) {
            return false;
        }
        if (cup.getCashUnitGroups() == null || cup.getCashUnitGroups().length == 0) {
            return true;
        }
        for (CashUnitGroup cug : cup.getCashUnitGroups()) {
            if (!cu.equals((Object)cug.getCashUnit())) continue;
            if (cup.hasFlag((short)4) && date != null) {
                return Session.isEnable(cug, date);
            }
            return cug.isEnable();
        }
        return true;
    }

    private static boolean isEnable(CashUnitGroup cug, Date date) {
        if (!cug.isEnable()) {
            return false;
        }
        Calendar now = Calendar.getInstance();
        Calendar st = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        now.setTime(date);
        if (cug.getStartTime() != null) {
            st.setTime(cug.getStartTime());
        } else {
            st.set(11, 0);
            st.set(12, 0);
            st.set(13, 0);
        }
        st.set(1, now.get(1));
        st.set(2, now.get(2));
        st.set(5, now.get(5));
        if (cug.getEndTime() != null) {
            end.setTime(cug.getEndTime());
        } else {
            end.set(11, 23);
            end.set(12, 59);
            end.set(13, 59);
        }
        end.set(1, now.get(1));
        end.set(2, now.get(2));
        end.set(5, now.get(5));
        if (st.after(now) || end.before(now)) {
            return false;
        }
        return cug.isEnable();
    }

    private static boolean isEmptyCashUnitProfile(int type, CashUnitProfile cup) {
        if (cup == null) {
            return true;
        }
        if (type == 4 && !cup.hasFlag((short)2) || type == 3 && !cup.hasFlag((short)1)) {
            return false;
        }
        if (cup.getCashUnitGroups() == null || cup.getCashUnitGroups().length == 0) {
            return true;
        }
        for (CashUnitGroup cug : cup.getCashUnitGroups()) {
            if (cug.getCashUnit().getType() != type) continue;
            return false;
        }
        return true;
    }

    public static Locale getLocale() {
        return currentLocale;
    }

    public static void setLanguage(String lang) {
        currentLocale = new Locale(lang, defaultLocale.getCountry());
        log.info((Object)("Set locale : " + currentLocale));
        Locale.setDefault(currentLocale);
        Session.processServiceTypeLang();
        Session.processServiceLang();
        Session.updateCommissionView();
        Session.updatePaymentsView();
        Session.updateSensivityObjects();
        Session.notifyLocale();
    }

    public static void setNextLanguage() {
        indexlocale = (indexlocale + 1) % locales.size();
        Session.setLanguage(locales.get(indexlocale));
    }

    public static Map<String, Object> getData() {
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.putAll(data);
        if (ModuleStore.getModule() != null) {
            ModuleStore.getModule().getModuleData().ifPresent(res::putAll);
        }
        SessionHelper.printContent(res);
        return res;
    }

    public static void setItem(String id, Object value) {
        data.put(id, value);
    }

    public static void setDefaultItem(String id, Object value) {
        defData.put(id, value);
    }

    public static void addListener(SessionListener listener) {
        if (listener == null) {
            throw new NullPointerException("Session listener is null");
        }
        listeners.add(listener);
    }

    public static void notifyUpdate() {
        log.debug((Object)("Notify screen update: " + currentLocale));
        LoggerId.GUI.info((Object)("Notify screen update: " + currentLocale));
        listeners.stream().forEach(sl -> sl.onUpdateScreen());
    }

    private static void notifyLocale() {
        log.info((Object)("Notify new locale: " + currentLocale));
        LoggerId.GUI.info((Object)("Notify new locale: " + currentLocale));
        listeners.stream().forEach(sl -> sl.onChangeLocale(currentLocale));
    }

    public static MenuItem getSelectedItem() {
        return selectedItem;
    }

    public static void setSelectedItem(MenuItem menuItem) {
        if (menuItem == null) {
            throw new NullPointerException("Session: MenuItem is not set");
        }
        selectedItem = menuItem;
        data.put(MENUITEM, menuItem);
        Session.setActiveItem(menuItem);
    }

    public static MenuItem getActiveItem() {
        return activeItem;
    }

    public static void setActiveItem(MenuItem menuItem) {
        if (menuItem == null) {
            throw new NullPointerException("Session: MenuItem is not set");
        }
        if (menuItem.equals((Object)activeItem)) {
            return;
        }
        activeItem = menuItem;
        log.debug((Object)"Build allowed units");
        Date now = new Date();
        allowedCoins = Session.getAllowedUnits(menuItem, 4, now);
        allowedNotes = Session.getAllowedUnits(menuItem, 3, now);
        if (!allowedNotes.isEmpty()) {
            data.put(MINCASH, allowedNotes.first());
            data.put(MAXCASH, allowedNotes.last());
            data.put(CASHLIST, Session.getNominalsList(allowedNotes));
        } else {
            data.put(MINCASH, null);
            data.put(MAXCASH, null);
        }
        Session.setService(menuItem.getService());
        if (menuItem.getServiceType() != null) {
            Session.setServiceType(menuItem.getServiceType());
        }
        Session.setCommission(menuItem.getCommission());
        Session.calculatePurchaseRange();
    }

    private static String getNominalsList(TreeSet<CashUnit> units) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (CashUnit cu : units) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(cu.getNominal().getValue() / 100);
        }
        return sb.toString();
    }

    public static MenuItem getRedirectItem() {
        return redirectItem;
    }

    public static void setRedirectItem(MenuItem redirectItem) {
        Session.redirectItem = redirectItem;
    }

    public static ServiceType getServiceType() {
        return serviceType;
    }

    public static void setServiceType(ServiceType serviceType) {
        if (serviceType == null) {
            throw new NullPointerException("Session: ServiceType is not set");
        }
        Session.serviceType = serviceType;
        data.put(SERVICE_TYPE, serviceType);
        Session.processServiceTypeLang();
    }

    public static Service getService() {
        return service;
    }

    public static void setService(Service service) {
        String curr;
        if (service == null) {
            throw new NullPointerException("Session: Service is not set");
        }
        Session.service = service;
        data.put(SERVICE, service);
        data.put(OPERATOR, service.getOperator());
        data.put(PROVIDER, service.getProvider());
        currency = curr = CompatCashFactory.getCurrency(service.getInCurrency());
        Session.setItem(SUM_0, new Sum(0, curr));
        Session.setItem(IN_CURR, curr);
        Session.setItem(IN_CURR_NAME, Currency.getInstance(currency).getSymbol(currentLocale));
        Session.setItem(SERVICE_COUNTRY, GeoUtils.getCountryById(service.getIdCountry()));
        Session.setItem(SERVICE_AREA, GeoUtils.getGeographicAreaById(service.getIdGeographicArea()));
        serviceAttributes = new HashMap<String, Object>();
        if (service.getProperties() != null) {
            serviceAttributes.putAll(service.getProperties());
        }
        Session.setItem(SERVICE_PARAMS, serviceAttributes);
        Optional.ofNullable((String)Session.getAttribute("donate.service.id")).ifPresent(id -> {
            MenuByServiceIdVisitor visitor = new MenuByServiceIdVisitor(Short.valueOf(id));
            fxterm.core.menu.MenuUtils.processMenu(visitor);
            Optional.ofNullable(visitor.getMenuItem()).map(MenuItem::getService).ifPresent(Session::setServiceDonate);
        });
        Session.processServiceLang();
    }

    public static Map<String, Object> getServiceAttributes() {
        return serviceAttributes;
    }

    public static ServiceLang getServiceLang() {
        return serviceLang;
    }

    public static Commission getCommission() {
        return commission;
    }

    public static void setCommission(Commission commission) {
        if (commission == null) {
            throw new NullPointerException("Session: Commission is not set");
        }
        Session.commission = commission;
        data.put(COMMISSION, commission);
        if (Session.commission != null && currentPaymentSource != null && Boolean.TRUE.equals(commission.getUsePaymentSources())) {
            Commission com = new Commission(commission);
            if (commission.getSteps() != null) {
                com.setSteps(commission.getSteps().stream().filter(step -> Objects.equals(step.getPaymentSource(), currentPaymentSource)).collect(Collectors.toCollection(TreeSet::new)));
            }
            Session.commission = com;
        }
        Session.updateCommissionView();
    }

    public static void setPayEnv(PayEnv payEnv) {
        Session.payEnv = payEnv;
    }

    public static PayEnv getPayEnv() {
        return payEnv;
    }

    public static String getCurrentPaymentSource() {
        return currentPaymentSource;
    }

    public static void setCurrentPaymentSource(String currentPaymentSource) {
        Session.setItem(PAYMENT_SOURCE, currentPaymentSource);
        Session.currentPaymentSource = currentPaymentSource;
    }

    public static Change getChange() {
        return change;
    }

    public static Change getChangeAndReset() {
        Change ch = change;
        change = null;
        defData.put(SUMCHANGE, new Sum(0, CompatCashFactory.getSystemCurrency()));
        data.put(SUMCHANGE, new Sum(0, CompatCashFactory.getSystemCurrency()));
        SaveUtils.deleteChange();
        return ch;
    }

    public static void setChange(Change change) {
        Session.change = change;
        if (change != null && change.getSum() != null) {
            defData.put(SUMCHANGE, change.getSum());
            SaveUtils.saveChange(change);
        } else {
            defData.put(SUMCHANGE, new Sum(0, CompatCashFactory.getSystemCurrency()));
        }
        Session.notifyUpdate();
    }

    public static Service getServiceDonate() {
        return serviceDonate;
    }

    public static void setServiceDonate(Service donateservice) {
        serviceDonate = donateservice;
        data.put(SERVICE_DONATE, donateservice);
    }

    public static PaymentEndingState getPaymentEndingState() {
        return paymentEndingState;
    }

    public static void setPaymentEndingState(PaymentEndingState paymentEndingState) {
        Session.paymentEndingState = paymentEndingState;
        data.put(PAYMENT_ENDING_STATE, paymentEndingState);
    }

    public static PaymentTemplateState getPaymentTemplateState() {
        return pts;
    }

    public static void setPaymentTemplateState(PaymentTemplateState pts) {
        Session.pts = pts;
        data.put(PAYMENT_TEMPLATE_STATE, pts);
    }

    public static List<Payment> getPayments() {
        return payments;
    }

    public static void setPayments(List<Payment> payments) {
        Session.payments = payments;
        Session.updatePaymentsView();
    }

    public static Dealer getDealer() {
        return dealer;
    }

    public static void setDealer(Dealer dealer) {
        Session.dealer = dealer;
        data.put(DEALER, dealer);
        dealerAttributes = new HashMap<String, Object>();
        Session.setItem(DEALER_PARAMS, null);
        if (dealer != null) {
            if (dealer.getProperties() != null) {
                dealerAttributes.putAll(dealer.getProperties());
            }
            Session.setItem(DEALER_PARAMS, dealerAttributes);
        }
    }

    public static Map<String, Object> getDealerAttributes() {
        return dealerAttributes;
    }

    public static Point getPoint() {
        return point;
    }

    public static void setPoint(Point point) {
        String params;
        Session.point = point;
        data.put(POINT, point);
        pointAttributes = new HashMap<String, Object>();
        Session.setItem(POINT_PARAMS, null);
        if (point != null && (params = point.getParams()) != null) {
            params = params.replace("<br/>", "\n");
            Properties pr = new Properties();
            try {
                pr.load(new StringReader(params));
                for (String name : pr.stringPropertyNames()) {
                    pointAttributes.put(name, pr.getProperty(name));
                }
                if (point.getAttributes() != null) {
                    pointAttributes.putAll(point.getAttributes());
                }
                Session.setItem(POINT_PARAMS, pointAttributes);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static Weather getWeather() {
        return weather;
    }

    public static void setWeather(Weather[] weathers) {
        if (weathers == null || weathers.length == 0) {
            weather = null;
        } else {
            for (Weather w : weathers) {
                if (w == null || w.getForecastDate() == null || !weatherSDF.format(new Date()).equals(weatherSDF.format(w.getForecastDate()))) continue;
                weather = w;
                break;
            }
        }
        data.put(WEATHER, weather);
    }

    public static Map<String, Object> getPointAttributes() {
        return pointAttributes;
    }

    public static Object getAttribute(String id) {
        if (serviceAttributes.get(id) != null) {
            return serviceAttributes.get(id);
        }
        if (pointAttributes.get(id) != null) {
            return pointAttributes.get(id);
        }
        return dealerAttributes.get(id);
    }

    public static PaymentSystem getPaymentSystem() {
        return paymentSystem;
    }

    public static void setPaymentSystem(PaymentSystem paymentSystem) {
        Session.paymentSystem = paymentSystem;
        data.put(PAYMENT_SYSTEM, paymentSystem);
    }

    public static boolean isPrinterError() {
        return printerError;
    }

    public static void setPrinterError(boolean printerError) {
        Session.printerError = printerError;
        Session.setItem(PRN_ERROR, printerError);
    }

    public static Integer getFraudLock() {
        return fraudLock;
    }

    public static void setFraudLock(Integer fraudLock) {
        Session.fraudLock = fraudLock;
    }

    public static void setMenuTitles(Map<String, Map<String, String>> menuTitles) {
        Session.menuTitles = menuTitles;
    }

    public static void setScreenDescription(ScreenDescription sd) {
        Session.sd = sd;
        activeField = 0;
        fieldPage = 0;
        fieldPageSize = Optional.ofNullable(sd.getSequence()).map(FieldSequence::getFields).map(List::size).orElse(0);
        fieldPagesCount = 1;
    }

    public static void setActiveField(int activeField) {
        boolean needUpdate = Session.activeField != activeField;
        Session.activeField = activeField;
        if (needUpdate) {
            Session.notifyUpdate();
        }
    }

    public static void setFieldPage(int nPage, int pSize) {
        boolean needUpdate = fieldPage != nPage || fieldPageSize != pSize;
        fieldPage = nPage;
        fieldPageSize = pSize;
        int total = Optional.ofNullable(sd.getSequence()).map(FieldSequence::getFields).map(List::size).orElse(0);
        fieldPagesCount = total / pSize + (total % pSize > 0 ? 1 : 0);
        data.put(FIELDS_LAST_PAGE, fieldPagesCount == nPage + 1);
        if (needUpdate) {
            Session.notifyUpdate();
        }
    }

    public static Date getLastPaymentDate() {
        return lastPaymentDate;
    }

    public static void setLastPaymentDate(Date lastPaymentDate) {
        Session.lastPaymentDate = lastPaymentDate;
    }

    public static void setCurrentModule(int module) {
        Session.setItem(CURRENT_MODULE, module);
    }

    public static Set<CashUnit> getAllowedCoins() {
        return allowedCoins;
    }

    public static Set<CashUnit> getAllowedNotes() {
        return allowedNotes;
    }

    public static String getInCurrency() {
        return currency;
    }

    public static Lang getLang() {
        return new Lang(currentLocale.getLanguage(), StringUtils.capitalize((String)currentLocale.getDisplayLanguage(currentLocale)));
    }

    public static ObservableList<Lang> getLangs() {
        ObservableList langs = FXCollections.observableArrayList();
        if (locales != null) {
            for (String code : locales) {
                Locale l = new Locale(code);
                langs.add((Object)new Lang(code, StringUtils.capitalize((String)l.getDisplayLanguage(l))));
            }
        }
        return langs;
    }

    private static DecimalFormat createDecimalFormat() {
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        df.setMinimumFractionDigits(0);
        DecimalFormatSymbols dfs = df.getDecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        df.setDecimalFormatSymbols(dfs);
        df.setGroupingUsed(false);
        return df;
    }

    public static UserAction getPaymentAction() {
        return paymentAction;
    }

    public static void setPaymentAction(UserAction paymentAction) {
        Session.paymentAction = paymentAction;
    }

    public static ReturnService getReturnService() {
        return returnService;
    }

    public static void setReturnService(ReturnService returnService) {
        Session.returnService = returnService;
    }

    public static ModemStateInfo getModemInfo() {
        Date date = (Date)defData.get(MODEM_LAST_CHECK);
        if (date != null) {
            String state = (String)defData.get(MODEM_STATE);
            NetworkInfo networkInfo = (NetworkInfo)defData.get(MODEM_NETWORK);
            DeviceInfo devInfo = (DeviceInfo)defData.get(MODEM_INFO);
            return new ModemStateInfo(state, networkInfo, devInfo, date);
        }
        return null;
    }

    static {
        currentLocale = Locale.getDefault();
        defaultLocale = Locale.getDefault();
        dealerAttributes = new HashMap<String, Object>();
        pointAttributes = new HashMap<String, Object>();
        serviceAttributes = new HashMap<String, Object>();
        bundlePath = PathUtils.getFilePath((String)"/res/module/i18n");
        data = new HashMap<String, Object>();
        defData = new HashMap<String, Object>();
        listeners = new LinkedList<SessionListener>();
        log = LoggerId.PAY;
        logDbg = LoggerId.DEBUG;
        weatherSDF = new SimpleDateFormat("ddMMyyyy");
        defData.put(JAVA_VERSION, System.getProperty("java.version"));
        defData.put(JAVAFX_VERSION, System.getProperty("javafx.runtime.version"));
        defData.put(TERMINAL_VERSION, DaemonVersion.version + "/" + DaemonUtil.getUpdateBuild());
        defData.put(TERMINAL_HOME, PathUtils.getAppHome().replace("\\", "/"));
        defData.put(MENU_UTILS, new MenuUtils());
        defData.put(FIELD_UTILS, new FieldUtils());
        defData.put(LOCALIZATION_UTILS, new LocalizationUtils());
        defData.put(STRING_UTILS, new StringUtils());
        defData.put(PIN_FORMATTER, new TextHelper());
        defData.put(SUM_FORMATTER, new SumFormatter());
        defData.put(STRING, new String());
        defData.put(MULTYCASH, false);
        defData.put(DECIMAL_FORMAT, Session.createDecimalFormat());
        defData.put("out", System.out);
        defData.put(BARCODE, BarcodeUtils.class);
    }

    public static class LocalizationUtils {
        public static String get(String id) {
            if (bundle != null && id != null && !id.isEmpty()) {
                try {
                    logDbg.debug((Object)("Get localization for id: " + id));
                    return TemplateProcessor.processText(bundle.getString(id), Session.getData(), "localization");
                }
                catch (Exception ex) {
                    GuiNotifier.notifyProblemOnce((String)("Wrong form localization for id: " + id));
                }
            }
            return id;
        }

        public static ServiceLang byLocale(Service service) {
            return Session.getServiceLang(service);
        }

        public static ServiceTypeLang byLocale(ServiceType st) {
            return Session.getServiceTypeLang(st);
        }
    }

    public static class MenuUtils {
        public String getTitle(String id) {
            Map langs;
            if (menuTitles != null && (langs = (Map)menuTitles.get(id)) != null) {
                String title = (String)langs.get(currentLocale.getLanguage());
                if (title == null) {
                    title = (String)langs.get("_");
                }
                if (title != null) {
                    return title;
                }
            }
            return id;
        }

        public String toString() {
            return "MenuUtils{}";
        }
    }

    public static class FieldUtils {
        private Optional<IdentityField> getField(int n) {
            int realId = fieldPage * fieldPageSize + n;
            return Optional.ofNullable(sd).map(ScreenDescription::getSequence).map(FieldSequence::getFields).filter(l -> l.size() > realId).map(l -> (IdentityField)l.get(realId));
        }

        public String getTitle() {
            logDbg.debug((Object)"Get title from active field");
            return this.getTitle(activeField);
        }

        public String getTitle(int id) {
            logDbg.debug((Object)("Get title id=" + id));
            Optional<IdentityField> idf = this.getField(id);
            String res = "";
            if (idf.isPresent()) {
                if (idf.get().getTitle() != null) {
                    res = idf.get().getTitle();
                }
                if (bundle != null && idf.get().getTitleId() != null && !idf.get().getTitleId().isEmpty()) {
                    try {
                        res = bundle.getString(idf.get().getTitleId());
                    }
                    catch (Exception ex) {
                        GuiNotifier.notifyProblemOnce((String)("Wrong form field resource id: " + idf.get().getTitleId()));
                    }
                }
                return res;
            }
            return "field_" + id;
        }

        public String getMessage() {
            logDbg.debug((Object)"Get message from active field");
            return this.getMessage(activeField);
        }

        public String getMessage(int id) {
            logDbg.debug((Object)("Get message id=" + id));
            Optional<IdentityField> idf = this.getField(id);
            String res = "";
            if (idf.isPresent()) {
                if (idf.get().getMessage() != null) {
                    res = idf.get().getMessage();
                }
                if (bundle != null && idf.get().getMessageId() != null && !idf.get().getMessageId().isEmpty()) {
                    try {
                        res = bundle.getString(idf.get().getMessageId());
                    }
                    catch (Exception ex) {
                        GuiNotifier.notifyProblemOnce((String)("Wrong form field resource id: " + idf.get().getTitleId()));
                    }
                }
            }
            return res;
        }

        public String getHelp() {
            logDbg.debug((Object)"Get help from active field");
            return this.getHelp(activeField);
        }

        public String getHelp(int id) {
            logDbg.debug((Object)("Get help id=" + id));
            String res = "";
            Optional<IdentityField> idf = this.getField(id);
            if (idf.isPresent()) {
                String help = idf.get().getHelpBySoftwareType(SoftwareType.Terminal);
                if (help != null) {
                    res = TemplateProcessor.processText(help, Session.getData(), "getHelp(" + id + ")");
                }
                if (bundle != null && idf.get().getHelpId() != null && !idf.get().getHelpId().isEmpty()) {
                    try {
                        res = TemplateProcessor.processText(bundle.getString(idf.get().getHelpId()), Session.getData(), idf.get().getHelpId());
                        logDbg.debug((Object)("help: " + res));
                        return res;
                    }
                    catch (Exception ex) {
                        GuiNotifier.notifyProblemOnce((String)("Wrong form field resource help id: " + idf.get().getHelpId()));
                    }
                }
            }
            return res;
        }

        public String getScreenTitle() {
            if (sd != null) {
                String titleId = sd.getTitleId();
                if (bundle != null && titleId != null && !titleId.isEmpty()) {
                    try {
                        return bundle.getString(titleId);
                    }
                    catch (Exception ex) {
                        GuiNotifier.notifyProblemOnce((String)("Wrong form title id: " + titleId));
                    }
                }
                return sd.getTitle();
            }
            return "title";
        }

        public String getScreenSubtitle() {
            if (sd != null) {
                return sd.getSubtitle();
            }
            return "";
        }

        public String getDonateHelp() {
            return TemplateProcessor.processTextQuietly(PathUtils.getPath((String)"/res/module/donate/help_input{0}.html"));
        }

        public String getImg(String name) {
            if (name == null) {
                return null;
            }
            return Locator.getPath((String)("/gui/skin/{name}/img/" + name));
        }

        public String getExample() {
            Optional<IdentityField> idf = this.getField(activeField);
            if (idf.isPresent() && idf.get() instanceof InputField) {
                InputField f = (InputField)idf.get();
                return f.getExampleValue();
            }
            return "";
        }

        public String toString() {
            return "FieldUtils{}";
        }
    }
}

