/*
 * Decompiled with CFR 0.152.
 */
package fxterm.session;

import java.util.HashMap;
import java.util.Map;
import plfx.GuiNotifier;
import ru.softlogic.hdw.dev.printer.pos.img.BarcodeException;
import ru.softlogic.hdw.dev.printer.pos.img.BarcodeGenerator;

public class BarcodeUtils {
    private BarcodeUtils() {
    }

    public static final String genQR(String data) throws BarcodeException {
        return BarcodeUtils.genQR(data, null, null);
    }

    public static final String genQR(String data, String filename) throws BarcodeException {
        return BarcodeUtils.genQR(data, filename, null);
    }

    public static final String genQR(String data, String filename, String params) throws BarcodeException {
        BarcodeUtils.check(data);
        return BarcodeGenerator.generateQRCode((String)data, BarcodeUtils.getParams(params)).getAbsolutePath();
    }

    public static final String genTagQR(String data) {
        return BarcodeUtils.genTagQR(data, null);
    }

    public static final String genTagQR(String data, String filename) {
        try {
            String path = BarcodeUtils.genQR(data, filename, null);
            return "<img src=\"file:///" + path + "\">";
        }
        catch (BarcodeException ex) {
            GuiNotifier.notifyProblemOnce((String)ex.getMessage());
            return "";
        }
    }

    public static final String genPDF417(String data) throws BarcodeException {
        return BarcodeUtils.genPDF417(data, null, null);
    }

    public static final String genPDF417(String data, String filename) throws BarcodeException {
        return BarcodeUtils.genPDF417(data, filename, null);
    }

    public static final String genPDF417(String data, String filename, String params) throws BarcodeException {
        BarcodeUtils.check(data);
        return BarcodeGenerator.generatePDF417((String)data, BarcodeUtils.getParams(params)).getAbsolutePath();
    }

    public static final String genTagPDF417(String data) {
        return BarcodeUtils.genTagPDF417(data, null);
    }

    public static final String genTagPDF417(String data, String filename) {
        try {
            String path = BarcodeUtils.genPDF417(data, filename, null);
            return "<img src=\"file:///" + path + "\">";
        }
        catch (BarcodeException ex) {
            GuiNotifier.notifyProblemOnce((String)ex.getMessage());
            return "";
        }
    }

    public static final String genDataMatrix(String data) throws BarcodeException {
        return BarcodeUtils.genDataMatrix(data, null, null);
    }

    public static final String genDataMatrix(String data, String filename) throws BarcodeException {
        return BarcodeUtils.genDataMatrix(data, filename, null);
    }

    public static final String genDataMatrix(String data, String filename, String params) throws BarcodeException {
        BarcodeUtils.check(data);
        return BarcodeGenerator.generateDataMatrix((String)data, BarcodeUtils.getParams(params)).getAbsolutePath();
    }

    public static final String genTagDataMatrix(String data) {
        return BarcodeUtils.genTagDataMatrix(data, null);
    }

    public static final String genTagDataMatrix(String data, String filename) {
        try {
            String path = BarcodeUtils.genDataMatrix(data, filename, null);
            return "<img src=\"file:///" + path + "\">";
        }
        catch (BarcodeException ex) {
            GuiNotifier.notifyProblemOnce((String)ex.getMessage());
            return "";
        }
    }

    private static void check(String data) {
        if (data == null || data.isEmpty()) {
            throw new IllegalArgumentException("Param 'data' must be set");
        }
    }

    private static Map<String, String> getParams(String params) {
        HashMap<String, String> res = new HashMap<String, String>();
        if (params != null && !params.isEmpty()) {
            for (String p : params.split(",")) {
                String[] vals = p.split("=");
                if (vals.length != 2) continue;
                res.put(vals[0], vals[1]);
            }
        }
        return res;
    }
}

