/*
 * Decompiled with CFR 0.152.
 */
package fxterm.msg;

import fxterm.core.reboot.RebootAction;
import fxterm.module.Module;
import java.util.ResourceBundle;

public class Messages {
    private static final ResourceBundle bundle = ResourceBundle.getBundle(Messages.class.getPackage().getName() + ".messages");

    public static String getChangeFlags(int flags) {
        if (flags == 0) {
            return "PIN*";
        }
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            int flag = 1 << i;
            if ((flags & flag) <= 0) continue;
            res.append(res.length() == 0 ? "" : ", ").append(Messages.getChangeFlag(flag));
        }
        return res.toString();
    }

    public static String getChangeFlag(int flag) {
        String key = "change.flag." + String.format("0x%02x", flag);
        try {
            return bundle.getString(key);
        }
        catch (Exception ex) {
            return key;
        }
    }

    public static String getModuleType(int id) {
        return Messages.get("module." + id);
    }

    public static String getUtilityModuleType(int type) {
        return Messages.get("utility." + type);
    }

    public static String getModuleType(Module module) {
        if (module == null) {
            return "-";
        }
        return Messages.getModuleType(module.getType());
    }

    public static String get(String id) {
        try {
            return bundle.getString(id);
        }
        catch (Exception ex) {
            return id;
        }
    }

    public static String getPaybackType(int type) {
        return Messages.get("payback." + type);
    }

    public static String getPaymentType(int type) {
        return Messages.get("payment." + type);
    }

    public static String getActionName(int actionId) {
        return Messages.get("action." + actionId);
    }

    public static String getCauseName(int causeId) {
        return Messages.get("cause." + causeId);
    }

    public static String getReboot(RebootAction ra) {
        if (ra == null) {
            throw new NullPointerException("Reboot action is not set");
        }
        return Messages.getActionName(ra.getAction()) + "->" + Messages.getCauseName(ra.getCause());
    }
}

