/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.utility.search;

import fxterm.app.FxEnv;
import fxterm.app.SystemProp;
import fxterm.app.id.LoggerId;
import fxterm.core.menu.MenuByServiceIdVisitor;
import fxterm.core.menu.MenuUtils;
import fxterm.core.menu.utils.ButtonInitFactory;
import fxterm.core.menu.utils.Listeners;
import fxterm.module.utility.BaseUtilityModule;
import fxterm.module.utility.UtilityModuleFactory;
import fxterm.module.utility.search.LocaleMenuSearchProviderVisitor;
import fxterm.module.utility.search.MenuSearchProviderVisitor;
import fxterm.module.utility.search.SearchVisitor;
import fxterm.session.Session;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import plfx.screen.Screen;
import plfx.screen.ScreenCreateException;
import plfx.screen.ScreenStore;
import plfx.screen.menu.button.ActionListener;
import plfx.screen.menu.button.MenuButtonInit;
import plfx.screen.utility.search.SearchListener;
import plfx.screen.utility.search.SearchScreen;
import plfx.shell2.dialog.Dialog;
import ru.softlogic.reference.menu.MenuItem;

public class SearchService
extends BaseUtilityModule {
    private final Logger log = LoggerId.UTILITY;
    private List<MenuItem> founded;
    private SearchScreen screen;
    private int screenNo;
    private int screenCount;
    private int cap;

    @Override
    protected void _start(Map<String, Object> data) {
        try {
            if (this.screen == null) {
                this.screen = ScreenStore.getSearchScreen();
                this.screen.setListener((SearchListener)new LocalSearchListener());
                this.cap = this.screen.getButtonCount();
            }
            this.screen.setCurrentLocale(Session.getLocale());
            this.screen.init();
            FxEnv.showScreen((Screen)this.screen);
        }
        catch (ScreenCreateException ex) {
            this.exit((Exception)((Object)ex));
        }
    }

    private void updateView() {
        int to = (this.screenNo + 1) * this.cap > this.founded.size() ? this.founded.size() : (this.screenNo + 1) * this.cap;
        List<MenuItem> pie = this.founded.subList(this.screenNo * this.cap, to);
        this.log.info((Object)("Show screen " + this.screenNo + ", items: " + pie.size() + ", from: " + this.screenNo * this.cap + ", to: " + to));
        HashMap<String, Map<String, String>> messages = new HashMap<String, Map<String, String>>();
        LinkedList<MenuButtonInit> inits = new LinkedList<MenuButtonInit>();
        int i = 0;
        for (MenuItem mi : pie) {
            MenuButtonInit mbi = ButtonInitFactory.createButtonInit(mi, MenuUtils.getState(mi), (ActionListener)new Listeners.LauncherActionListener(mi));
            messages.put("service" + i, mbi.getTexts());
            inits.add(ButtonInitFactory.createButtonInit(mi, MenuUtils.getState(mi), (ActionListener)new Listeners.LauncherActionListener(mi)));
            ++i;
        }
        Session.setMenuTitles(messages);
        this.screen.update(inits, this.screenNo != 0, this.screenNo != this.screenCount - 1);
        FxEnv.refreshScreen();
    }

    private SearchVisitor createVisitor(String req) {
        return SystemProp.isUseLocaleSearcher() ? new LocaleMenuSearchProviderVisitor(req, null) : new MenuSearchProviderVisitor(req, null);
    }

    private boolean checkSecretPhone(String request) {
        String secretPhone = Session.getPoint().getSecretPhone();
        if (secretPhone != null && secretPhone.equals(request)) {
            this.log.info((Object)("User input secret number: " + secretPhone + ", show dialog"));
            Dialog.show((String)"module/listener_console_search", actionId -> {
                if (actionId == 0) {
                    this.log.info((Object)"Go to admin module");
                    UtilityModuleFactory.runQuietly(2);
                }
            });
            return true;
        }
        return false;
    }

    private class LocalSearchListener
    implements SearchListener {
        private LocalSearchListener() {
        }

        public void onRequest(String request) {
            SearchService.this.log.info((Object)("Search request: " + request));
            if (request.length() > 2) {
                if (!SearchService.this.checkSecretPhone(request)) {
                    SearchVisitor sv = SearchService.this.createVisitor(request);
                    MenuUtils.processMenu(sv);
                    SearchService.this.founded = sv.getItemsFull(-1);
                    SearchService.this.log.info((Object)("Items count: " + SearchService.this.founded.size()));
                    SearchService.this.screenNo = 0;
                    SearchService.this.screenCount = SearchService.this.founded.size() / SearchService.this.cap + (SearchService.this.founded.size() % SearchService.this.cap == 0 ? 0 : 1);
                    SearchService.this.log.info((Object)("Screen count: " + SearchService.this.screenCount + ", screen size: " + SearchService.this.cap));
                    SearchService.this.updateView();
                }
            } else {
                SearchService.this.screen.update(null, false, false);
            }
        }

        public void onExit() {
            SearchService.this.log.info((Object)"Back to previous screen");
            SearchService.this.back();
        }

        public void onBrowseNext() {
            SearchService.this.log.info((Object)"Next");
            SearchService.this.screenNo = SearchService.this.screenNo + 1;
            SearchService.this.updateView();
        }

        public void onBrowsePrev() {
            SearchService.this.log.info((Object)"Prev");
            SearchService.this.screenNo = SearchService.this.screenNo - 1;
            SearchService.this.updateView();
        }

        public void onAddService() {
            short srvId = SystemProp.getAddServiceId();
            SearchService.this.log.info((Object)("AddService service id = " + srvId));
            if (srvId != -1) {
                MenuByServiceIdVisitor mbsiv = new MenuByServiceIdVisitor(srvId);
                MenuUtils.processMenu(mbsiv);
                if (mbsiv.getMenuItem() != null) {
                    SearchService.this.log.info((Object)("Found menu item = " + mbsiv.getMenuItem()));
                    Session.setRedirectItem(mbsiv.getMenuItem());
                    SearchService.this.exit();
                    return;
                }
                SearchService.this.log.info((Object)"Not found addService menu item");
            }
            Dialog.show((String)"module/input/redirect_not_found");
        }
    }
}

