/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.utility.search;

import fxterm.core.hdw.bvr.oper.NewKeeper2;
import fxterm.module.utility.search.SearchVisitor;
import fxterm.session.Session;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.service.Service;
import ru.softlogic.reference.service.ServiceLang;
import ru.softlogic.reference.service.ServiceType;

class MenuSearchProviderVisitor
extends SearchVisitor {
    protected final Map<String, MenuItem> nameStart = new LinkedHashMap<String, MenuItem>();
    protected final Map<String, MenuItem> altNameStart = new LinkedHashMap<String, MenuItem>();
    protected final Map<String, MenuItem> name = new LinkedHashMap<String, MenuItem>();
    protected final Map<String, MenuItem> altName = new LinkedHashMap<String, MenuItem>();
    protected final Map<String, MenuItem> innStart = new LinkedHashMap<String, MenuItem>();
    protected final Map<String, MenuItem> inn = new LinkedHashMap<String, MenuItem>();
    protected final Map<String, MenuItem> identificator = new LinkedHashMap<String, MenuItem>();
    protected String input;
    protected String inputDefault;

    public MenuSearchProviderVisitor(String input, String inputDefault) {
        if (input == null) {
            throw new NullPointerException();
        }
        this.input = input.trim().toLowerCase();
        if (inputDefault != null) {
            this.inputDefault = inputDefault.toLowerCase().trim();
        }
    }

    @Override
    public boolean processGroup(ServiceType st) {
        return st == null || st.getName() == null || !st.getName().startsWith("#") && !st.isHidden();
    }

    @Override
    public boolean _onMenuItem(MenuItem mi) {
        Service service = mi.getService();
        if (!this.input.trim().isEmpty()) {
            String[] split;
            String providerINN;
            String serviceINN = service.getProvider().getInn();
            if (serviceINN != null && serviceINN.toLowerCase().trim().startsWith(this.input)) {
                this.checkAndPut(this.innStart, mi);
            }
            if ((providerINN = service.getProvider().getInn()) != null && providerINN.toLowerCase().contains(this.input)) {
                this.checkAndPut(this.inn, mi);
            }
            if (service.getAltName() != null) {
                split = service.getAltName().split(",");
                for (String s2 : split) {
                    if (s2 == null || !s2.toLowerCase().trim().startsWith(this.input)) continue;
                    this.checkAndPut(this.altNameStart, mi, service.getName().trim() + " (" + s2.trim() + ")");
                    break;
                }
            }
            if (service.getAltName() != null) {
                split = service.getAltName().split(",");
                for (String s2 : split) {
                    if (s2 == null || !s2.toLowerCase().contains(this.input)) continue;
                    this.checkAndPut(this.altName, mi, service.getName().trim() + " (" + s2.trim() + ")");
                    break;
                }
            }
            ArrayList<String> sNames = new ArrayList<String>();
            sNames.add(service.getName());
            sNames.addAll(Optional.ofNullable(service.getLangs()).map(Map::values).map(Collection::stream).map(s -> s.map(ServiceLang::getName).collect(Collectors.toList())).orElse(Collections.emptyList()));
            sNames.stream().filter(n -> n.toLowerCase().trim().startsWith(this.input)).forEach(n -> this.checkAndPut(this.nameStart, mi));
            for (String sName : sNames) {
                String s1 = sName.toLowerCase().trim().replace(" ", "");
                String s2 = this.input.replace(" ", "");
                if (s2.length() - s1.length() > 2) break;
                int min = Math.min(s1.length(), s2.length());
                if (StringUtils.getLevenshteinDistance((String)s1.substring(0, min), (String)s2.substring(0, min)) >= 2 && !s1.contains(s2) && !String.valueOf(service.getId()).equals(s2) && !String.valueOf(service.getCode()).equals(s2)) continue;
                this.checkAndPut(this.name, mi);
            }
        }
        if (this.inputDefault != null) {
            String[] split;
            for (String key : split = this.inputDefault.split(",")) {
                String id = String.valueOf(service.getId());
                if (!id.equals(key)) continue;
                this.checkAndPut(this.identificator, mi);
                break;
            }
        }
        return true;
    }

    @Override
    public List<MenuItem> getItemsFull(int max) {
        LinkedHashMap<String, MenuItem> items = new LinkedHashMap<String, MenuItem>();
        HashSet<String> keys = new HashSet<String>();
        this.process(this.nameStart, keys, items, max);
        this.process(this.altNameStart, keys, items, max);
        this.process(this.name, keys, items, max);
        this.process(this.altName, keys, items, max);
        this.process(this.innStart, keys, items, max);
        this.process(this.inn, keys, items, max);
        this.process(this.identificator, keys, items, max);
        LinkedHashSet<MenuItem> set = new LinkedHashSet<MenuItem>(items.values());
        return new ArrayList<MenuItem>(set);
    }

    private void process(Map<String, MenuItem> data, Set<String> keys, Map<String, MenuItem> items, int max) {
        for (Map.Entry<String, MenuItem> entry : data.entrySet()) {
            if (max != -1 && keys.size() >= max) break;
            String nkey = entry.getKey();
            String lkey = entry.getKey().toLowerCase();
            if (keys.contains(lkey)) continue;
            items.put(nkey, entry.getValue());
            keys.add(nkey);
        }
    }

    protected boolean validateCurrency(MenuItem menuItem) {
        NewKeeper2 kpr = Session.getPayEnv().getKeeper();
        String currency = kpr.getCurrency();
        if (!kpr.isEmpty() || kpr.getOut() != null && !kpr.getOut().isEmpty()) {
            String miCurrency = menuItem.getService().getInCurrency();
            if (miCurrency == null) {
                return false;
            }
            return miCurrency.equals(currency);
        }
        return true;
    }

    protected boolean checkAndPut(Map<String, MenuItem> map, MenuItem menuItem, String name) {
        if (!menuItem.isDisableOnSchedule() && this.validateCurrency(menuItem)) {
            map.put(name, menuItem);
            return true;
        }
        return false;
    }

    protected boolean checkAndPut(Map<String, MenuItem> map, MenuItem menuItem) {
        if (!menuItem.isDisableOnSchedule() && this.validateCurrency(menuItem)) {
            map.put(menuItem.getService().getName().trim(), menuItem);
            return true;
        }
        return false;
    }
}

