/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.utility.search;

import fxterm.module.utility.search.MenuSearchProviderVisitor;
import fxterm.session.Session;
import org.apache.commons.lang.StringUtils;
import ru.softlogic.reference.References;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.service.Service;
import ru.softlogic.reference.service.ServiceLang;

class LocaleMenuSearchProviderVisitor
extends MenuSearchProviderVisitor {
    private String defaultLanguage = References.getPointOptions().getLanguage();
    private final String currentLanguage;

    public LocaleMenuSearchProviderVisitor(String input, String inputDefault) {
        super(input, inputDefault);
        if (this.defaultLanguage == null) {
            this.defaultLanguage = "uk";
        }
        this.currentLanguage = Session.getLocale().getLanguage();
    }

    @Override
    public boolean _onMenuItem(MenuItem mi) {
        Service service = mi.getService();
        if (!this.input.trim().isEmpty()) {
            String providerINN;
            String serviceINN = service.getProvider().getInn();
            if (serviceINN != null && serviceINN.toLowerCase().trim().startsWith(this.input)) {
                this.checkAndPut(this.innStart, mi);
            }
            if ((providerINN = service.getProvider().getInn()) != null && providerINN.toLowerCase().contains(this.input)) {
                this.checkAndPut(this.inn, mi);
            }
            if (this.defaultLanguage.equals(this.currentLanguage) && service.getAltName() != null) {
                String[] split;
                for (String s : split = service.getAltName().split(",")) {
                    if (s != null && s.toLowerCase().trim().startsWith(this.input)) {
                        this.checkAndPut(this.altNameStart, mi, service.getName().trim() + " (" + s.trim() + ")");
                        break;
                    }
                    if (s == null || !s.toLowerCase().contains(this.input)) continue;
                    this.checkAndPut(this.altName, mi, service.getName().trim() + " (" + s.trim() + ")");
                    break;
                }
            }
            String source = null;
            if (this.defaultLanguage.equals(this.currentLanguage)) {
                source = service.getName();
            } else if (service.getLangs().get(this.currentLanguage) != null) {
                source = ((ServiceLang)service.getLangs().get(this.currentLanguage)).getName();
            }
            if (source != null) {
                int min;
                if (source.toLowerCase().trim().startsWith(this.input)) {
                    this.checkAndPut(this.nameStart, mi);
                }
                String s1 = source.toLowerCase().trim().replace(" ", "");
                String s2 = this.input.replace(" ", "");
                if (s2.length() - s1.length() <= 2 && (StringUtils.getLevenshteinDistance((String)s1.substring(0, min = Math.min(s1.length(), s2.length())), (String)s2.substring(0, min)) < 2 || s1.contains(s2) || String.valueOf(service.getId()).equals(s2) || String.valueOf(service.getCode()).equals(s2))) {
                    this.checkAndPut(this.name, mi);
                }
            }
        }
        if (this.inputDefault != null) {
            String[] split;
            for (String key : split = this.inputDefault.split(",")) {
                String id = String.valueOf(service.getId());
                if (!id.equals(key)) continue;
                this.checkAndPut(this.identificator, mi);
                break;
            }
        }
        return true;
    }
}

