/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.utility.paystat;

import fxterm.app.FxEnv;
import fxterm.app.id.LoggerId;
import fxterm.core.BaseScreenListener;
import fxterm.core.task.Task;
import fxterm.module.CancelDialogListener;
import fxterm.module.utility.BaseUtilityModule;
import fxterm.session.Session;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import plfx.screen.CommonScreen;
import plfx.screen.Screen;
import plfx.screen.ScreenCreateException;
import plfx.screen.ScreenListener;
import plfx.screen.ScreenStore;
import plfx.shell2.dialog.Dialog;
import plfx.shell2.dialog.DialogListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.screen.ActionType;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.parser.ParseException;
import ru.softlogic.reference.References;
import ru.softlogic.srv.api.oth.FindOperationResult;

public class PayStatus
extends BaseUtilityModule {
    private final SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
    private final Logger log = LoggerId.UTILITY;
    private Runnable cancel;

    @Override
    protected void _start(Map<String, Object> data) {
        this.log.info((Object)"Run payment status module");
        try {
            ScreenDescription sd = this.readUtilityForm("paystatus", Locale.getDefault());
            int fsize = sd.getSequence().getFields().size();
            if (fsize < 4 || fsize > 5) {
                throw new ParseException("Wrong number of fields: " + sd.getSequence().getFields().size());
            }
            HashMap<String, Object> obj = new HashMap<String, Object>();
            obj.put("point", new InputElement("point", "point", Integer.toString(References.getPoint().getId())));
            this.log.info((Object)("Open screen type: " + sd.getType()));
            CommonScreen cs = ScreenStore.getCommonScreen((String)sd.getType());
            Session.setScreenDescription(sd);
            cs.init(sd, this.createScreenInit(obj));
            cs.setListener((ScreenListener)new LocalScreenListener());
            FxEnv.showScreen((Screen)cs);
        }
        catch (ScreenCreateException | InitException | ParseException ex) {
            this.exit((Exception)ex);
        }
    }

    private class RequestTask
    extends Task {
        private final String account;
        private final int sum;
        private final String date;
        private final Integer checkNumber;
        private final short point;

        public RequestTask(String account, int sum, String date, Integer checkNumber, short point) {
            this.account = account;
            this.sum = sum;
            this.date = date;
            this.checkNumber = checkNumber;
            this.point = point;
        }

        @Override
        protected String getWaitId() {
            return "paystatus.get.data";
        }

        protected Object execute() throws Exception {
            PayStatus.this.log.info((Object)("Make request, data=" + this.account + ", " + this.sum + ", " + this.date + ", " + this.checkNumber + ", " + this.point));
            return FxEnv.getConnector().findOperation(Short.valueOf(this.point), this.checkNumber, this.date, this.account, this.sum);
        }

        protected void onResult(Object object) {
            PayStatus.this.log.info(object);
            FindOperationResult fr = (FindOperationResult)object;
            Session.setItem("payment_state", fr.getState());
            Dialog.show((String)"module/utility/paystate/result", (DialogListener)new CancelDialogListener(PayStatus.this.cancel));
        }

        @Override
        protected void onError(Exception ex) {
            PayStatus.this.log.error((Object)"Error on online request", (Throwable)ex);
            Dialog.show((String)"module/utility/paystate/error_network", (DialogListener)new CancelDialogListener(PayStatus.this.cancel));
        }

        public String toString() {
            return "RequestTask{}";
        }
    }

    private class LocalScreenListener
    extends BaseScreenListener {
        private LocalScreenListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            PayStatus.this.cancel = cancelListener;
            if (ActionType.isNext((String)action)) {
                int pnt;
                PayStatus.this.log.info(data);
                InputElement account = (InputElement)data.get("account");
                InputElement sm = (InputElement)data.get("sum");
                InputElement date = (InputElement)data.get("date");
                InputElement doc = (InputElement)data.get("doc");
                InputElement point = (InputElement)data.get("point");
                int sum = Math.round(Float.parseFloat(sm.getValue()) * 100.0f);
                String d = date.getValue();
                if (d.matches("\\d+")) {
                    GregorianCalendar cal = new GregorianCalendar();
                    ((Calendar)cal).add(6, -Integer.parseInt(date.getValue()));
                    d = PayStatus.this.sdf.format(cal.getTime());
                }
                Integer docNum = null;
                if (doc != null && doc.getValue().matches("^\\d{1,5}$") && ((docNum = Integer.valueOf(Integer.parseInt(doc.getValue()))) < 1 || docNum > 32500)) {
                    Dialog.show((String)"module/utility/paystate/error_doc", (DialogListener)new CancelDialogListener(cancelListener));
                    return;
                }
                int n = pnt = point == null ? References.getPoint().getId() : Integer.parseInt(point.getValue());
                if (pnt < 1 || pnt > Short.MAX_VALUE) {
                    Dialog.show((String)"module/utility/paystate/error_point", (DialogListener)new CancelDialogListener(cancelListener));
                    return;
                }
                new RequestTask(account.getValue(), sum, d, docNum, (short)pnt).process();
            } else if (ActionType.isPrev((String)action)) {
                PayStatus.this.back();
            } else {
                PayStatus.this.cancel(null);
            }
        }
    }
}

