/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.utility.console;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import plfx.screen.utility.console.ConsoleModule;
import ru.softlogic.reference.References;
import ru.softlogic.reference.point.ServerUser;

public class UsersUtil {
    public static final String TAB_MAIN = "main";
    public static final String TAB_KKM = "kkm";
    public static final String TAB_COLLECTION = "collection";
    public static final String TAB_LOG = "log";
    public static final String TAB_CASH = "cash";
    public static final String TAB_STATES = "states";
    public static final String TAB_HOPPER = "hopper";
    public static final String TAB_MODEM = "modem";
    public static final String TAB_CVD = "cvd";
    public static final String TAB_QUEUE = "queue";
    public static final String BTN_CALIBRATE = "calibrate";
    public static final String BTN_NOTE_COLLECTION = "cashMoneyCollection";
    public static final String BTN_COIN_COLLECTION = "coinMoneyCollection";
    public static final String BTN_COIN_HOPPER_COLLECTION = "coinHopperMoneyCollection";
    public static final String BTN_CHECK_BALANCE = "checkBalance";
    public static final String BTN_CLOSE_SOFTWARE = "closeSoftware";
    public static final String BTN_UPDATE_BUTTON = "update";
    public static final String BTN_LOCAL_UPDATE_BUTTON = "localUpdate";
    public static final String BTN_MINIMIZE_SOFTWARE = "minimizeSoftware";
    public static final String BTN_POWEROFF_TERMINAL = "poweroffTerminal";
    public static final String BTN_REBOOT_TERMINAL = "rebootTerminal";
    public static final String BTN_RESTART_SOFTWARE = "restartSoftware";
    public static final String BTN_START_CONFIG = "startConfig";
    public static final String BTN_TEST_NETWORK = "testNetwork";
    public static final String BTN_TEST_PRINTER = "testPrinter";
    public static final String BTN_OPEN_CTRL_PANEL = "controlPanel";
    public static final String BTN_TEST_SELL = "testSell";
    public static final String BTN_X_REPORT = "xReport";
    public static final String BTN_Z_REPORT = "zReport";
    public static final String BTN_Z_REPORT_MEM = "zReportMem";
    public static final String BTN_Z_DATE_RANGE = "printDateRange";

    public static ServerUser authentication(String login, String password) {
        String passwordMd5;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.reset();
            byte[] result = md.digest(password.getBytes(StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            for (byte bt : result) {
                sb.append(String.format("%02x", bt & 0xFF));
            }
            passwordMd5 = sb.toString();
        }
        catch (NoSuchAlgorithmException ex) {
            return null;
        }
        ServerUser[] users = References.getServerUsers();
        if (users != null && users.length > 0 && !passwordMd5.isEmpty()) {
            for (ServerUser su : users) {
                if (!login.equals(su.getLogin()) || !passwordMd5.equals(su.getPassword())) continue;
                return su;
            }
        }
        return null;
    }

    public static ConsoleModule.State canShowTab(ServerUser user, String tabName) {
        if (user == null || tabName == null) {
            return ConsoleModule.State.Disable;
        }
        if (user.getAccessList() == null || user.getAccessList().isEmpty()) {
            return ConsoleModule.State.Disable;
        }
        return user.getAccessList().contains(tabName + ":") ? ConsoleModule.State.Visible : ConsoleModule.State.Disable;
    }

    public static ConsoleModule.State canShowButton(ServerUser user, String tabName, String buttonName) {
        if (user == null || buttonName == null || tabName == null) {
            return ConsoleModule.State.Disable;
        }
        if (user.getAccessList() == null || user.getAccessList().isEmpty()) {
            return ConsoleModule.State.Disable;
        }
        return user.getAccessList().matches("^.*" + tabName + ":[^:]*" + buttonName + ".*$") ? ConsoleModule.State.Visible : ConsoleModule.State.Disable;
    }
}

