/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.utility.console;

import fxterm.app.FxEnv;
import fxterm.module.utility.console.Handler;
import fxterm.session.Session;
import java.text.DateFormat;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import plfx.screen.utility.console.FinancialQueueItem;
import plfx.screen.utility.console.QueueModule;
import plfx.util.TerminalPlatform;
import ru.softlogic.cash.Sum;
import ru.softlogic.hardware.currency.SumFormatter;
import ru.softlogic.operation.GroupOperation;
import ru.softlogic.operation.Operation;
import ru.softlogic.reference.point.ServerUser;
import ru.softlogic.srv.connector.FinancialObserver;
import ru.softlogic.srv.queue.Queue;

class QueueHandler
implements Handler,
FinancialObserver {
    private final QueueModule module;
    private final Logger log;

    public QueueHandler(QueueModule module, Logger log) {
        this.module = module;
        this.log = log;
    }

    @Override
    public void init(ServerUser user) {
        FxEnv.getConnector().getQueue().removeFinancialObserver((FinancialObserver)this);
    }

    @Override
    public void shutdown() {
        FxEnv.getConnector().getQueue().removeFinancialObserver((FinancialObserver)this);
    }

    public void update(int size) {
        LinkedList<FinancialQueueItem> items = new LinkedList<FinancialQueueItem>();
        Queue queue = FxEnv.getConnector().getQueue();
        Operation[] operations = queue.getOperations();
        GroupOperation[] groupOperations = queue.getGroupOperations();
        items.addAll(this.buildOperationList(1, operations));
        items.addAll(this.buildOperationList(items.size(), (Operation[])groupOperations));
        if (items.isEmpty()) {
            this.log.info((Object)"Financial queue is empty");
        } else {
            this.log.info((Object)("Update financial queue. Queue size: " + items.size()));
        }
        TerminalPlatform.runLater(() -> this.module.setFinancialQueueItems(items));
    }

    private List<FinancialQueueItem> buildOperationList(int startNumber, Operation[] operations) {
        DateFormat fmt = DateFormat.getDateTimeInstance(2, 2, Session.getLocale());
        LinkedList<FinancialQueueItem> items = new LinkedList<FinancialQueueItem>();
        Integer count = startNumber;
        if (operations != null && operations.length != 0) {
            for (Operation op : operations) {
                Sum sum = op.getSumResult().getIncome();
                items.add(new FinancialQueueItem(count.toString(), (String)op.getViews().get("id1"), fmt.format(op.getDate()), SumFormatter.asStr((int)sum.getValue(), (String)sum.getCurrency(), null)));
                count = count + 1;
            }
        }
        return items;
    }
}

