/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.utility.console;

import fxterm.app.FxEnv;
import fxterm.core.hdw.prt.PrnUtils;
import fxterm.core.reboot.SafeReboot;
import fxterm.core.update.ConsoleLocalUpdater;
import fxterm.core.update.ConsoleNetworkUpdater;
import fxterm.core.update.UpdateUtils;
import fxterm.module.utility.UtilityModuleFactory;
import fxterm.module.utility.console.BvrTestOperation;
import fxterm.module.utility.console.Console;
import fxterm.module.utility.console.Handler;
import fxterm.module.utility.console.NetworkTask;
import fxterm.module.utility.console.UsersUtil;
import fxterm.session.Session;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Date;
import javafx.application.Platform;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.log4j.Logger;
import plfx.GuiNotifier;
import plfx.screen.ScreenCreateException;
import plfx.screen.utility.console.ConsoleScreen;
import plfx.screen.utility.console.MainModule;
import plfx.screen.utility.console.bvrtest.BvrTestScreen;
import plfx.screen.utility.console.bvrtest.BvrTestScreenFactory;
import plfx.shell.custom.TimeoutListener;
import plfx.shell2.dialog.Dialog;
import plfx.shell2.dialog.DialogListener;
import plfx.shell2.dialog.OkDialogListener;
import ru.softlogic.hdw.dev.cashacc.CashAcceptorDevice;
import ru.softlogic.hdw.dev.cashacc.CashInOperation;
import ru.softlogic.hdw.dev.cashacc.EventListener;
import ru.softlogic.hdw.handling.DeviceState;
import ru.softlogic.hdw.handling.HdwMsg;
import ru.softlogic.reference.point.ServerUser;
import ru.softlogic.system.util.PathUtils;
import ru.softlogic.system.util.os.OsApi;
import ru.softlogic.system.util.os.OsException;

class MainModuleHandler
implements MainModule.Listener,
Handler {
    private static final int DEFAULT_TIMEOUT = 90;
    private final Console console;
    private final ConsoleScreen screen;
    private final MainModule module;
    private final Logger log;
    private ServerUser user;
    private ConsoleNetworkUpdater networkUpdater;
    private ConsoleLocalUpdater localUpdater;
    private BvrTestScreen bvrTestScreen;
    private BvrTestListener bvrTestListener;
    private plfx.shell.custom.Handler bvrTestHandler;
    private final CashAcceptorDevice bvrDevice;
    private final BvrEventListener bvrEventListener;
    private BvrTestOperation bvrTestOperation;

    public MainModuleHandler(Console console, ConsoleScreen screen, MainModule module, Logger log) {
        this.console = console;
        this.screen = screen;
        this.module = module;
        this.log = log;
        this.bvrDevice = FxEnv.getBillValidator();
        this.bvrEventListener = new BvrEventListener();
    }

    @Override
    public void init(ServerUser user) {
        this.user = user;
        this.module.setTabState(UsersUtil.canShowTab(user, "main"));
        this.module.setButtonState(16, UsersUtil.canShowButton(user, "main", "cashMoneyCollection"));
        this.module.setButtonState(17, UsersUtil.canShowButton(user, "main", "coinMoneyCollection"));
        this.module.setButtonState(12, UsersUtil.canShowButton(user, "main", "testPrinter"));
        this.module.setButtonState(11, UsersUtil.canShowButton(user, "main", "testNetwork"));
        this.module.setButtonState(2, UsersUtil.canShowButton(user, "main", "checkBalance"));
        this.module.setButtonState(1, UsersUtil.canShowButton(user, "main", "calibrate"));
        this.module.setButtonState(6, UsersUtil.canShowButton(user, "main", "minimizeSoftware"));
        this.module.setButtonState(9, UsersUtil.canShowButton(user, "main", "restartSoftware"));
        this.module.setButtonState(3, UsersUtil.canShowButton(user, "main", "closeSoftware"));
        this.module.setButtonState(8, UsersUtil.canShowButton(user, "main", "rebootTerminal"));
        this.module.setButtonState(7, UsersUtil.canShowButton(user, "main", "poweroffTerminal"));
        this.module.setButtonState(4, UsersUtil.canShowButton(user, "main", "update"));
        this.module.setButtonState(5, UsersUtil.canShowButton(user, "main", "localUpdate"));
        this.module.setButtonState(13, UsersUtil.canShowButton(user, "main", "controlPanel"));
        this.module.setButtonState(10, UsersUtil.canShowButton(user, "main", "startConfig"));
    }

    @Override
    public void shutdown() {
        this.user = null;
        if (this.networkUpdater != null) {
            this.networkUpdater.setActive(false);
        }
    }

    public void onCloseConsole() {
        this.log.info((Object)"Close console");
        this.exit();
    }

    public void onRestartSoftware() {
        this.log.info((Object)"Restart software");
        Dialog.show((String)"module/utility/console/action_confirm", (DialogListener)new OkDialogListener(){

            protected void onOk() {
                SafeReboot.exit(0, 2);
                MainModuleHandler.this.exit();
            }
        });
    }

    public void onRestartTerminal() {
        this.log.info((Object)"Restart terminal");
        Dialog.show((String)"module/utility/console/action_confirm", (DialogListener)new OkDialogListener(){

            protected void onOk() {
                SafeReboot.reboot(2);
                MainModuleHandler.this.exit();
            }
        });
    }

    public void onShutdownSoftware() {
        this.log.info((Object)"Shutdown software");
        Dialog.show((String)"module/utility/console/action_confirm", (DialogListener)new OkDialogListener(){

            protected void onOk() {
                SafeReboot.exit(15, 2);
                MainModuleHandler.this.exit();
            }
        });
    }

    public void onShutdownTerminal() {
        this.log.info((Object)"Shutdown terminal");
        Dialog.show((String)"module/utility/console/action_confirm", (DialogListener)new OkDialogListener(){

            protected void onOk() {
                SafeReboot.shutdown(2);
                MainModuleHandler.this.exit();
            }
        });
    }

    public void onRunConfigurator() {
        this.log.info((Object)"Run configurator");
        Dialog.show((String)"module/utility/console/action_confirm", (DialogListener)new OkDialogListener(){

            protected void onOk() {
                SafeReboot.exit(16, 2);
                MainModuleHandler.this.exit();
            }
        });
    }

    public void onUpdateFromNetwork() {
        this.log.info((Object)"Update from network");
        if (this.networkUpdater == null) {
            this.networkUpdater = new ConsoleNetworkUpdater(this.console, this.log, this.module.getProgressBar());
        }
        this.networkUpdater.setActive(true);
        this.networkUpdater.checkUpdate();
    }

    public void onUpdateFromMedia() {
        this.log.info((Object)"Update from media");
        if (this.localUpdater == null) {
            this.localUpdater = new ConsoleLocalUpdater(this.console, this.log, this.module.getProgressBar());
        }
        this.localUpdater.setActive(true);
        this.localUpdater.checkUpdate();
    }

    public void onCheckConnection() {
        this.log.info((Object)"Check internet connection");
        new CheckNetworkTask().process();
    }

    public void onCheckPrinter() {
        this.log.info((Object)"Check printer");
        FxEnv.getPrintSpooler().print(PrnUtils.createDiagPrinterJob());
    }

    public void onRequestBalance() {
        this.log.info((Object)"Request dealer balance");
        new CheckBalanceTask().process();
    }

    public void onMinimizeWindow() {
        this.log.info((Object)"Minimize window");
        FxEnv.getPrimaryStage().setIconified(true);
    }

    public void onJavaUpdate() {
        this.log.info((Object)"Java update");
        try {
            String version = UpdateUtils.readJavaBuild();
            this.log.info((Object)("Current version: " + version));
            File d = PathUtils.getFilePath((String)"/jre/");
            RegexFileFilter ff = new RegexFileFilter("^" + version + "-[\\d]{4}\\.bpatch$");
            File[] pathches = d.listFiles((FileFilter)ff);
            if (pathches != null && pathches.length > 0) {
                this.log.info((Object)"Update is found, process action");
                Dialog.show((String)"module/utility/console/javaupdate_confirm", (DialogListener)new OkDialogListener(){

                    protected void onOk() {
                        MainModuleHandler.this.log.info((Object)"Confirmed");
                        SafeReboot.exit(24, 2);
                        MainModuleHandler.this.exit();
                    }
                });
            } else {
                this.log.info((Object)"Update is not found");
                Dialog.show((String)"module/utility/console/javaupdate_not_found");
            }
        }
        catch (IOException ex) {
            this.log.info((Object)"Can't read version");
            Dialog.show((String)"module/utility/console/javaupdate_not_support");
        }
    }

    public void onCalibValidate() {
        this.log.info((Object)"Run calib validor");
        UtilityModuleFactory.runQuietly(4);
    }

    public void onOpenPanel() {
        this.log.info((Object)"Open system panel");
        this.onMinimizeWindow();
        try {
            OsApi.getInstance().openControlPanel();
            this.log.info((Object)"done");
        }
        catch (OsException ex) {
            this.log.error((Object)ex, (Throwable)ex);
            GuiNotifier.notifyError((Throwable)ex);
            Dialog.show((String)"module/utility/console/feature_not_support");
        }
    }

    public void onOpenScreenKeyboard() {
        this.log.info((Object)"Open osk");
        try {
            OsApi.getInstance().openOSK();
            this.log.info((Object)"done");
        }
        catch (OsException ex) {
            this.log.error((Object)ex.getMessage());
            GuiNotifier.notifyError((Throwable)ex);
            Dialog.show((String)"module/utility/console/feature_not_support");
        }
    }

    private void exit() {
        this.console.exit();
    }

    public void onTestBillValidator() {
        this.log.info((Object)"onTestBillValidator");
        if (this.bvrTestScreen == null) {
            this.log.info((Object)"Try to create test screen");
            try {
                this.bvrTestScreen = BvrTestScreenFactory.createScreen();
                this.bvrTestListener = new BvrTestListener();
                this.bvrTestScreen.setListener((BvrTestScreen.Listener)this.bvrTestListener);
                this.bvrTestOperation = new BvrTestOperation(this.bvrDevice.getMainCurrency(), this.bvrTestScreen);
                this.log.info((Object)"Success");
            }
            catch (ScreenCreateException ex) {
                GuiNotifier.notifyError((Throwable)ex);
                Dialog.show((String)"common/error");
                return;
            }
        }
        this.log.info((Object)"Show popup");
        this.bvrTestHandler = FxEnv.getCustomModule().show(this.bvrTestScreen.getTemplate(), (TimeoutListener)this.bvrTestListener, 90);
        this.bvrTestScreen.init();
        this.bvrTestScreen.addMessage("Status: " + HdwMsg.getState((DeviceState)this.bvrDevice.getLastState()));
        this.bvrDevice.addEventListener((EventListener)this.bvrEventListener);
        this.bvrDevice.enable((CashInOperation)this.bvrTestOperation);
    }

    private class BvrEventListener
    implements EventListener {
        private BvrEventListener() {
        }

        public void onEvent(int i) {
            Platform.runLater(() -> MainModuleHandler.this.bvrTestScreen.addMessage(HdwMsg.getBvrEvent((int)i)));
        }
    }

    private class BvrTestListener
    implements BvrTestScreen.Listener,
    TimeoutListener {
        private BvrTestListener() {
        }

        public void onClose() {
            this.shutdown();
        }

        public void onTimeout() {
            this.shutdown();
        }

        private void shutdown() {
            MainModuleHandler.this.bvrTestHandler.close();
            MainModuleHandler.this.bvrDevice.removeEventListener((EventListener)MainModuleHandler.this.bvrEventListener);
            MainModuleHandler.this.bvrDevice.disable();
        }
    }

    private class CheckNetworkTask
    extends NetworkTask<Date> {
        private CheckNetworkTask() {
        }

        @Override
        protected Date execute() throws Exception {
            MainModuleHandler.this.log.info((Object)"Run ping request");
            return FxEnv.getConnector().ping();
        }

        @Override
        protected void onResult(Date object) {
            MainModuleHandler.this.log.info((Object)("Result: " + object));
            Dialog.show((String)"module/utility/console/network_ok");
        }
    }

    private class CheckBalanceTask
    extends NetworkTask<Long> {
        private CheckBalanceTask() {
        }

        @Override
        protected Long execute() throws Exception {
            MainModuleHandler.this.log.info((Object)"Run balance request");
            return FxEnv.getConnector().getBalance(MainModuleHandler.this.user.getId());
        }

        @Override
        protected void onResult(Long balance) {
            MainModuleHandler.this.log.info((Object)("Result: " + balance));
            Session.setItem("dealer_balance", String.format("%.2f", (double)balance.longValue() * 1.0 / 100.0));
            Dialog.show((String)"module/utility/console/balance_ok");
        }
    }
}

