/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.utility.console;

import fxterm.module.utility.console.Handler;
import fxterm.module.utility.console.LogViewAppender;
import fxterm.module.utility.console.UsersUtil;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import plfx.screen.utility.console.LogModule;
import plfx.util.TerminalPlatform;
import ru.softlogic.reference.point.ServerUser;

class LogHandler
implements LogModule.Listener,
Handler,
LogViewAppender.ViewAppenderListener {
    private static final int LINE_COUNT = 200;
    private final LogModule module;
    private final Logger log;
    private final List<String> buffer = new LinkedList<String>();
    private boolean enable;
    private int remove;

    public LogHandler(LogModule module, Logger log) {
        this.module = module;
        this.log = log;
    }

    @Override
    public void init(ServerUser user) {
        this.module.setTabState(UsersUtil.canShowTab(user, "log"));
        LogViewAppender.addListener(this);
        this.setActive(true);
    }

    @Override
    public void shutdown() {
        LogViewAppender.removeListener(this);
        this.setActive(false);
    }

    public void onClearLogs() {
        this.log.info((Object)"Clear logs");
        this.clear();
    }

    @Override
    public synchronized void onLine(String string) {
        this.buffer.add(string);
        this.remove = -1;
        if (this.buffer.size() > 200) {
            this.remove = this.buffer.remove(0).length();
        }
        if (this.enable) {
            TerminalPlatform.runLater(() -> {
                if (this.enable) {
                    if (this.remove > 0) {
                        this.module.getLogArea().remove(this.remove);
                    }
                    this.module.getLogArea().append(string);
                }
            });
        }
    }

    private synchronized void setActive(boolean enable) {
        if (this.enable == enable) {
            return;
        }
        this.enable = enable;
        this.module.getLogArea().clear();
        if (enable) {
            for (String line : this.buffer) {
                this.module.getLogArea().append(line);
            }
        }
    }

    private synchronized void clear() {
        this.buffer.clear();
        this.module.getLogArea().clear();
    }
}

