/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.utility.console;

import fxterm.app.FxEnv;
import fxterm.core.hdw.prt.CommonPrinterJob;
import fxterm.core.kkm.DefaultReportResultListener;
import fxterm.core.kkm.KkmReportJob;
import fxterm.module.utility.console.Handler;
import fxterm.session.Session;
import fxterm.utils.FinUtils;
import org.apache.log4j.Logger;
import plfx.screen.utility.console.ConsoleModule;
import plfx.screen.utility.console.KkmModule;
import ru.softlogic.cash.Sum;
import ru.softlogic.hdw.dev.printer.PrintSpooler;
import ru.softlogic.hdw.dev.printer.kkm.KkmOperation;
import ru.softlogic.hdw.dev.printer.spooler.PrinterJob;
import ru.softlogic.operation.Operation;
import ru.softlogic.reference.point.ServerUser;
import ru.softlogic.reference.service.Service;
import ru.softlogic.service.comission.SumResult;

class KkmHandler
implements KkmModule.Listener,
Handler {
    private final PrintSpooler spooler = FxEnv.getPrintSpooler();
    private final KkmModule module;
    private final Logger log;

    public KkmHandler(KkmModule module, Logger log) {
        this.module = module;
        this.log = log;
    }

    @Override
    public void init(ServerUser user) {
        this.module.setTabState(ConsoleModule.State.Hide);
    }

    @Override
    public void shutdown() {
    }

    public void onZReport() {
        this.log.info((Object)"Execute Z-report");
        this.receivingReport(KkmOperation.FormReportZ);
    }

    public void onXReport() {
        this.log.info((Object)"Execute X-report");
        this.receivingReport(KkmOperation.FormReportX);
    }

    public void onZReportInMemory() {
        this.log.info((Object)"Execute Z-report in memory");
        this.receivingReport(KkmOperation.FormReportZMem);
    }

    public void onTestSell() {
        this.log.info((Object)"Execute test sell");
        Sum sum0 = FinUtils.createVoidSum();
        Sum sum1 = new Sum(1, Session.getInCurrency());
        Service service = new Service();
        service.setName("test");
        service.setPrintName("test");
        Operation operation = new Operation();
        operation.setSumResult(new SumResult(sum1, sum0, sum1, sum1, sum0, sum0, null));
        operation.setService(service);
        CommonPrinterJob testSellJob = new CommonPrinterJob(operation, Session.getData(), Session.getLocale(), "Test check", true, false);
        this.spooler.print((PrinterJob)testSellJob);
    }

    public void onReportFromPeriod() {
        this.log.info((Object)"Get reports from period");
    }

    private void receivingReport(KkmOperation op) {
        DefaultReportResultListener listener = new DefaultReportResultListener();
        KkmReportJob kkmReportJob = new KkmReportJob(op, listener);
        this.spooler.print((PrinterJob)kkmReportJob);
    }
}

