/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.utility.console;

import fxterm.app.FxEnv;
import fxterm.core.hdw.modem.ModemStateInfo;
import fxterm.core.net.ppp.DialupSystem;
import fxterm.core.state.StateFacade;
import fxterm.core.state.StateListener;
import fxterm.core.state.StateMsg;
import fxterm.core.state.TerminalState;
import fxterm.module.utility.console.Handler;
import fxterm.module.utility.console.UsersUtil;
import fxterm.session.Session;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import plfx.screen.utility.console.DeviceStateRecord;
import plfx.screen.utility.console.InfoModule;
import plfx.util.TerminalPlatform;
import ru.softlogic.hdw.DeviceClass;
import ru.softlogic.hdw.DeviceId;
import ru.softlogic.hdw.DeviceIdComparator;
import ru.softlogic.hdw.base.Device;
import ru.softlogic.hdw.handling.DeviceInfo;
import ru.softlogic.hdw.handling.DeviceInfoListener;
import ru.softlogic.hdw.handling.DeviceState;
import ru.softlogic.hdw.handling.DeviceStateListener;
import ru.softlogic.hdw.handling.HdwMsg;
import ru.softlogic.reference.point.ServerUser;

public class InfoHandler
implements Handler,
StateListener {
    private final InfoModule module;
    private final Logger log;
    private final Map<DeviceId, DeviceState> states = new TreeMap<DeviceId, DeviceState>((Comparator<DeviceId>)new DeviceIdComparator());
    private final Map<DeviceId, DeviceInfo> infos = new TreeMap<DeviceId, DeviceInfo>((Comparator<DeviceId>)new DeviceIdComparator());
    private boolean active;

    public InfoHandler(InfoModule module, Logger log) {
        this.module = module;
        this.log = log;
        this.updateDeviceInfo();
    }

    @Override
    public void init(ServerUser user) {
        this.active = true;
        this.module.setTabState(UsersUtil.canShowTab(user, "states"));
        this.refreshView();
        StateFacade.addListener(this);
    }

    @Override
    public void shutdown() {
        this.active = false;
        StateFacade.removeListener(this);
    }

    @Override
    public void onState(TerminalState state) {
        String recommend;
        String warnStr;
        String errorStr;
        if (state != null) {
            errorStr = StateMsg.getStateTitle(state.getErrorCode());
            warnStr = StateMsg.getFlagsTitle(state.getWarningMask());
            recommend = StateMsg.getStateRecommendation(state);
        } else {
            errorStr = "-";
            recommend = "";
            warnStr = "";
        }
        Session.setItem("terminal_state_error", errorStr);
        Session.setItem("terminal_state_warning", warnStr);
        Session.setItem("terminal_recommendation", recommend);
        TerminalPlatform.runLater(() -> FxEnv.refreshScreen());
    }

    private void updateDeviceInfo() {
        this.attachToConsole((Device)FxEnv.getPrintSpooler());
        this.attachToConsole((Device)FxEnv.getBarcodeScanner());
        this.attachToConsole((Device)FxEnv.getBillValidator());
        this.attachToConsole((Device)FxEnv.getBillDispenser());
        this.attachToConsole((Device)FxEnv.getCoinValidator());
        this.attachToConsole((Device)FxEnv.getCoinDispenser());
        this.attachToConsole((Device)FxEnv.getCardDispenser());
        this.attachToConsole((Device)FxEnv.getCardReader());
        this.attachToConsole((Device)FxEnv.getIOController());
    }

    private void attachToConsole(Device device) {
        if (device != null) {
            this.log.info((Object)("Add " + device.getDeviceId()));
            if (device.getLastState() != null) {
                this.states.put(device.getDeviceId(), device.getLastState());
            }
            device.addStateListener((DeviceStateListener)new DevStateListener(device.getDeviceId()));
            if (device.getLastInfo() != null) {
                this.infos.put(device.getDeviceId(), device.getLastInfo());
            }
            device.addDeviceInfoListener((DeviceInfoListener)new DevInfoListener(device.getDeviceId()));
        }
    }

    private synchronized void refreshView() {
        if (this.active) {
            this.log.info((Object)"Refresh view");
            LinkedList<DeviceStateRecord> records = new LinkedList<DeviceStateRecord>();
            for (Map.Entry<DeviceId, DeviceState> entry : this.states.entrySet()) {
                records.add(this.createRecord(entry.getKey(), this.infos.get(entry.getKey()), entry.getValue()));
            }
            this.module.setDeviceInfo(records);
        }
    }

    private DeviceStateRecord createRecord(DeviceId deviceId, DeviceInfo lastInfo, DeviceState lastState) {
        DeviceStateRecord record = new DeviceStateRecord();
        short deviceClass = deviceId.getDeviceClass();
        String name = deviceId.getType();
        if (lastInfo != null) {
            name = lastInfo.getVendor() + " " + (lastInfo.getModel() != null ? lastInfo.getModel() : "");
        }
        record.setType(DeviceClass.asTitleStr((int)deviceClass));
        record.setErrorCode(lastState.getState());
        record.setName(name);
        record.setState(HdwMsg.getStateTitle((int)deviceClass, (int)lastState.getState()));
        record.setWarning(HdwMsg.getFlagsTitle((int)deviceClass, (int)lastState.getFlags()));
        return record;
    }

    private void addModemInfo1(List<DeviceStateRecord> list) {
        DialupSystem dialupSystem = FxEnv.getDialupSystem();
        if (dialupSystem != null && dialupSystem.hasModem()) {
            return;
        }
        DeviceStateRecord record = new DeviceStateRecord();
        record.setType(DeviceClass.asTitleStr((int)6));
        ModemStateInfo modemInfo = Session.getModemInfo();
        if (modemInfo == null) {
            record.setErrorCode(0);
            record.setState("-");
            record.setName("-");
        } else {
            String connectionState = modemInfo.getConnectionState();
            Integer errorCode = this.convertConnectionState(connectionState);
            if (connectionState != null && errorCode != null) {
                record.setState(connectionState);
                record.setErrorCode(errorCode.intValue());
            } else {
                record.setState("-");
                record.setErrorCode(0);
            }
            DeviceInfo deviceInfo = modemInfo.getDeviceInfo();
            if (deviceInfo != null) {
                String name = String.format("%s %s%s", deviceInfo.getVendor(), deviceInfo.getModel(), modemInfo.getNetworkInfo() != null ? " (" + modemInfo.getNetworkInfo().getName() + ")" : "");
                record.setName(name);
            } else {
                record.setName("-");
            }
        }
        list.add(record);
    }

    private Integer convertConnectionState(String connectionState) {
        if (connectionState == null) {
            return null;
        }
        switch (connectionState) {
            case "CONNECT": {
                return 0;
            }
            case "DISCONNECT": {
                return 1;
            }
            case "CONNECTING": {
                return 2;
            }
        }
        return null;
    }

    private synchronized void update(DeviceId deviceId, DeviceState deviceState) {
        this.log.info((Object)("New state: " + deviceId + "->" + deviceState));
        this.states.put(deviceId, deviceState);
        this.refreshView();
    }

    private synchronized void update(DeviceId deviceId, DeviceInfo deviceInfo) {
        this.log.info((Object)("New info: " + deviceId + "->" + deviceInfo));
        this.infos.put(deviceId, deviceInfo);
    }

    private class DevInfoListener
    implements DeviceInfoListener {
        private final DeviceId deviceId;

        public DevInfoListener(DeviceId deviceId) {
            this.deviceId = deviceId;
        }

        public void onDeviceInfo(DeviceInfo info) {
            InfoHandler.this.update(this.deviceId, info);
        }
    }

    private class DevStateListener
    implements DeviceStateListener {
        private final DeviceId deviceId;

        public DevStateListener(DeviceId deviceId) {
            this.deviceId = deviceId;
        }

        public void onState(DeviceState state) {
            InfoHandler.this.update(this.deviceId, state);
        }
    }
}

