/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.utility.console;

import fxterm.app.FxEnv;
import fxterm.app.id.LoggerId;
import fxterm.core.BaseScreenListener;
import fxterm.core.state.TerminalState;
import fxterm.core.task.Task;
import fxterm.module.CancelDialogListener;
import fxterm.module.utility.BaseUtilityModule;
import fxterm.module.utility.console.CashHandler;
import fxterm.module.utility.console.CollectionCopyHandler;
import fxterm.module.utility.console.CvdHandler;
import fxterm.module.utility.console.Handler;
import fxterm.module.utility.console.InfoHandler;
import fxterm.module.utility.console.KkmHandler;
import fxterm.module.utility.console.LogHandler;
import fxterm.module.utility.console.MainModuleHandler;
import fxterm.module.utility.console.ModemHandler;
import fxterm.module.utility.console.QueueHandler;
import fxterm.module.utility.console.UsersUtil;
import fxterm.session.Session;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import plfx.GuiNotifier;
import plfx.screen.CommonScreen;
import plfx.screen.Screen;
import plfx.screen.ScreenCreateException;
import plfx.screen.ScreenListener;
import plfx.screen.ScreenStore;
import plfx.screen.utility.console.CashModule;
import plfx.screen.utility.console.CollectionModule;
import plfx.screen.utility.console.ConsoleFactory;
import plfx.screen.utility.console.ConsoleScreen;
import plfx.screen.utility.console.CvdModule;
import plfx.screen.utility.console.KkmModule;
import plfx.screen.utility.console.LogModule;
import plfx.screen.utility.console.MainModule;
import plfx.screen.utility.console.ModemModule;
import plfx.shell2.dialog.Dialog;
import plfx.shell2.dialog.DialogListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.screen.ActionType;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.parser.ParseException;
import ru.softlogic.reference.point.ServerUser;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.event.EventType;

public class Console
extends BaseUtilityModule {
    private static final String IE_TEXT = "text";
    private static final String IE_NUMBER = "number";
    private static final String IE_COUNT = "count";
    private static final String IE_DENOMINATION = "demonination";
    private ConsoleScreen consoleScreen;
    private final List<Handler> handlers = new LinkedList<Handler>();
    private final Logger log = LoggerId.UTILITY;

    @Override
    protected void _start(Map<String, Object> data) {
        this.log.info((Object)("Run console module, data: " + data));
        try {
            if (!this.authorize(data)) {
                ScreenDescription sd = this.readUtilityForm("console", Locale.getDefault());
                CommonScreen cs = ScreenStore.getCommonScreen((String)sd.getType());
                Session.setScreenDescription(sd);
                cs.init(sd, this.createScreenInit(data));
                cs.setListener((ScreenListener)new LoginListener());
                FxEnv.showScreen((Screen)cs);
                this.log.info((Object)"Login screen open");
            }
        }
        catch (ScreenCreateException | InitException | ParseException ex) {
            this.exit((Exception)ex);
        }
    }

    private boolean authorize(Map<String, Object> data) {
        this.log.info((Object)"Check login/password");
        if (data == null) {
            return false;
        }
        InputElement login = (InputElement)data.get("login");
        InputElement pass = (InputElement)data.get("password");
        if (login == null || pass == null) {
            return false;
        }
        ServerUser user = UsersUtil.authentication(login.getValue(), pass.getValue());
        if (user == null || user.getAccessList() == null || user.getAccessList().isEmpty()) {
            return false;
        }
        this.log.info((Object)"Authentification procedure passed. Open service menu");
        this.log.info((Object)("User permissions: " + user.getAccessList()));
        Session.setItem("menu_user", user);
        if (this.consoleScreen != null) {
            this.initConsoleScreen(user);
        } else {
            new LoadConsoleScreen(user).process();
        }
        return true;
    }

    private void initConsoleScreen(ServerUser user) {
        FxEnv.getConnector().sendEvent(new Event[]{new Event(EventType.ServiceMenuLogin, "login=" + user.getLogin() + ",fio=" + user.getFio())});
        try {
            this.consoleScreen.init();
            for (Handler h : this.handlers) {
                h.init(user);
            }
        }
        catch (Throwable ex) {
            GuiNotifier.notifyError((Throwable)ex);
        }
        FxEnv.showScreen((Screen)this.consoleScreen);
    }

    @Override
    protected void beforeClose() {
        this.log.info((Object)"Deactivate console");
        for (Handler h : this.handlers) {
            h.shutdown();
        }
    }

    private class LoadConsoleScreen
    extends Task {
        private final ServerUser user;

        public LoadConsoleScreen(ServerUser user) {
            this.user = user;
        }

        @Override
        protected String getWaitId() {
            return "wait";
        }

        protected Object execute() throws Exception {
            Console.this.log.info((Object)"Create console screen");
            Console.this.consoleScreen = ConsoleFactory.createConsole();
            MainModuleHandler mmh = new MainModuleHandler(Console.this, Console.this.consoleScreen, Console.this.consoleScreen.getMainModule(), Console.this.log);
            Console.this.consoleScreen.getMainModule().setListener((MainModule.Listener)mmh);
            Console.this.handlers.add(mmh);
            CollectionCopyHandler cch = new CollectionCopyHandler(Console.this.consoleScreen.getCollectionModule(), Console.this.log);
            Console.this.consoleScreen.getCollectionModule().setListener((CollectionModule.Listener)cch);
            Console.this.handlers.add(cch);
            LogHandler lh = new LogHandler(Console.this.consoleScreen.getLogModule(), Console.this.log);
            Console.this.consoleScreen.getLogModule().setListener((LogModule.Listener)lh);
            Console.this.handlers.add(lh);
            CvdHandler ch = new CvdHandler(Console.this.consoleScreen.getCvdModule(), Console.this.log);
            Console.this.consoleScreen.getCvdModule().setListener((CvdModule.Listener)ch);
            Console.this.handlers.add(ch);
            KkmHandler kh = new KkmHandler(Console.this.consoleScreen.getKkmModule(), Console.this.log);
            Console.this.consoleScreen.getKkmModule().setListener((KkmModule.Listener)kh);
            Console.this.handlers.add(kh);
            ModemHandler md = new ModemHandler(Console.this.consoleScreen.getModemModule(), Console.this.log);
            Console.this.consoleScreen.getModemModule().setListener((ModemModule.Listener)md);
            Console.this.handlers.add(md);
            QueueHandler qh = new QueueHandler(Console.this.consoleScreen.getQueueModule(), Console.this.log);
            Console.this.handlers.add(qh);
            InfoHandler ih = new InfoHandler(Console.this.consoleScreen.getInfoModule(), Console.this.log);
            Console.this.handlers.add(ih);
            CashHandler cm = new CashHandler(Console.this.consoleScreen.getCashStoreModule(), Console.this.log);
            Console.this.consoleScreen.getCashStoreModule().setListener((CashModule.Listener)cm);
            Console.this.handlers.add(cm);
            Console.this.log.info((Object)"Done");
            return null;
        }

        protected void onResult(Object object) {
            Console.this.initConsoleScreen(this.user);
        }

        @Override
        protected void onError(Exception ex) {
            Console.this.log.error((Object)"Error on create console screen");
            Console.this.exit(ex);
        }
    }

    private class LoginListener
    extends BaseScreenListener {
        private LoginListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            Console.this.log.info((Object)("Action on login screen: " + action + ", data=" + data));
            if (ActionType.isExit((String)action)) {
                Console.this.exit();
            } else if (ActionType.isPrev((String)action)) {
                TerminalState state = (TerminalState)Session.getData().get("terminal_state");
                if (state == null || state.getErrorCode() == 0) {
                    Console.this.back();
                } else {
                    Console.this.exit();
                }
            } else if (ActionType.isNext((String)action) && !Console.this.authorize(data)) {
                Dialog.show((String)"module/utility/console/error_auth", (DialogListener)new CancelDialogListener(cancelListener));
            }
        }
    }
}

