/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.utility.console;

import fxterm.app.FxEnv;
import fxterm.core.hdw.bvr.col.CollectionHelper;
import fxterm.core.hdw.prt.PrnUtils;
import fxterm.module.utility.console.Handler;
import fxterm.module.utility.console.NetworkTask;
import fxterm.module.utility.console.UsersUtil;
import fxterm.utils.CompatUtils;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import plfx.screen.utility.console.CollectionModule;
import plfx.screen.utility.console.TableModel;
import plfx.shell2.dialog.Dialog;
import ru.softlogic.hardware.currency.SumFormatter;
import ru.softlogic.hardware.currency.set.DenominationSet;
import ru.softlogic.hdw.DeviceClass;
import ru.softlogic.reference.point.ServerUser;
import ru.softlogic.srv.api.oth.MoneyCollection;

class CollectionCopyHandler
implements CollectionModule.Listener,
Handler {
    private final CollectionModule module;
    private final Logger log;
    private ServerUser user;

    public CollectionCopyHandler(CollectionModule module, Logger log) {
        this.module = module;
        this.log = log;
    }

    @Override
    public void init(ServerUser user) {
        this.user = user;
        this.module.setTabState(UsersUtil.canShowTab(user, "collection"));
        this.module.setCollections(null);
    }

    @Override
    public void shutdown() {
        this.module.setCollections(null);
    }

    public void onCollectionsRequest() {
        this.log.info((Object)"Request collections");
        new CollectionTask().process();
    }

    private void onCollections(MoneyCollection[] collections) {
        DateFormat df = DateFormat.getDateTimeInstance(3, 2);
        int count = this.user.getShowIncassCount() == null ? collections.length : Math.min(this.user.getShowIncassCount(), collections.length);
        LinkedList<TableModel.Row> rows = new LinkedList<TableModel.Row>();
        for (int i = 0; i < count; ++i) {
            MoneyCollection mc = collections[i];
            DenominationSet ds = new DenominationSet(CompatUtils.convertCashUnitMap(mc.getKeeper().getCashUnits()));
            List titles = ds.getTotals().stream().map(SumFormatter::asStr).collect(Collectors.toList());
            TableModel.Row row = new TableModel.Row(null, (Runnable)new CollectionRunnable(mc));
            row.setProperty0(DeviceClass.asStr((short)mc.getDeviceClass()) + "#" + mc.getDeviceNum());
            row.setProperty1("BOX#" + mc.getBoxNum());
            row.setProperty2(Integer.toString(mc.getId()));
            row.setProperty3(mc.getType() == 0 ? "COLLECTION" : "REPLACING");
            row.setProperty4(df.format(mc.getDate()));
            row.setProperty5(titles.toString());
            rows.add(row);
        }
        this.log.info((Object)"Update screen");
        this.module.setCollections(new TableModel(rows));
    }

    private class CollectionRunnable
    implements Runnable {
        private MoneyCollection mc;

        public CollectionRunnable(MoneyCollection mc) {
            if (mc == null) {
                throw new NullPointerException("Collection is null");
            }
            this.mc = mc;
        }

        @Override
        public void run() {
            CollectionCopyHandler.this.log.info((Object)("Print collection: " + this.mc));
            FxEnv.getPrintSpooler().print(PrnUtils.createPrinterJob(CollectionHelper.convert(this.mc)));
        }
    }

    class CollectionTask
    extends NetworkTask<MoneyCollection[]> {
        CollectionTask() {
        }

        @Override
        protected MoneyCollection[] execute() throws Exception {
            return FxEnv.getConnector().getCollections();
        }

        @Override
        protected void onResult(MoneyCollection[] mcs) {
            CollectionCopyHandler.this.log.info((Object)("Collections " + Arrays.toString(mcs)));
            if (mcs == null || mcs.length == 0) {
                Dialog.show((String)"module/utility/console/collections_notfound");
            } else {
                CollectionCopyHandler.this.onCollections(mcs);
            }
        }
    }
}

