/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.utility.console;

import fxterm.app.id.LoggerId;
import fxterm.core.task.Task;
import java.util.Map;
import org.apache.log4j.Logger;
import plfx.shell2.dialog.Dialog;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hdw.dev.cashacc.ClearListener;
import ru.softlogic.hdw.dev.cashacc.PayoutModule;

class ClearPayoutTask
extends Task
implements ClearListener {
    private PayoutModule pm;
    private Runnable runnable;
    private final Logger log = LoggerId.UTILITY;
    private boolean finished;

    public ClearPayoutTask(PayoutModule pm, Runnable runnable) {
        if (pm == null) {
            throw new NullPointerException("PayoutModule is null");
        }
        if (runnable == null) {
            throw new NullPointerException("Runnable is null");
        }
        this.pm = pm;
        this.runnable = runnable;
    }

    @Override
    protected String getWaitId() {
        return "wait";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object execute() throws Exception {
        this.log.info((Object)"Start clear payout task");
        Map counts = this.pm.getCounts();
        this.log.info((Object)("Counts: " + counts));
        if (!counts.isEmpty()) {
            this.log.info((Object)"Add it to cash box");
            for (Denomination d : counts.keySet()) {
                int cnt = (Integer)counts.get(d);
                if (cnt <= 0) continue;
            }
        }
        this.log.info((Object)"Send clear command");
        this.pm.clear((ClearListener)this);
        this.log.info((Object)"Wait for result");
        try {
            ClearPayoutTask clearPayoutTask = this;
            synchronized (clearPayoutTask) {
                if (!this.finished) {
                    this.wait();
                }
            }
            this.log.info((Object)"Success");
            return "success";
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw ex;
        }
    }

    protected void onResult(Object object) {
        Dialog.show((String)"module/utility/console/payout_clear_ok");
        this.runnable.run();
    }

    @Override
    protected void onError(Exception ex) {
        this.log.error((Object)"Error on clear payout", (Throwable)ex);
        Dialog.show((String)"module/utility/console/payout_clear_error");
        this.runnable.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFinish() {
        ClearPayoutTask clearPayoutTask = this;
        synchronized (clearPayoutTask) {
            this.finished = true;
            this.notifyAll();
        }
    }
}

