/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.utility.console;

import fxterm.app.id.LoggerId;
import fxterm.core.task.Task;
import java.util.Objects;
import org.apache.log4j.Logger;
import plfx.shell2.dialog.Dialog;
import ru.softlogic.hdw.dev.cashdisp.EmptyChannel;
import ru.softlogic.hdw.dev.cashdisp.EmptyListener;

class ClearBoxTask
extends Task
implements EmptyListener {
    private static final Logger log = LoggerId.UTILITY;
    private final EmptyChannel emptyChannel;
    private final Runnable runnable;
    private volatile EmptyListener.Event event;

    public ClearBoxTask(EmptyChannel emptyChannel, Runnable runnable) {
        this.emptyChannel = Objects.requireNonNull(emptyChannel, "EmptyChannel is null");
        this.runnable = Objects.requireNonNull(runnable, "Runnable is null");
    }

    @Override
    protected String getWaitId() {
        return "wait";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object execute() throws Exception {
        log.info((Object)"Start clear box task");
        this.emptyChannel.empty((EmptyListener)this);
        log.info((Object)"Wait for result");
        try {
            ClearBoxTask clearBoxTask = this;
            synchronized (clearBoxTask) {
                while (this.event == null || !this.event.isFinalState()) {
                    log.info((Object)("New event: " + this.event));
                    this.wait();
                }
            }
            log.info((Object)"Success");
            return "success";
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw ex;
        }
    }

    protected void onResult(Object object) {
        log.info((Object)("Show result: " + this.event));
        if (this.event == EmptyListener.Event.Success) {
            Dialog.show((String)"module/utility/console/payout_clear_ok", actionId -> this.runnable.run());
        } else {
            Dialog.show((String)"module/utility/console/payout_clear_error", actionId -> this.runnable.run());
        }
    }

    @Override
    protected void onError(Exception ex) {
        log.error((Object)"Error on clear payout", (Throwable)ex);
        Dialog.show((String)"module/utility/console/payout_clear_error", actionId -> this.runnable.run());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(EmptyListener.Event event) {
        log.info((Object)("Get event: " + event));
        ClearBoxTask clearBoxTask = this;
        synchronized (clearBoxTask) {
            this.event = event;
            this.notifyAll();
        }
    }
}

