/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.utility.console;

import fxterm.app.FxEnv;
import fxterm.core.hdw.bvr.col.CollectionException;
import fxterm.core.hdw.bvr.col.CollectionHelper;
import fxterm.core.hdw.bvr.col.CollectionQueue;
import fxterm.core.hdw.bvr.col.CollectionRequest;
import fxterm.core.hdw.bvr.col.MultiCollectionRequest;
import fxterm.core.hdw.cdm.DenominationSelection;
import fxterm.core.hdw.cdm.DenominationSelectorFacade;
import fxterm.module.utility.console.ClearBoxTask;
import fxterm.module.utility.console.Handler;
import fxterm.module.utility.console.UsersUtil;
import fxterm.session.Session;
import java.text.DateFormat;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import plfx.GuiNotifier;
import plfx.screen.ScreenCreateException;
import plfx.screen.utility.console.CashModule;
import plfx.screen.utility.console.ConsoleModule;
import plfx.screen.utility.console.SelectorModel;
import plfx.screen.utility.console.TableModel;
import plfx.screen.utility.console.encash.EncashAddScreen;
import plfx.screen.utility.console.encash.EncashListScreen;
import plfx.screen.utility.console.encash.EncashScreenFactory;
import plfx.shell.custom.TimeoutListener;
import plfx.shell2.dialog.Dialog;
import plfx.shell2.dialog.DialogListener;
import plfx.shell2.dialog.OkDialogListener;
import ru.softlogic.hardware.currency.DefaultComparator;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hardware.currency.Sum;
import ru.softlogic.hardware.currency.SumFormatter;
import ru.softlogic.hardware.currency.set.DenominationSet;
import ru.softlogic.hdw.DeviceClass;
import ru.softlogic.hdw.dev.cashdisp.EmptyChannel;
import ru.softlogic.input.model.field.numeric.Range;
import ru.softlogic.input.model.field.text.NumericRangeValidator;
import ru.softlogic.reference.point.ServerUser;
import ru.softlogic.storage.cash.Box;
import ru.softlogic.storage.cash.BoxId;
import ru.softlogic.storage.cash.Store;
import ru.softlogic.storage.cash.StoreManager;
import ru.softlogic.storage.cash.StoreMsg;

class CashHandler
implements CashModule.Listener,
Handler {
    private static final int DEFAULT_TIMEOUT = 45;
    private final CashModule module;
    private final Logger log;
    private ServerUser user;
    private short deviceClass;
    private Store store;
    private Box box;
    private EncashListScreen encashListScreen;
    private EncashListListener encashListListener;
    private EncashAddScreen encashAddScreen;
    private EncashAddListener encashAddListener;
    private plfx.shell.custom.Handler encashHandler;
    private Map<Denomination, Integer> counts;
    private List<Denomination> denominations;

    public CashHandler(CashModule module, Logger log) {
        this.module = module;
        this.log = log;
    }

    @Override
    public void init(ServerUser user) {
        this.user = user;
        this.module.setTabState(UsersUtil.canShowTab(user, "cash"));
        LinkedList<SelectorModel.Item> items = new LinkedList<SelectorModel.Item>();
        for (Map.Entry entry : StoreManager.getDefaultStores().entrySet()) {
            items.add(new SelectorModel.Item(DeviceClass.asTitleStr((int)((Short)entry.getKey()).shortValue()), (Runnable)new StoreSetter((Short)entry.getKey(), (Store)entry.getValue())));
        }
        this.module.setStores(new SelectorModel(items));
    }

    @Override
    public void shutdown() {
    }

    public void onCashMoneyCollection() {
        this.log.info((Object)"Process cash collection");
        this.collect(CollectionRequest.DEFAULT_BILL_BOX);
    }

    public void onCoinMoneyCollection() {
        this.log.info((Object)"Process coin collection");
        this.collect(CollectionRequest.DEFAULT_COIN_BOX);
    }

    public void onRefillSelected() {
        this.log.info((Object)"On refill selected");
        this.counts = new TreeMap<Denomination, Integer>((Comparator<Denomination>)new DefaultComparator());
        this.setBoxInfo(new BoxId(this.deviceClass, this.box.getId()));
        this.showEncashList();
    }

    public void onCollectSelected() {
        this.log.info((Object)"On collect selected");
        this.collect(new BoxId(this.deviceClass, this.box.getId()));
    }

    public void onAllCollectSelected() {
        this.log.info((Object)"On all collect selected");
        this.collectAll(this.deviceClass);
    }

    public void onEmptySelected() {
        this.log.info((Object)"On empty selected");
        new ClearBoxTask((EmptyChannel)this.box.getPhysicalBox().getEmptyChannels().get(0), this::updateDeviceContent).process();
    }

    private TableModel createModel(DenominationSet set) {
        LinkedList<TableModel.Row> rows = new LinkedList<TableModel.Row>();
        for (String curr : set.getCurrencies()) {
            int totalCount = 0;
            Sum totalSum = new Sum(0, curr);
            for (Map.Entry entry : set.getCounts(curr).entrySet()) {
                TableModel.Row row = new TableModel.Row();
                Denomination d = (Denomination)entry.getKey();
                int c = (Integer)entry.getValue();
                Sum sum = new Sum(d.getNominal() * c, d.getCurrency());
                totalCount += c;
                totalSum = totalSum.add(sum);
                row.setProperty0(String.format("%.2f", Float.valueOf((float)d.getNominal() / 100.0f)));
                row.setProperty1(((Denomination)entry.getKey()).getCurrency());
                row.setProperty2(Integer.toString(c));
                row.setProperty3(SumFormatter.asStr((Sum)sum));
                rows.add(row);
            }
            TableModel.Row total = new TableModel.Row("store-total");
            total.setProperty0("");
            total.setProperty1(curr);
            total.setProperty2(Integer.toString(totalCount));
            total.setProperty3(SumFormatter.asStr((Sum)totalSum));
            rows.add(total);
        }
        return new TableModel(rows);
    }

    private void updateDeviceContent() {
        this.updateStoreContent();
        this.updateBoxContent();
    }

    private void updateStoreContent() {
        DenominationSet set = new DenominationSet();
        for (Box b : this.store.getBoxes()) {
            for (Map.Entry entry : b.getCounts().entrySet()) {
                set.add((Denomination)entry.getKey(), ((Integer)entry.getValue()).intValue());
            }
        }
        this.module.setStoreContent(this.createModel(set));
    }

    private void updateBoxContent() {
        boolean add = this.box.isEmpty() || this.box.getBoxInfo().isFeatureSupport(32);
        this.module.setButtonState(3, this.getState(2, add));
        DateFormat df = DateFormat.getDateTimeInstance(3, 2);
        this.module.setBoxContent(this.createModel(new DenominationSet(this.box.getCounts())), this.box.getLastEmpty() != null ? df.format(this.box.getLastEmpty()) : "", this.box.getLastRefill() != null ? df.format(this.box.getLastRefill()) : "");
    }

    private void setBoxInfo(BoxId boxId) {
        Session.setItem("collect_device", DeviceClass.asStr((short)boxId.getDeviceClass()) + "#" + boxId.getDeviceNumber());
        Session.setItem("collect_box", "#" + this.box.getId() + " - " + StoreMsg.boxTypeAsStr((int)this.box.getBoxInfo().getType()));
    }

    private void collect(final BoxId boxId) {
        this.log.info((Object)("Process collection: " + boxId));
        this.setBoxInfo(boxId);
        Dialog.show((String)"module/utility/console/collect_confirm", (DialogListener)new OkDialogListener(){

            protected void onOk() {
                try {
                    CollectionQueue.makeCollection(new CollectionRequest(boxId, CashHandler.this.user));
                    CashHandler.this.updateDeviceContent();
                }
                catch (CollectionException ex) {
                    GuiNotifier.notifyError((Throwable)ex);
                    Dialog.show((String)"common/error");
                }
            }
        });
    }

    private void collectAll(final short deviceClass) {
        this.log.info((Object)"Process collection");
        Session.setItem("collect_device", DeviceClass.asStr((short)deviceClass));
        Session.setItem("collect_box", null);
        Dialog.show((String)"module/utility/console/collect_confirm", (DialogListener)new OkDialogListener(){

            protected void onOk() {
                try {
                    CollectionQueue.makeCollection(new MultiCollectionRequest(CollectionHelper.convert(CashHandler.this.store.getBoxes(), deviceClass), CashHandler.this.user));
                    CashHandler.this.updateDeviceContent();
                }
                catch (CollectionException ex) {
                    GuiNotifier.notifyError((Throwable)ex);
                    Dialog.show((String)"common/error");
                }
            }
        });
    }

    private void refill(BoxId boxId) {
        this.log.info((Object)("Process refill: " + boxId + ", counts: " + this.counts));
        try {
            CollectionQueue.makeRefill(new CollectionRequest(boxId, this.user), this.counts);
            this.updateDeviceContent();
        }
        catch (CollectionException ex) {
            GuiNotifier.notifyError((Throwable)ex);
            Dialog.show((String)"common/error");
        }
    }

    private void showEncashList() {
        if (this.encashListScreen == null) {
            this.log.info((Object)"Try to create screen");
            try {
                this.encashListScreen = EncashScreenFactory.createListScreen();
                this.encashListListener = new EncashListListener();
                this.encashListScreen.setListener((EncashListScreen.Listener)this.encashListListener);
                this.log.info((Object)"Success");
            }
            catch (ScreenCreateException ex) {
                GuiNotifier.notifyError((Throwable)ex);
                Dialog.show((String)"common/error");
                return;
            }
        }
        this.log.info((Object)"Show popup");
        boolean addEnable = this.counts.isEmpty() || this.box.getBoxInfo().isFeatureSupport(4);
        TableModel model = this.createModel(new DenominationSet(this.counts));
        this.encashListScreen.init(model, addEnable);
        this.encashHandler = FxEnv.getCustomModule().show(this.encashListScreen.getTemplate(), (TimeoutListener)this.encashListListener, 45);
    }

    private ConsoleModule.State getState(int feature) {
        return this.box.getBoxInfo().isFeatureSupport(feature) ? ConsoleModule.State.Visible : ConsoleModule.State.Disable;
    }

    private ConsoleModule.State getState(int feature, boolean addtional) {
        return this.box.getBoxInfo().isFeatureSupport(feature) && addtional ? ConsoleModule.State.Visible : ConsoleModule.State.Disable;
    }

    private class EncashAddListener
    implements EncashAddScreen.Listener,
    TimeoutListener {
        private EncashAddListener() {
        }

        public void onTimeout() {
            CashHandler.this.log.info((Object)"EncashAdd: onTimeout");
            CashHandler.this.encashHandler.close();
            CashHandler.this.encashHandler = FxEnv.getCustomModule().show(CashHandler.this.encashListScreen.getTemplate(), (TimeoutListener)CashHandler.this.encashListListener, 45);
        }

        public void onCancel() {
            CashHandler.this.log.info((Object)"EncashAdd: onCancel");
            CashHandler.this.encashHandler.close();
            CashHandler.this.encashHandler = FxEnv.getCustomModule().show(CashHandler.this.encashListScreen.getTemplate(), (TimeoutListener)CashHandler.this.encashListListener, 45);
        }

        public void onAddItem(int itemId, int count) {
            CashHandler.this.log.info((Object)("EncashAdd: onAddItem " + itemId + ", count=" + count));
            CashHandler.this.encashHandler.close();
            CashHandler.this.counts.put(CashHandler.this.denominations.get(itemId), count);
            CashHandler.this.showEncashList();
        }
    }

    private class EncashListListener
    implements EncashListScreen.Listener,
    TimeoutListener {
        private EncashListListener() {
        }

        public void onCancel() {
            CashHandler.this.log.info((Object)"EncashList: cancel");
            CashHandler.this.encashHandler.close();
        }

        public void onAddDenomination() {
            CashHandler.this.log.info((Object)"EncashList addDenomination");
            CashHandler.this.encashHandler.close();
            CashHandler.this.log.info((Object)"On refill selected");
            if (CashHandler.this.encashAddScreen == null) {
                CashHandler.this.log.info((Object)"Try to create add screen");
                try {
                    CashHandler.this.encashAddScreen = EncashScreenFactory.createAddScreen();
                    CashHandler.this.encashAddListener = new EncashAddListener();
                    CashHandler.this.encashAddScreen.setListener((EncashAddScreen.Listener)CashHandler.this.encashAddListener);
                    CashHandler.this.log.info((Object)"Success");
                }
                catch (ScreenCreateException ex) {
                    GuiNotifier.notifyError((Throwable)ex);
                    Dialog.show((String)"common/error");
                    return;
                }
            }
            CashHandler.this.log.info((Object)"Build denomination list");
            long cnt = Stream.of(CashHandler.this.store.getBoxes()).filter(b -> b.getPhysicalBox() != null).count();
            CashHandler.this.log.info((Object)("Boxes count: " + cnt));
            DenominationSelection ds = DenominationSelectorFacade.select(CashHandler.this.deviceClass, (int)cnt, CashHandler.this.box.getId());
            CashHandler.this.log.info((Object)("Result: " + ds));
            CashHandler.this.denominations = new LinkedList();
            LinkedList<SelectorModel.Item> items = new LinkedList<SelectorModel.Item>();
            for (Denomination d : ds.getDenominations()) {
                CashHandler.this.denominations.add(d);
                items.add(new SelectorModel.Item(SumFormatter.asStr((Denomination)d)));
            }
            SelectorModel sm = new SelectorModel(items);
            CashHandler.this.encashAddScreen.init(sm, ds.getDefaultCount(), new NumericRangeValidator(new Range(0.0f, (float)(CashHandler.this.box.getBoxInfo().getCapacity() != null ? CashHandler.this.box.getBoxInfo().getCapacity() : 1000))));
            CashHandler.this.log.info((Object)"Show popup");
            CashHandler.this.encashHandler = FxEnv.getCustomModule().show(CashHandler.this.encashAddScreen.getTemplate(), (TimeoutListener)CashHandler.this.encashAddListener, 45);
        }

        public void onRefill() {
            CashHandler.this.log.info((Object)"EncashList: onRefill");
            CashHandler.this.encashHandler.close();
            CashHandler.this.refill(new BoxId(CashHandler.this.deviceClass, CashHandler.this.box.getId()));
        }

        public void onTimeout() {
            CashHandler.this.log.info((Object)"EncashList: onTimeout");
            CashHandler.this.encashHandler.close();
        }
    }

    private class BoxSetter
    implements Runnable {
        private final Box box;

        public BoxSetter(Box box) {
            if (box == null) {
                throw new NullPointerException("Box is null");
            }
            this.box = box;
        }

        @Override
        public void run() {
            List ech;
            CashHandler.this.log.info((Object)("Process box: " + this.box.getId() + ", info: " + this.box.getBoxInfo()));
            CashHandler.this.box = this.box;
            ConsoleModule.State state = CashHandler.this.getState(1);
            if (ConsoleModule.State.Visible.equals((Object)state)) {
                if (CashHandler.this.deviceClass == 3) {
                    state = UsersUtil.canShowButton(CashHandler.this.user, "cash", "cashMoneyCollection");
                } else if (CashHandler.this.deviceClass == 4) {
                    state = UsersUtil.canShowButton(CashHandler.this.user, "cash", "coinMoneyCollection");
                }
            }
            CashHandler.this.module.setButtonState(4, state);
            if (CashHandler.this.store.getBoxes().length < 2) {
                state = ConsoleModule.State.Disable;
            }
            CashHandler.this.module.setButtonState(7, state);
            CashHandler.this.module.setButtonState(5, ConsoleModule.State.Disable);
            CashHandler.this.module.setButtonState(6, ConsoleModule.State.Hide);
            if (this.box.getPhysicalBox() != null && !this.box.getPhysicalBox().getEmptyChannels().isEmpty() && !(ech = this.box.getPhysicalBox().getEmptyChannels()).isEmpty()) {
                CashHandler.this.module.setButtonState(5, CashHandler.this.getState(2));
            }
            CashHandler.this.updateBoxContent();
        }
    }

    private class StoreSetter
    implements Runnable {
        private final short deviceClass;
        private final Store store;

        public StoreSetter(short deviceClass, Store store) {
            this.deviceClass = deviceClass;
            this.store = store;
        }

        @Override
        public void run() {
            CashHandler.this.log.info((Object)("Process store: " + this.deviceClass));
            CashHandler.this.deviceClass = this.deviceClass;
            CashHandler.this.store = this.store;
            LinkedList<SelectorModel.Item> model = new LinkedList<SelectorModel.Item>();
            for (Box b : this.store.getBoxes()) {
                model.add(new SelectorModel.Item("#" + b.getId() + " - " + StoreMsg.boxTypeAsStr((int)b.getBoxInfo().getType()), (Runnable)new BoxSetter(b)));
            }
            CashHandler.this.module.setBoxes(new SelectorModel(model, 0, model.size() <= 1));
            CashHandler.this.updateStoreContent();
        }
    }
}

