/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.utility.console;

import fxterm.core.BaseScreenListener;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.screen.ActionType;
import ru.softlogic.storage.cash.Box;
import ru.softlogic.storage.cash.WrongOperationException;

public class BoxAddListener
extends BaseScreenListener {
    private final Box box;
    private final Logger log;
    private final Denomination denomination;
    private final Runnable closer;

    public BoxAddListener(Box box, Denomination denomination, Logger log, Runnable closer) {
        this.box = box;
        this.log = log;
        this.denomination = denomination;
        this.closer = closer;
    }

    public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
        this.log.info((Object)("Action on cvd screen: " + action + ", data: " + data));
        if (ActionType.isNext((String)action)) {
            try {
                InputElement ie = (InputElement)data.get("count");
                this.box.refill(this.denomination, Integer.parseInt(ie.getValue()));
                if (this.closer != null) {
                    this.closer.run();
                }
            }
            catch (WrongOperationException ex) {
                this.log.error((Object)"Error on refill", (Throwable)ex);
            }
        }
    }
}

