/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.utility.chcopy;

import fxterm.app.FxEnv;
import fxterm.app.id.LoggerId;
import fxterm.core.BaseScreenListener;
import fxterm.core.hdw.prt.PrnUtils;
import fxterm.core.menu.GroupByMenuItemVisitor;
import fxterm.core.menu.MenuByServiceIdVisitor;
import fxterm.core.menu.MenuUtils;
import fxterm.core.task.Task;
import fxterm.module.CancelDialogListener;
import fxterm.module.input.ExitModuleListener;
import fxterm.module.utility.BaseUtilityModule;
import fxterm.session.Session;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import plfx.screen.CommonScreen;
import plfx.screen.Screen;
import plfx.screen.ScreenCreateException;
import plfx.screen.ScreenListener;
import plfx.screen.ScreenStore;
import plfx.shell2.dialog.Dialog;
import plfx.shell2.dialog.DialogListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.text.SimpleFormatter;
import ru.softlogic.input.model.screen.ActionType;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.operation.Operation;
import ru.softlogic.parser.ParseException;
import ru.softlogic.provider.ProviderType;

public class DocCopy
extends BaseUtilityModule {
    private final Logger log = LoggerId.UTILITY;
    private Runnable cancelListener;

    @Override
    public void _start(Map<String, Object> data) {
        this.log.info((Object)"Run document copy module");
        try {
            ScreenDescription sd = this.readUtilityForm("checkcopy", Locale.getDefault());
            CommonScreen cs = ScreenStore.getCommonScreen((String)sd.getType());
            Session.setScreenDescription(sd);
            cs.init(sd, this.createScreenInit(null));
            cs.setListener((ScreenListener)new LocalScreenListener());
            FxEnv.showScreen((Screen)cs);
        }
        catch (ScreenCreateException | InitException | ParseException ex) {
            this.exit((Exception)ex);
        }
    }

    private void fixOperation(Operation op) {
        if (op == null) {
            return;
        }
        Session.setService(op.getService());
        Session.setCommission(op.getCommission());
        MenuByServiceIdVisitor mbsiv = new MenuByServiceIdVisitor(op.getService().getId());
        MenuUtils.processMenu(mbsiv);
        if (mbsiv.getMenuItem() != null) {
            this.log.info((Object)mbsiv.getMenuItem());
            GroupByMenuItemVisitor gbmiv = new GroupByMenuItemVisitor(mbsiv.getMenuItem());
            MenuUtils.processMenu(gbmiv);
            op.setServiceType(gbmiv.getServiceType());
            Session.setSelectedItem(mbsiv.getMenuItem());
            Session.setServiceType(gbmiv.getServiceType());
        } else {
            this.log.error((Object)("Menu item by service id " + op.getService().getId() + " not found"));
        }
        op.setCopy(true);
        if (op.getService() != null) {
            if (op.getService().getProviderType() == ProviderType.Mobile) {
                SimpleFormatter formatter = new SimpleFormatter("8(***)***-****");
                op.getTitles().put("id1", "\u041d\u043e\u043c\u0435\u0440");
                op.getViews().put("id1", formatter.format((String)op.getForm().get("id1")));
                InputElement ie = (InputElement)op.getInputElements().get("id1");
                if (ie != null) {
                    ie.setKeyTitle("\u041d\u043e\u043c\u0435\u0440");
                    ie.setValueTitle(formatter.format((String)op.getForm().get("id1")));
                }
            } else {
                this.fixIe((InputElement)op.getInputElements().get("id1"));
                this.fixIe((InputElement)op.getInputElements().get("id2"));
                if (op.getViews().get("id1") == null) {
                    op.getViews().put("id1", op.getForm().get("id1"));
                }
                if (op.getTitles().get("id1") == null) {
                    op.getTitles().put("id1", "");
                }
                if (op.getTitles().get("id2") == null) {
                    op.getTitles().put("id2", "");
                }
                if (op.getViews().get("id2") == null && op.getForm().get("id2") != null) {
                    op.getViews().put("id2", op.getForm().get("id2"));
                }
            }
        }
    }

    private void fixIe(InputElement ie) {
        if (ie != null) {
            if (ie.getKeyTitle() == null) {
                ie.setKeyTitle("");
            }
            if (ie.getValueTitle() == null) {
                ie.setValueTitle("");
            }
        }
    }

    @Override
    protected boolean isPaperRequire() {
        return true;
    }

    private class RequestAccountTask
    extends Task {
        private final String number;
        private final String pin;

        public RequestAccountTask(String number, String pin) {
            this.number = number;
            this.pin = pin;
        }

        @Override
        protected String getWaitId() {
            return "doccopy.get.data";
        }

        protected Object execute() throws Exception {
            DocCopy.this.log.info((Object)("Request doc copy: oper=" + this.number + ",pin=" + this.pin));
            return FxEnv.getConnector().checkCopy(Long.parseLong(this.number), this.pin);
        }

        protected void onResult(Object object) {
            DocCopy.this.log.info((Object)("Result: " + object));
            Operation op = (Operation)object;
            if (op == null) {
                DocCopy.this.log.info((Object)"Operation is null");
                Dialog.show((String)"module/utility/dcopy/notfound", (DialogListener)new CancelDialogListener(DocCopy.this.cancelListener));
            } else {
                DocCopy.this.fixOperation(op);
                DocCopy.this.log.info((Object)("Views=" + op.getViews() + ", titles=" + op.getTitles() + ", form=" + op.getForm() + ", point=" + op.getPoint() + ", dealer=" + op.getDealer()));
                DocCopy.this.log.info((Object)("Sum result: " + op.getSumResult()));
                FxEnv.getPrintSpooler().print(PrnUtils.createPrinterJob(op, false).get(0));
                Dialog.show((String)"module/utility/dcopy/success", (DialogListener)new ExitModuleListener(DocCopy.this));
            }
        }

        @Override
        public void onError(Exception ex) {
            DocCopy.this.log.error((Object)ex, (Throwable)ex);
            Dialog.show((String)"module/utility/dcopy/neterror", (DialogListener)new CancelDialogListener(DocCopy.this.cancelListener));
        }
    }

    private class LocalScreenListener
    extends BaseScreenListener {
        private LocalScreenListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            DocCopy.this.log.info((Object)("Action: " + action + ", data=" + data));
            DocCopy.this.cancelListener = cancelListener;
            if (ActionType.isNext((String)action)) {
                InputElement number = (InputElement)data.get("number");
                InputElement pin = (InputElement)data.get("pin");
                new RequestAccountTask(number.getValue(), pin.getValue()).process();
            } else if (ActionType.isPrev((String)action)) {
                DocCopy.this.back();
            } else {
                DocCopy.this.exit();
            }
        }
    }
}

