/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.utility.calib;

import fxterm.app.FxEnv;
import fxterm.app.id.LoggerId;
import fxterm.module.utility.UtilityModule;
import java.util.Map;
import org.apache.log4j.Logger;
import plfx.screen.ScreenCreateException;
import plfx.screen.utility.calib.CalibListener;
import plfx.screen.utility.calib.CalibScreen;
import plfx.screen.utility.calib.CalibScreenFactory;
import plfx.shell.custom.Handler;
import plfx.shell.custom.TimeoutListener;
import ru.softlogic.srv.api.status.DeviceStatus;

public class Calibrator
implements UtilityModule {
    private CalibScreen screen;
    private Handler handler;
    private final Logger log = LoggerId.UTILITY;

    @Override
    public void start(Map<String, Object> data) {
        if (this.screen == null) {
            try {
                this.screen = CalibScreenFactory.createScreen();
                this.screen.setListener((CalibListener)new LocalCalibListener());
            }
            catch (ScreenCreateException ex) {
                return;
            }
        }
        this.screen.init();
        this.handler = FxEnv.getCustomModule().show(this.screen.getTemplate(), (TimeoutListener)new LocalTimeoutListener(), 30);
    }

    private class LocalCalibListener
    implements CalibListener {
        private LocalCalibListener() {
        }

        public void onSuccess() {
            Calibrator.this.handler.close();
            FxEnv.getConnector().sendStatus(new DeviceStatus(Short.valueOf((short)13), 0));
        }

        public void onCancel() {
            Calibrator.this.handler.close();
            FxEnv.getConnector().sendStatus(new DeviceStatus(Short.valueOf((short)13), 1));
        }
    }

    private class LocalTimeoutListener
    implements TimeoutListener {
        private LocalTimeoutListener() {
        }

        public void onTimeout() {
            Calibrator.this.handler.close();
            Calibrator.this.log.info((Object)"Close calib screen by timeout, send error to server");
            FxEnv.getConnector().sendStatus(new DeviceStatus(Short.valueOf((short)13), 2));
        }
    }
}

