/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.utility;

import fxterm.app.id.LoggerId;
import fxterm.module.input.ModuleCreateException;
import fxterm.module.utility.UtilityModule;
import fxterm.module.utility.calib.Calibrator;
import fxterm.module.utility.chcopy.DocCopy;
import fxterm.module.utility.console.Console;
import fxterm.module.utility.paystat.PayStatus;
import fxterm.module.utility.search.SearchService;
import fxterm.msg.Messages;
import java.util.Map;
import org.apache.log4j.Logger;
import plfx.GuiNotifier;
import plfx.util.Cache2;

public class UtilityModuleFactory {
    public static final int CHECK_COPY = 0;
    public static final int PAY_STATE = 1;
    public static final int CONSOLE = 2;
    public static final int SEARCH_SERVICE = 3;
    public static final int CALIB_VALIDATOR = 4;
    private static final Logger log = LoggerId.UTILITY;
    private static final ModuleCache cache = new ModuleCache();

    public static UtilityModule getModule(int type) throws ModuleCreateException {
        UtilityModule um = (UtilityModule)cache.getObject(type);
        if (um == null) {
            throw new ModuleCreateException("Can't create module: " + Messages.getUtilityModuleType(type));
        }
        return um;
    }

    public static void runQuietly(int type) {
        try {
            UtilityModuleFactory.getModule(type).start(null);
        }
        catch (ModuleCreateException ex) {
            GuiNotifier.notifyError((Throwable)ex);
        }
    }

    public static void runQuietly(int type, Map<String, Object> data) {
        try {
            UtilityModuleFactory.getModule(type).start(data);
        }
        catch (ModuleCreateException ex) {
            GuiNotifier.notifyError((Throwable)ex);
        }
    }

    private static class ModuleCache
    extends Cache2<Integer, UtilityModule> {
        private ModuleCache() {
        }

        protected UtilityModule load(Integer id) {
            switch (id) {
                case 0: {
                    log.info((Object)"Create document copy module");
                    return new DocCopy();
                }
                case 1: {
                    log.info((Object)"Create payment state module");
                    return new PayStatus();
                }
                case 2: {
                    log.info((Object)"Create console module");
                    return new Console();
                }
                case 3: {
                    log.info((Object)"Create search service module");
                    return new SearchService();
                }
                case 4: {
                    log.info((Object)"Create calib validor module");
                    return new Calibrator();
                }
            }
            return null;
        }
    }
}

