/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.utility;

import fxterm.app.id.LoggerId;
import fxterm.core.cache.CacheManager;
import fxterm.core.state.StateFacade;
import fxterm.core.state.TerminalState;
import fxterm.module.Intent;
import fxterm.module.ModuleStore;
import fxterm.module.input.BaseModule;
import fxterm.module.utility.MapAdapter;
import fxterm.module.utility.UtilityModule;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import plfx.screen.ScreenInit;
import plfx.shell2.dialog.Dialog;
import ru.softlogic.input.model.ModelEnvironment;
import ru.softlogic.input.model.form.Form;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.parser.ParseException;
import ru.softlogic.parser.uni.Parser;
import ru.softlogic.system.util.PathUtils;

public abstract class BaseUtilityModule
extends BaseModule
implements UtilityModule {
    private int timeout;
    private Logger log;
    private ScreenDescription sd;
    private final Map<String, Form> cache;

    public BaseUtilityModule() {
        this(LoggerId.UTILITY, 120);
    }

    public BaseUtilityModule(Logger log, int timeout) {
        super(log);
        this.timeout = timeout;
        this.log = log;
        this.cache = Collections.synchronizedMap(new HashMap());
        CacheManager.add(new MapAdapter(this.cache));
    }

    @Override
    public int getType() {
        return 13;
    }

    @Override
    public int getInactivityTimeout() {
        return this.timeout;
    }

    @Override
    public void cancel(Intent intent) {
        this.exit();
    }

    @Override
    public final void start(Map<String, Object> data) {
        ModuleStore.setModule(this);
        this.log.info((Object)"\n");
        this.log.info((Object)"-----------------------------------------------------------");
        if (this.isPaperRequire()) {
            this.log.info((Object)"Paper require, check terminal state");
            TerminalState ts = StateFacade.getState();
            this.log.info((Object)("State is: " + ts));
            if (ts.getErrorCode() == 5 || (ts.getWarningMask() & 1) != 0) {
                this.log.error((Object)"Printer is not work, show error");
                Dialog.show((String)"module/utility/paper");
                return;
            }
        }
        this._start(data);
    }

    protected ScreenDescription readUtilityForm(String name, Locale locale) throws ParseException {
        Form form = this.cache.get(name);
        if (form != null) {
            return (ScreenDescription)form.getScreenSequence().getScreens().get(0);
        }
        Form f = Parser.getForm((File)PathUtils.getFilePath((String)("/res/module/utility/" + name + ".xml")), (short)0, (File)PathUtils.getFilePath((String)"/res/module/input/ds/0/"));
        if (f.getScreenSequence().getScreens().size() != 1) {
            throw new ParseException("Wrong number of screens");
        }
        this.sd = (ScreenDescription)f.getScreenSequence().getScreens().get(0);
        this.cache.put(name, f);
        return this.sd;
    }

    protected boolean isPaperRequire() {
        return false;
    }

    protected ScreenInit createScreenInit(Map<String, Object> data) {
        return new ScreenInit(new ModelEnvironment(data == null ? new HashMap() : data, "CUR", 1.0, null));
    }

    protected abstract void _start(Map<String, Object> var1);
}

