/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.stage.processing.keeper;

import fxterm.app.FxEnv;
import fxterm.core.task.Task;
import fxterm.core.timer.Timer;
import fxterm.module.Environment;
import fxterm.module.PackUtility;
import fxterm.module.stage.processing.BaseObsoleteProcessingModule;
import fxterm.session.Session;
import java.util.Locale;
import plfx.shell2.dialog.Dialog;
import ru.softlogic.operation.Operation;
import ru.softlogic.reference.service.ProcessingType;
import ru.softlogic.srv.api.operation.ProcessingResult;
import ru.softlogic.srv.api.operation.ProcessingResultType;
import ru.softlogic.srv.connector.ConnectorException;

public class KeeperProcessingModule
extends BaseObsoleteProcessingModule {
    private final int attempts = 5;
    private final int timeout = 30;

    @Override
    protected void processingBegin(Environment environment, Operation operation) {
        if (this.isOnlineProcessing(environment.getPack())) {
            this.log.info((Object)"Run online payment processing");
            new ProcessTask(environment, operation, Session.getLocale()).process();
        } else {
            this.log.info((Object)("Run offline processing: " + operation.getSumResult()));
            try {
                this.processingFinished(FxEnv.getConnector().process(operation), operation);
            }
            catch (ConnectorException ex) {
                this.log.error((Object)"Error on processing payment", (Throwable)ex);
                this.processingFinished(null, operation);
            }
        }
    }

    private void makeFullPayout(Environment environment) {
        PackUtility.cancelPack(environment.getPack());
        Session.getPaymentEndingState().setCancel(true);
        environment.getModules().getBeforePayoutModule().startPayout(environment);
    }

    private class ProcessTask
    extends Task {
        private final Environment environment;
        private final Operation operation;
        private final Locale locale;

        public ProcessTask(Environment environment, Operation operation, Locale locale) {
            this.environment = environment;
            this.operation = operation;
            this.locale = locale;
        }

        protected Object execute() throws Exception {
            long time = Timer.currentSec();
            if (this.operation.getService().getProcessingType() == ProcessingType.Online) {
                for (int i = 0; i < 5; ++i) {
                    try {
                        KeeperProcessingModule.this.log.info((Object)("Pre-process request. Attempt " + (i + 1)));
                        FxEnv.getConnector().ping();
                        KeeperProcessingModule.this.log.info((Object)"Ping successed");
                        break;
                    }
                    catch (ConnectorException ex) {
                        if (i == 4 || Timer.currentSec() - time > 30L) {
                            return ex;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                        }
                        continue;
                    }
                }
            }
            KeeperProcessingModule.this.log.info((Object)"Process request");
            return FxEnv.getConnector().process(this.operation);
        }

        protected void onResult(Object object) {
            KeeperProcessingModule.this.log.info((Object)("Processing result: " + object));
            if (object instanceof ProcessingResult) {
                ProcessingResult pr = (ProcessingResult)object;
                if (pr.getType() == ProcessingResultType.Ok) {
                    KeeperProcessingModule.this.processingFinished((ProcessingResult)object, this.operation);
                } else {
                    KeeperProcessingModule.this.log.info((Object)"Show error");
                    Dialog.show((String)"module/processing/error_online_exit", actionId -> {
                        KeeperProcessingModule.this.log.info((Object)"Make full payout");
                        KeeperProcessingModule.this.makeFullPayout(this.environment);
                    });
                }
            } else {
                KeeperProcessingModule.this.log.info((Object)"Ask about retry");
                Dialog.show((String)"module/processing/error_ping_online", actionId -> {
                    KeeperProcessingModule.this.log.info((Object)("User make choise: " + actionId));
                    if (actionId == 0) {
                        KeeperProcessingModule.this.log.info((Object)"Retry run online payment processing");
                        new ProcessTask(this.environment, this.operation, Session.getLocale()).process();
                    } else {
                        KeeperProcessingModule.this.log.info((Object)"Make full payout");
                        KeeperProcessingModule.this.makeFullPayout(this.environment);
                    }
                });
            }
        }

        @Override
        protected String getWaitId() {
            return "input.verify.data";
        }

        @Override
        protected void onError(Exception ex) {
            KeeperProcessingModule.this.log.info((Object)"Error on online processing", (Throwable)ex);
            KeeperProcessingModule.this.processingFinished(null, this.operation);
        }
    }
}

