/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.stage.processing;

import fxterm.app.FxEnv;
import fxterm.app.FxEnvInit;
import fxterm.core.task.Task;
import fxterm.module.Environment;
import fxterm.module.Pack;
import fxterm.module.PackUtility;
import fxterm.module.Payment;
import fxterm.module.stage.processing.BaseObsoleteProcessingModule;
import java.util.HashMap;
import plfx.shell2.dialog.Dialog;
import ru.softlogic.hdw.dev.crd.CardReader;
import ru.softlogic.hdw.dev.crd.CardReaderException;
import ru.softlogic.hdw.dev.crd.Description;
import ru.softlogic.hdwbridge.sc.CardOperation;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.operation.Operation;

public class SmartCardProcessingModule
extends BaseObsoleteProcessingModule {
    private CardReader crd;
    private Operation operation;

    @Override
    protected void processingBegin(Environment environment, Operation operation) {
        this.log.info((Object)"Run smartcard payment processing");
        this.crd = FxEnv.getCardReader();
        this.operation = operation;
        Pack pack = environment.getPack();
        if (pack.getPaybackType() == 0 && this.crd != null) {
            new ProcessTask(environment).process();
        } else {
            this.processingFinished((Data)null, operation);
        }
    }

    protected void processingFinished(Data data, Operation operation) {
        if (data != null && data.getElements() != null) {
            for (InputElement ie : data.getElements()) {
                Payment payment = this.environment.getPack().getPayments().get(0);
                payment.getData().put(ie.getKey(), ie);
            }
        }
        this.cardReaderRelease();
        FxEnvInit.setSmartCardProcessor(null);
        this._processingFinished(operation);
    }

    private void showErrorDialog() {
        Dialog.show((String)"module/processing/error_hardware_card", actionId -> {
            this.log.info((Object)("User make choise: " + actionId));
            if (actionId == 0) {
                this.log.info((Object)"Retry run payment processing");
                this.makeFullPayout(this.environment);
            } else {
                this.log.info((Object)"Make full payout");
                this.processingBegin(this.environment, this.operation);
            }
        });
    }

    private void makeFullPayout(Environment environment) {
        PackUtility.cancelPack(environment.getPack());
        environment.getModules().getBeforePayoutModule().startPayout(environment);
        this.cardReaderRelease();
    }

    private void cardReaderRelease() {
        try {
            if (this.crd != null) {
                this.crd.ejectCard();
                if (this.crd.isEnabled()) {
                    this.crd.disableDevice();
                }
                this.crd.release();
            }
        }
        catch (CardReaderException ex) {
            this.log.error((Object)("Card was not eject. Reason: " + ex.getMessage()));
        }
    }

    private class ProcessTask
    extends Task {
        private final Environment environment;

        public ProcessTask(Environment environment) {
            this.environment = environment;
        }

        protected Object execute() {
            HashMap params = new HashMap();
            try {
                SmartCardProcessingModule.this.log.info((Object)"Process request");
                int sum = SmartCardProcessingModule.this.operation.getSumResult().getOut().getValue();
                return FxEnv.getSmartCardProcessor().process(SmartCardProcessingModule.this.crd, new CardOperation(sum, params));
            }
            catch (Exception ex) {
                return ex;
            }
        }

        protected void onResult(Object object) {
            SmartCardProcessingModule.this.log.info((Object)("Processing result: " + object));
            if (object instanceof Data) {
                SmartCardProcessingModule.this.processingFinished((Data)object, SmartCardProcessingModule.this.operation);
            } else {
                SmartCardProcessingModule.this.showErrorDialog();
            }
        }

        @Override
        protected String getWaitId() {
            Description description = SmartCardProcessingModule.this.crd.getDescription();
            if (description.isFeatureSupport(16)) {
                return "wait.card.contactless";
            }
            return "wait.card";
        }

        @Override
        protected void onError(Exception ex) {
            SmartCardProcessingModule.this.log.info((Object)"Error on online processing", (Throwable)ex);
            SmartCardProcessingModule.this.processingFinished((Data)null, SmartCardProcessingModule.this.operation);
        }
    }
}

