/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.stage.processing;

import fxterm.app.FxEnv;
import fxterm.app.id.LoggerId;
import fxterm.core.Sequence;
import fxterm.core.hdw.bvr.oper.NewKeeper2;
import fxterm.core.hdw.prt.PrnUtils;
import fxterm.module.Environment;
import fxterm.module.ModuleHelper;
import fxterm.module.Pack;
import fxterm.module.PackUtility;
import fxterm.module.Payment;
import fxterm.module.stage.processing.BaseProcessingModule;
import fxterm.session.Session;
import java.util.Date;
import org.apache.log4j.Logger;
import ru.softlogic.cash.Sum;
import ru.softlogic.hdw.dev.barcode.BarcodeListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.operation.GroupOperation;
import ru.softlogic.operation.Operation;
import ru.softlogic.srv.DataItem;
import ru.softlogic.srv.api.operation.ProcessingResult;
import ru.softlogic.srv.api.operation.ProcessingResultType;

public abstract class BaseObsoleteProcessingModule
extends BaseProcessingModule {
    protected final Logger log = LoggerId.PAY;
    protected Environment environment;

    @Override
    protected void _process(Environment environment) {
        this.environment = environment;
        Pack pack = environment.getPack();
        if (pack.getPayments().size() == 1 || pack.getSumResult().getOut().isEmpty()) {
            this.log.info((Object)"Process single pack operation");
            Payment payment = pack.getPayments().get(0);
            payment.setId(Sequence.getOperationId());
            payment.setDoc(Sequence.getDocNum());
            payment.setDate(new Date());
            Session.getPayEnv().save();
            PackUtility.printPack("Processing pack", pack);
            this.processingBegin(environment, PackUtility.convert(pack));
        } else {
            this.log.info((Object)"Multi operation pack ");
            Date date = new Date();
            pack.getPayments().stream().forEach(p -> p.setDate(date));
            Session.getPayEnv().save();
            PackUtility.printPack("Processing pack", pack);
            this.packProcessingBegin(environment);
        }
    }

    protected abstract void processingBegin(Environment var1, Operation var2);

    protected void packProcessingBegin(Environment environment) {
        GroupOperation go = PackUtility.convertGroup(environment.getPack());
        this.log.info((Object)"Send group");
        FxEnv.getConnector().sendGroupOperation(go);
        this.log.info((Object)"Done");
        this._processingFinished((Operation)go);
    }

    /*
     * Unable to fully structure code
     */
    protected void processingFinished(ProcessingResult result, Operation operation) {
        pack = this.environment.getPack();
        if (result != null && result.getType() == ProcessingResultType.Ok) {
            if (result.getDataItems() != null) {
                for (DataItem di : result.getDataItems()) {
                    key = di.getKey();
                    value = di.getValue();
                    operation.getForm().put(key, value);
                    operation.getViews().put(key, value);
                    if (operation.getTitles().get(key) == null) {
                        operation.getTitles().put(key, key);
                    }
                    operation.getInputElements().put(key, new InputElement(key, (String)operation.getTitles().get(key), value, value, 0));
                }
            }
        } else {
            this.log.info((Object)"Cancel operation");
            opers = PackUtility.cancelOnlinePack(pack);
            operation = (Operation)opers.getKey();
            this.log.info((Object)("Canceled operation: " + operation));
            this.log.info((Object)"Save it to queue");
            try {
                FxEnv.getConnector().process(operation);
                if (opers.getValue() == null) ** GOTO lbl34
                this.log.info((Object)("Change operation: " + opers.getValue()));
                FxEnv.getPrintSpooler().print(PrnUtils.createPrinterJob(operation, pack.isPrintByOne()).get(0));
                operation = (Operation)opers.getValue();
            }
            catch (Exception ex) {
                this.log.error((Object)"Error on save payment", (Throwable)ex);
            }
        }
lbl34:
        // 4 sources

        this._processingFinished(operation);
    }

    protected void _processingFinished(Operation operation) {
        this.environment.setPrintOperation(ModuleHelper.copyOperation(operation));
        NewKeeper2 keeper = Session.getPayEnv().getKeeper();
        Session.getPayEnv().setLastKeeper(new NewKeeper2(keeper));
        this.environment.setCurrentKeeper(new NewKeeper2(keeper));
        Pack pack = this.environment.getPack();
        pack.setSumResult(operation.getSumResult());
        Sum ch = pack.getSumResult().getChange();
        pack.setIssuedCard(keeper.getIssuedCard());
        keeper.reset();
        if (!ch.isEmpty() && pack.getPaybackType() == 3) {
            if (pack.getSumResult().getDonate() != null && !pack.getSumResult().getDonate().isEmpty()) {
                keeper.setSumOut(ch.sub(pack.getSumResult().getDonate()));
            } else {
                keeper.setSumOut(ch);
            }
            pack.setChangeDate(pack.getDate());
            Session.getPayEnv().setPack(pack);
        }
        Session.setLastPaymentDate(operation.getDate());
        this.environment.getModules().getAfterPayoutModule().startPayout(this.environment);
    }

    @Override
    public final BarcodeListener getBarcodeScannerListener() {
        return null;
    }
}

