/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.stage.processing;

import fxterm.app.FxEnv;
import fxterm.module.Environment;
import fxterm.module.Intent;
import fxterm.module.Pack;
import fxterm.module.card.CardModuleHandler;
import fxterm.module.card.ReverseTask;
import fxterm.module.input.card.BaseCardInputModule;
import fxterm.module.stage.processing.ObsoleteProcessingModule;
import fxterm.session.Session;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javafx.application.Platform;
import plfx.GuiNotifier;
import plfx.shell2.dialog.Dialog;
import plfx.shell2.dialog.DialogListener;
import ru.softlogic.cards.v2.connector.model.CardData;
import ru.softlogic.cards.v2.connector.model.Currency;
import ru.softlogic.cards.v2.connector.model.FinanceOperation;
import ru.softlogic.cards.v2.connector.model.OperationDepositResult;
import ru.softlogic.cards.v2.connector.model.OperationResult;
import ru.softlogic.cards.v2.model.BankModuleError;
import ru.softlogic.cards.v2.model.CardModuleError;
import ru.softlogic.cards.v2.module.BankModuleResultListener;
import ru.softlogic.cards.v2.module.CardInfo;
import ru.softlogic.cards.v2.module.CardModuleResultListener;
import ru.softlogic.cards.v2.module.CashRequireListener;
import ru.softlogic.cash.Sum;
import ru.softlogic.input.model.InputElement;

public class BankCardProcessingModule
extends ObsoleteProcessingModule {
    private LocalGuiListener guiListener;

    @Override
    protected void _process(Environment env) {
        this.guiListener = new LocalGuiListener();
        Pack pack = Session.getPayEnv().getPack();
        this.environment = env;
        try {
            CardModuleHandler cardModuleHandler = FxEnv.getCardModuleHandler();
            cardModuleHandler.setUserInterfaceEventListener(this.guiListener);
            CashRequireListener cashRequireListener = cardModuleHandler.getCashRequireListener();
            CashRequireListener bankCashRequireListener = cardModuleHandler.getBankCashRequireListener();
            if (!Session.getPaymentEndingState().isCancel()) {
                int out = pack.getSumResult().getOut().getValue();
                int comm = pack.getSumResult().getCommission().getValue();
                this.log.info((Object)"Bank Card Processing");
                if (cashRequireListener != null) {
                    cardModuleHandler.setOperationDepositResultListener(new DepositOperationListener());
                    FinanceOperation fo = new FinanceOperation(new HashMap(), (long)out, (long)comm, Currency.getInstance((String)Session.getInCurrency()));
                    this.log.info((Object)"Bank cash to card");
                    cashRequireListener.onResult(fo);
                    cardModuleHandler.setCashRequireListener(null);
                } else if (bankCashRequireListener != null) {
                    cardModuleHandler.setBankModuleResultListener(new BankDepositOperationListener());
                    FinanceOperation fo = new FinanceOperation(new HashMap(), (long)out, (long)comm, Currency.getInstance((String)Session.getInCurrency()));
                    bankCashRequireListener.onResult(fo);
                    cardModuleHandler.setBankCashRequireListener(null);
                } else {
                    this.log.error((Object)"No result listeners. Cancel pack.");
                    this.guiListener.setCloselOperation(() -> this.processingFinished(null, null));
                    cardModuleHandler.closeOperation();
                }
            } else {
                this.log.info((Object)"No need to process payment in bank");
                this.guiListener.setCloselOperation(() -> super._process(this.environment));
                if (cashRequireListener != null) {
                    cashRequireListener.onCancel();
                }
                if (bankCashRequireListener != null) {
                    bankCashRequireListener.onCancel();
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            GuiNotifier.notifyError((Throwable)e);
            this.cancel(null);
        }
    }

    @Override
    public void cancel(Intent intent) {
        Session.getPaymentEndingState().setCancel(true);
        this.guiListener.setClosedListener(() -> this.processingFinished(null, null));
        try {
            if (FxEnv.getCardModuleHandler().getCurrentSession() != null) {
                FxEnv.getCardModuleHandler().closeOperation();
            }
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
        }
    }

    private void fillCardInfo(OperationResult r, CardInfo ci) {
        Map<String, Object> data = Session.getPayEnv().getPack().getPayments().get(0).getData();
        if (r.getAuthIdentResponse() != null) {
            data.put("auth", new InputElement("auth", CardModuleHandler.getMessage("title_auth"), r.getAuthIdentResponse()));
        }
        if (r.getRrn() != null) {
            data.put("rrn", new InputElement("rrn", CardModuleHandler.getMessage("title_rrn"), r.getRrn()));
        }
        InputElement curr = new InputElement("curr", CardModuleHandler.getMessage("title_currency"), r.getCurrency().getAlphaCode());
        InputElement merchant = new InputElement("merchant", CardModuleHandler.getMessage("title_merchant"), r.getMerchant());
        InputElement stan = new InputElement("stan", CardModuleHandler.getMessage("title_stan"), r.getStan());
        InputElement terminal = new InputElement("terminal", CardModuleHandler.getMessage("title_terminal"), r.getTerminal());
        data.put("curr", curr);
        data.put("merchant", merchant);
        data.put("stan", stan);
        data.put("terminal", terminal);
        data.put("comm", Optional.ofNullable(r).filter(dr -> dr instanceof OperationDepositResult).map(dr -> (OperationDepositResult)dr).map(dr -> dr.getAcquireFee()).map(fee -> new Sum((int)fee.getValue(), fee.getCurrency().getAlphaCode())).orElse(new Sum(0, r.getCurrency().getAlphaCode())));
        if (ci.getPan() != null) {
            InputElement id = (InputElement)data.get("id1");
            String title = CardModuleHandler.getMessage("title_pan");
            if (id != null && !title.equals(id.getKeyTitle())) {
                data.put("pan", new InputElement("pan", title, ci.getPan()));
            } else {
                data.put("id1", new InputElement("id1", title, ci.getPan()));
                if (ci.getAccountInfo() != null && ci.getAccountInfo().getNumber() != null) {
                    data.put("account", new InputElement("account", CardModuleHandler.getMessage("title_account"), ci.getAccountInfo().getNumber()));
                }
            }
        }
    }

    private class LocalGuiListener
    extends BaseCardInputModule {
        private Runnable closedListener;
        private Runnable closelOperation;

        private LocalGuiListener() {
        }

        public void setClosedListener(Runnable closedListener) {
            this.closedListener = closedListener;
        }

        public Runnable getCloselOperation() {
            return this.closelOperation;
        }

        public void setCloselOperation(Runnable closelOperation) {
            this.closelOperation = closelOperation;
        }

        @Override
        protected void _startOperation() {
        }

        @Override
        protected synchronized void onClosed() {
            if (this.closedListener != null) {
                this.closedListener.run();
                this.closedListener = null;
            }
            if (this.closelOperation != null) {
                this.closelOperation.run();
            }
        }
    }

    private class BankDepositOperationListener
    implements BankModuleResultListener<OperationDepositResult> {
        private BankDepositOperationListener() {
        }

        public void onError(BankModuleError bme, String message) {
            Platform.runLater(() -> {
                BankCardProcessingModule.this.log.info((Object)("Deposit operation error: " + bme + ", " + message));
                BankCardProcessingModule.this.guiListener.hideWait();
                GuiNotifier.notifyProblem((String)("CardPaymentError(initiator=" + bme + ", " + message + ")"));
                DialogListener listener = i -> {
                    BankCardProcessingModule.this.guiListener.setClosedListener(() -> BankCardProcessingModule.this.processingFinished(null, null));
                    FxEnv.getCardModuleHandler().closeSession(false);
                    new Thread(new ReverseTask()).start();
                };
                if (bme == BankModuleError.ERROR_USER_CANCEL) {
                    BankCardProcessingModule.this.log.info((Object)"Operation canceled by user, show dialog");
                    Dialog.show((String)"module/card/error_cancel_user", (DialogListener)listener);
                } else {
                    BankCardProcessingModule.this.log.info((Object)("Show dialog with message = " + message));
                    if (message != null && !message.trim().isEmpty()) {
                        Session.setItem("card_error_msg", CardModuleHandler.getMessage(message));
                    } else {
                        Session.setItem("card_error_msg", null);
                    }
                    Dialog.show((String)"module/card/error", (DialogListener)listener);
                }
            });
        }

        public void onResult(OperationDepositResult t, CardInfo ci) {
            BankCardProcessingModule.this.fillCardInfo((OperationResult)t, ci);
            BankCardProcessingModule.this.guiListener.setClosedListener(() -> BankCardProcessingModule.super._process(BankCardProcessingModule.this.environment));
            FxEnv.getCardModuleHandler().closeSession(true);
        }
    }

    private class DepositOperationListener
    implements CardModuleResultListener<OperationDepositResult> {
        private DepositOperationListener() {
        }

        public void onError(CardModuleError cme, String message) {
            Platform.runLater(() -> {
                BankCardProcessingModule.this.log.info((Object)("Deposit operation error: " + cme + ", " + message));
                BankCardProcessingModule.this.guiListener.hideWait();
                GuiNotifier.notifyProblem((String)("CardPaymentError(initiator=" + cme + ", " + message + ")"));
                DialogListener listener = i -> {
                    BankCardProcessingModule.this.guiListener.setClosedListener(() -> BankCardProcessingModule.this.processingFinished(null, null));
                    FxEnv.getCardModuleHandler().closeSession(false);
                    new Thread(new ReverseTask()).start();
                };
                if (cme == CardModuleError.ERROR_USER_CANCEL) {
                    BankCardProcessingModule.this.log.info((Object)"Operation canceled by user, show dialog");
                    Dialog.show((String)"module/card/error_cancel_user", (DialogListener)listener);
                } else {
                    BankCardProcessingModule.this.log.info((Object)("Show dialog with message = " + message));
                    if (message != null && !message.trim().isEmpty()) {
                        Session.setItem("card_error_msg", CardModuleHandler.getMessage(message));
                    } else {
                        Session.setItem("card_error_msg", null);
                    }
                    Dialog.show((String)"module/card/error", (DialogListener)listener);
                }
            });
        }

        public void onResult(OperationDepositResult t, CardInfo ci) {
            BankCardProcessingModule.this.log.info((Object)("DepositOperation result: " + t + ", " + ci));
            BankCardProcessingModule.this.fillCardInfo((OperationResult)t, ci);
            BankCardProcessingModule.this.guiListener.setClosedListener(() -> BankCardProcessingModule.super._process(BankCardProcessingModule.this.environment));
            BankCardProcessingModule.this.log.info((Object)"Try cancel session");
            FxEnv.getCardModuleHandler().closeSession(true);
        }

        public void onCardData(CardData cd) {
        }
    }
}

