/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.stage.processing;

import fxterm.app.FxEnv;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.advanced.AsyncTask;
import ru.softlogic.input.model.advanced.actions.request.ConnectorException;
import ru.softlogic.input.model.advanced.actions.request.RequestData;
import ru.softlogic.input.model.advanced.actions.request.Response;

public class AzersuRequest
implements AsyncTask {
    private final ReqestTaskListner listener;
    private final RequestData requestData;
    private final int attempts = 5;
    private final int timeout = 15;

    public AzersuRequest(RequestData requestData, ReqestTaskListner listener) {
        this.requestData = requestData;
        this.listener = listener;
    }

    public Object execute() {
        ConnectorException lastEx = null;
        try {
            for (int i = 0; i < 5; ++i) {
                try {
                    return FxEnv.getConnector().request(this.requestData);
                }
                catch (ConnectorException ex) {
                    lastEx = ex;
                    if (i >= 4) continue;
                    Thread.sleep(15000L);
                    continue;
                }
            }
        }
        catch (InterruptedException ex1) {
            Thread.currentThread().interrupt();
        }
        return lastEx;
    }

    public void onResult(Object result) {
        if (result instanceof Exception) {
            this.listener.onException((Exception)result);
        } else {
            Response resp = (Response)result;
            if (resp.getServerError() == 0 && resp.getServiceError() == 0 && resp.getData() != null) {
                List data = ((Data)resp.getData()).getElements();
                HashMap<String, InputElement> elements = new HashMap<String, InputElement>();
                if (data != null) {
                    data.stream().forEach(el -> elements.put(el.getKey(), (InputElement)el));
                }
                this.listener.onResult(elements);
            } else {
                this.listener.onError(resp.getServerError(), resp.getServiceError());
            }
        }
    }

    public static interface ReqestTaskListner {
        public void onException(Exception var1);

        public void onError(int var1, int var2);

        public void onResult(Map<String, InputElement> var1);
    }
}

