/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.stage.processing;

import fxterm.app.FxEnv;
import fxterm.core.hdw.bvr.oper.NewKeeper2;
import fxterm.core.task.Task;
import fxterm.module.Environment;
import fxterm.module.ModuleHelper;
import fxterm.module.Pack;
import fxterm.module.PackUtility;
import fxterm.module.Payment;
import fxterm.module.stage.processing.ObsoleteProcessingModule;
import fxterm.session.Session;
import fxterm.utils.FinUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import plfx.GuiNotifier;
import plfx.shell2.dialog.Dialog;
import ru.softlogic.cash.Sum;
import ru.softlogic.hdw.dev.crd.CardReader;
import ru.softlogic.hdw.dev.crd.CardReaderException;
import ru.softlogic.hdwbridge.HardwareException;
import ru.softlogic.hdwbridge.sc.CardOperation;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.advanced.actions.request.RequestData;
import ru.softlogic.operation.Operation;
import ru.softlogic.reference.service.Service;
import ru.softlogic.service.comission.SumResult;
import ru.softlogic.srv.DataItem;
import ru.softlogic.srv.api.operation.ProcessingResult;
import ru.softlogic.srv.api.operation.ProcessingResultType;
import ru.softlogic.srv.connector.ConnectorException;

public class AzersuCardProcessingModule
extends ObsoleteProcessingModule {
    protected final CardReader crd = FxEnv.getCardReader();
    protected Environment env;
    private boolean printOnlineOp;
    private Operation printOperation;

    @Override
    protected void processingBegin(Environment environment, Operation operation) {
        this.env = environment;
        Pack pack = environment.getPack();
        this.printOnlineOp = false;
        this.printOperation = null;
        try {
            Sum out;
            SumResult sumResult = operation.getSumResult();
            this.log.info((Object)"Run smartcard payment processing");
            this.log.info((Object)("sumResult: " + sumResult));
            this.log.info((Object)("!Session.getPaymentEndingState().isCancel() : " + !Session.getPaymentEndingState().isCancel()));
            this.log.info((Object)("pack.getPaymentType() : " + pack.getPaymentType()));
            if (sumResult != null && !Session.getPaymentEndingState().isCancel() && pack.getPaymentType() == 0 && (out = sumResult.getOut()) != null && !out.isEmpty()) {
                this.log.info((Object)"Run smartcard payment processing");
                ProcessTask processTask = this.createProcessTask(operation);
                processTask.process();
                return;
            }
            this.log.info((Object)"Run no smartcard payment processing");
            super.processingBegin(this.env, operation);
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            GuiNotifier.notifyProblem((String)("Error in smartcard payment processing: " + e.getMessage()));
            this.processingFinished(null, operation);
        }
    }

    protected ProcessTask createProcessTask(Operation operation) {
        return new ProcessTask(operation);
    }

    protected void realProcess(Environment env) {
        Pack pack = env.getPack();
        Sum voidSum = FinUtils.createVoidSum();
        SumResult srSrc = pack.getSumResult();
        SumResult srDest = new SumResult(srSrc.getCash(), srSrc.getCashLess(), voidSum, voidSum, voidSum, voidSum, srSrc.getProviderFee());
        if (pack.getPayments() != null) {
            for (Payment p : pack.getPayments()) {
                p.setSumOut(voidSum);
            }
        }
        pack.setSumResult(srDest);
        pack.setZeroAmount(true);
        PackUtility.printPack("Processing pack", pack);
        super.processingBegin(env, PackUtility.convert(pack));
    }

    @Override
    protected void _processingFinished(Operation operation) {
        if (this.printOnlineOp) {
            this.environment.setPrintOperation(this.printOperation);
        } else {
            this.environment.setPrintOperation(ModuleHelper.copyOperation(operation));
        }
        NewKeeper2 keeper = Session.getPayEnv().getKeeper();
        Session.getPayEnv().setLastKeeper(new NewKeeper2(keeper));
        this.environment.setCurrentKeeper(new NewKeeper2(keeper));
        Pack pack = this.environment.getPack();
        pack.setSumResult(operation.getSumResult());
        Sum ch = pack.getSumResult().getChange();
        pack.setIssuedCard(keeper.getIssuedCard());
        keeper.reset();
        if (!ch.isEmpty() && pack.getPaybackType() == 3) {
            if (pack.getSumResult().getDonate() != null && !pack.getSumResult().getDonate().isEmpty()) {
                keeper.setSumOut(ch.sub(pack.getSumResult().getDonate()));
            } else {
                keeper.setSumOut(ch);
            }
            pack.setChangeDate(pack.getDate());
            Session.getPayEnv().setPack(pack);
        }
        Session.setLastPaymentDate(operation.getDate());
        this.environment.getModules().getAfterPayoutModule().startPayout(this.environment);
    }

    protected class ProcessTask
    extends Task<Integer> {
        private static final String ATTR_RECEIPT = "receipt";
        private static final String ATTR_DATA_TO_CARD = "data-to-card";
        private static final String ATTR_CARD_UPDATED = "card-updated";
        protected static final int STATUS_OK = 0;
        protected static final int ERROR_PAY_REQUEST = 1;
        protected static final int ERROR_PAY_DATA = 2;
        protected static final int ERROR_WRITE_TO_CARD = 3;
        private final Operation operation;

        protected ProcessTask(Operation operation) {
            this.operation = operation;
        }

        @Override
        public Integer execute() throws Exception {
            try {
                InputElement ieDataToCard;
                InputElement ieReceipt;
                Sum amount;
                Map<String, Object> data;
                block10: {
                    AzersuCardProcessingModule.this.log.debug((Object)"Get payment data");
                    Pack pack = AzersuCardProcessingModule.this.env.getPack();
                    data = pack.getPayments().get(0).getData();
                    AzersuCardProcessingModule.this.log.debug((Object)("data: " + data));
                    amount = this.operation.getSumResult().getIncome();
                    ieReceipt = null;
                    ieDataToCard = null;
                    try {
                        AzersuCardProcessingModule.this.log.info((Object)"Run online payment processing");
                        ProcessingResult pr = FxEnv.getConnector().process(this.operation);
                        AzersuCardProcessingModule.this.log.info((Object)("Processing result: " + pr));
                        if (pr.getType() == ProcessingResultType.Ok) {
                            if (pr.getDataItems() != null) {
                                for (DataItem di : pr.getDataItems()) {
                                    String key = di.getKey();
                                    String value = di.getValue();
                                    if (ieReceipt == null && ATTR_RECEIPT.equals(key)) {
                                        ieReceipt = new InputElement(ATTR_RECEIPT, ATTR_RECEIPT, di.getValue());
                                    }
                                    if (ieDataToCard == null && ATTR_DATA_TO_CARD.equals(key)) {
                                        ieDataToCard = new InputElement(ATTR_DATA_TO_CARD, ATTR_DATA_TO_CARD, di.getValue());
                                        continue;
                                    }
                                    data.put(key, new InputElement(key, key, di.getValue()));
                                    this.operation.getForm().put(key, value);
                                    this.operation.getViews().put(key, value);
                                    if (this.operation.getTitles().get(key) == null) {
                                        this.operation.getTitles().put(key, key);
                                    }
                                    this.operation.getInputElements().put(key, new InputElement(key, (String)this.operation.getTitles().get(key), value, value, 0));
                                }
                            }
                            break block10;
                        }
                        AzersuCardProcessingModule.this.log.info((Object)"Ask about action");
                        Dialog.show((String)"module/processing/error_online", actionId -> {
                            AzersuCardProcessingModule.this.log.info((Object)("User make choise: " + actionId));
                            Session.getPayEnv().getKeeper().setSumOut(FinUtils.createVoidSum());
                            if (actionId == 0) {
                                AzersuCardProcessingModule.this.log.info((Object)"Go to input module");
                                AzersuCardProcessingModule.this.environment.getModules().getInputModule().restore();
                            } else {
                                AzersuCardProcessingModule.this.log.info((Object)"Make full payout");
                                AzersuCardProcessingModule.this.makeFullPayout(AzersuCardProcessingModule.this.environment);
                            }
                        });
                        return 1;
                    }
                    catch (ConnectorException ex) {
                        AzersuCardProcessingModule.this.log.error((Object)ex, (Throwable)ex);
                        AzersuCardProcessingModule.this.processingFinished(null, this.operation);
                        return 1;
                    }
                }
                return this.postExecute(ieReceipt, ieDataToCard, amount, data);
            }
            catch (HardwareException ex) {
                return 3;
            }
        }

        protected Integer postExecute(InputElement ieRec, InputElement ieDTC, Sum amount, Map<String, Object> data) throws HardwareException {
            if (ieDTC == null || ieRec == null) {
                return 2;
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(ieDTC.getKey(), ieDTC.getValue());
            FxEnv.getSmartCardProcessor().process(AzersuCardProcessingModule.this.crd, new CardOperation(amount.getValue(), params));
            AzersuCardProcessingModule.this.printOperation = ModuleHelper.copyOperation(this.operation);
            AzersuCardProcessingModule.this.printOnlineOp = true;
            return 0;
        }

        @Override
        public void onResult(Integer errorCode) {
            AzersuCardProcessingModule.this.log.info((Object)("Processing result: " + errorCode));
            switch (errorCode) {
                case 1: {
                    break;
                }
                case 0: {
                    InputElement ie = new InputElement(ATTR_CARD_UPDATED, ATTR_CARD_UPDATED, "true");
                    Pack pack = AzersuCardProcessingModule.this.env.getPack();
                    Map<String, Object> data = pack.getPayments().get(0).getData();
                    data.put(ie.getKey(), ie);
                }
                case 2: 
                case 3: {
                    AzersuCardProcessingModule.this.realProcess(AzersuCardProcessingModule.this.env);
                }
            }
            this.cardReaderRelease();
        }

        @Override
        protected void onError(Exception ex) {
            AzersuCardProcessingModule.this.log.error((Object)ex);
            AzersuCardProcessingModule.this.processingFinished(null, this.operation);
        }

        @Override
        protected String getWaitId() {
            return "wait";
        }

        private RequestData createPaymentData(Service service, Date operationDate, Sum sum, Map<String, Object> data) {
            HashMap<String, String> params = new HashMap<String, String>();
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
            SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
            for (String param : new String[]{"id1", "id2", "transaction-id", "data-from-card"}) {
                Object object = data.get(param);
                if (!(object instanceof InputElement)) continue;
                InputElement ie = (InputElement)object;
                params.put(param, ie.getValue());
            }
            params.put("amount", "" + (float)sum.getValue() / 100.0f);
            params.put("payment-date", dateFormat.format(operationDate));
            params.put("payment-time", timeFormat.format(operationDate));
            AzersuCardProcessingModule.this.log.debug((Object)"Payment data: ");
            params.entrySet().stream().forEach(entry -> AzersuCardProcessingModule.this.log.debug((Object)((String)entry.getKey() + ": " + (String)entry.getValue())));
            RequestData requestData = new RequestData();
            requestData.setFunction("pay");
            requestData.setIdService(service.getId());
            requestData.setIdProvider(service.getProvider().getId());
            requestData.setParams(params);
            return requestData;
        }

        protected void cardReaderRelease() {
            try {
                AzersuCardProcessingModule.this.crd.ejectCard();
                if (AzersuCardProcessingModule.this.crd.isEnabled()) {
                    AzersuCardProcessingModule.this.crd.disableDevice();
                }
                AzersuCardProcessingModule.this.crd.release();
            }
            catch (CardReaderException ex) {
                AzersuCardProcessingModule.this.log.error((Object)("Card was not eject. Reason: " + ex.getMessage()));
            }
        }
    }
}

