/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.stage.print;

import fxterm.app.FxEnv;
import fxterm.core.hdw.bvr.oper.NewKeeper2;
import fxterm.core.hdw.prt.PrnUtils;
import fxterm.core.state.StateFacade;
import fxterm.module.Environment;
import fxterm.module.Pack;
import fxterm.module.PackUtility;
import fxterm.module.stage.print.BasePrintModule;
import fxterm.session.Session;
import java.util.List;
import plfx.shell2.dialog.Dialog;
import ru.softlogic.hdw.dev.printer.spooler.PrinterJob;
import ru.softlogic.operation.GroupOperation;
import ru.softlogic.operation.Operation;
import ru.softlogic.reference.service.Service;

public class ObsoletePrintModule
extends BasePrintModule {
    private Environment environment;

    @Override
    protected void _print(Environment environment) {
        this.environment = environment;
        Pack pack = environment.getPack();
        Service srv = Session.getService();
        boolean isCancel = Session.getPaymentEndingState().isCancel();
        if ((StateFacade.getState().getWarningMask() & 1) != 0) {
            this._print(false);
        } else if (srv.getPrintCheckDialog() == null || isCancel && pack.getPaybackType() == 3) {
            this._print(false);
        } else if (srv.getPrintCheckDialog().booleanValue() && pack.getPaybackType() != 1 && pack.getPaymentType() == 0) {
            Dialog.show((String)"module/print/confirm", actionId -> this._print(actionId == 0));
        } else {
            this._print(true);
        }
    }

    private void _print(boolean canPrint) {
        Pack p = this.environment.getPack();
        Operation operation = this.environment.getPrintOperation();
        if (operation instanceof GroupOperation) {
            this.log.info((Object)("Print group operation by one check: " + p.isPrintByOne()));
            operation = PrnUtils.processTotalComm((GroupOperation)operation);
            this.log.info((Object)"Print group operation");
        } else {
            this.log.info((Object)"Print single operation");
        }
        NewKeeper2 currentKeeper = this.environment.getCurrentKeeper();
        operation.setKeeper(PackUtility.getInKeeper(currentKeeper));
        PackUtility.setChange(operation, currentKeeper);
        this.log.info((Object)("print module    " + operation.getKeeper()));
        this.log.debug((Object)("    " + operation.getSumResult()));
        Session.setItem("operation", operation);
        if (canPrint) {
            List<PrinterJob> printerJobs = PrnUtils.createPrinterJob(operation, p.isPrintByOne());
            printerJobs.stream().forEach(job -> FxEnv.getPrintSpooler().print(job));
        } else {
            this.log.info((Object)"Skip printing");
        }
        this.environment.getModules().getEndingModule().end(this.environment);
    }
}

