/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.stage.payout;

import fxterm.app.id.LoggerId;
import fxterm.core.task.Task;
import fxterm.module.stage.payout.BasePayoutModule;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.currency.Sum;
import ru.softlogic.hdw.dev.cashdisp.PayoutException;
import ru.softlogic.payout.Payout;
import ru.softlogic.payout.PayoutFacade;
import ru.softlogic.payout.PayoutListener;
import ru.softlogic.payout.PayoutRequest;
import ru.softlogic.payout.PayoutResult;
import ru.softlogic.payout.SyncPayoutListener;
import ru.softlogic.reference.References;
import ru.softlogic.reference.hdw.DispenseProfile;

class PayoutTask
extends Task<PayoutResult> {
    private static final Logger log = LoggerId.PAY;
    private final Sum sum;
    private final BasePayoutModule module;

    public PayoutTask(Sum sum, BasePayoutModule module) {
        this.sum = sum;
        this.module = module;
    }

    @Override
    protected String getWaitId() {
        return "wait";
    }

    @Override
    protected PayoutResult execute() throws Exception {
        log.info((Object)"Start payout task");
        String dispAlgorithm = "simplex";
        DispenseProfile dispenseProfile = References.getDispenseProfile();
        if (dispenseProfile != null) {
            dispAlgorithm = dispenseProfile.getDispAlgorithm();
        }
        PayoutRequest request = new PayoutRequest.Builder(this.sum).setAlgoritm(dispAlgorithm).create();
        Payout precalc = PayoutFacade.precalc((PayoutRequest)request);
        try {
            log.info((Object)"Start payout task");
            log.info((Object)("precalc: " + precalc.getCounts()));
            SyncPayoutListener spl = new SyncPayoutListener();
            precalc.makePayout((PayoutListener)spl);
            return spl.waitFor();
        }
        catch (PayoutException ex) {
            throw ex;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw ex;
        }
    }

    @Override
    protected void onResult(PayoutResult pr) {
        this.module.onPayoutResult(pr);
    }

    @Override
    protected void onError(Exception ex) {
        this.module.onPayoutFailure();
    }
}

