/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.stage.payout;

import fxterm.core.hdw.bvr.oper.IssuedCashBackCard;
import fxterm.core.hdw.bvr.oper.NewKeeper2;
import fxterm.module.Environment;
import fxterm.module.ModuleStore;
import fxterm.module.Pack;
import fxterm.module.PackUtility;
import fxterm.module.stage.payout.BasePayoutModule;
import fxterm.session.Session;
import java.util.Map;
import ru.softlogic.cash.Sum;
import ru.softlogic.hardware.currency.set.DenominationSet;
import ru.softlogic.service.comission.SumResult;
import ru.softlogic.storage.cash.BoxId;
import ru.softlogic.system.util.PinCodeGenerator;

public class BeforePayoutModule
extends BasePayoutModule {
    @Override
    public void startPayout(Environment environment) {
        super.startPayout(environment);
        this.environment = environment;
        this.log.info((Object)"\n");
        this.log.info((Object)"***** SELECT PAYOUT MODULE(BEFORE PROCESSING) ************************************************");
        ModuleStore.setModule(this);
        Pack pack = environment.getPack();
        PackUtility.printPack("Pack", pack);
        SumResult sr = pack.getSumResult();
        if (!sr.getDonate().isEmpty()) {
            this.log.info((Object)("Add donate sum out " + sr.getDonate()));
            Session.getPayEnv().getKeeper().setSumOut(sr.getDonate());
        }
        if (this.isNeedChange(pack)) {
            if (BeforePayoutModule.isOnlineProcessing(pack)) {
                this.log.info((Object)"Need change, but online processing require. Skip change");
                this.skipPayout(environment.getPack().getSumResult().getChange());
            } else {
                this.processChange();
            }
        } else {
            this.log.info((Object)"Changeless payment, goto processing");
            this.toNextModule();
        }
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    protected void changeToPin() {
        this.log.info((Object)"Payout to cash back card");
        Pack pack = this.environment.getPack();
        pack.setPaybackType(1);
        Session.getPaymentEndingState().setChType(1);
        IssuedCashBackCard issuedCashBackCard = new IssuedCashBackCard(PinCodeGenerator.generate(), this.getChangeSize(pack));
        this.log.info((Object)("Generate issued CashBack Card: " + issuedCashBackCard));
        this.environment.getPack().setIssuedCard(issuedCashBackCard);
        Session.getPayEnv().getKeeper().setIssuedCard(issuedCashBackCard);
        this.toNextModule();
    }

    @Override
    protected void changeToTimeOut() {
        this.log.info((Object)"Payout to cash back card");
        Pack pack = this.environment.getPack();
        pack.setPaybackType(1);
        Session.getPaymentEndingState().setChType(-1);
        IssuedCashBackCard issuedCashBackCard = new IssuedCashBackCard(PinCodeGenerator.generate(), this.getChangeSize(pack));
        this.log.info((Object)("Generate issued CashBack Card: " + issuedCashBackCard));
        this.environment.getPack().setIssuedCard(issuedCashBackCard);
        Session.getPayEnv().getKeeper().setIssuedCard(issuedCashBackCard);
        this.toNextModule();
    }

    @Override
    protected void changeToMob() {
        this.log.info((Object)"Payout to mobile");
        Pack p = this.environment.getPack();
        p.setPaybackType(5);
        Session.getPaymentEndingState().setChType(5);
        Session.getPayEnv().getKeeper().setSumOut(p.getSumResult().getChange());
        this.toNextModule();
    }

    @Override
    protected void onCashChangeResult(Map<BoxId, DenominationSet> dispensed, IssuedCashBackCard cashBackCard) {
        this.log.info((Object)("Add change to original pack: " + dispensed));
        Pack pack = this.environment.getPack();
        NewKeeper2 keeper = Session.getPayEnv().getKeeper();
        for (Map.Entry<BoxId, DenominationSet> entry : dispensed.entrySet()) {
            this.log.info((Object)("    Add " + entry.getKey() + "->" + entry.getValue()));
            keeper.addDispensed(entry.getKey(), entry.getValue());
        }
        if (cashBackCard != null) {
            keeper.setIssuedCard(cashBackCard);
            pack.setIssuedCard(cashBackCard);
        }
        this.toNextModule();
    }

    @Override
    protected void toNextModule() {
        this.environment.getModules().getProcessingModule().process(this.environment);
    }

    private void skipPayout(Sum change) {
        Session.getPayEnv().getKeeper().setSumOut(change);
        this.toNextModule();
    }
}

