/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.stage.payout;

import fxterm.app.FxEnv;
import fxterm.app.SystemProp;
import fxterm.app.id.LoggerId;
import fxterm.core.BaseCommissionCalculator;
import fxterm.core.BaseScreenListener;
import fxterm.core.hdw.bvr.oper.IssuedCashBackCard;
import fxterm.core.menu.MenuUtils;
import fxterm.core.menu.MobileSearchVisitor;
import fxterm.module.Environment;
import fxterm.module.Intent;
import fxterm.module.Pack;
import fxterm.module.PackUtility;
import fxterm.module.PayEnv;
import fxterm.module.input.InitModuleHelper;
import fxterm.module.stage.payout.PayoutModule;
import fxterm.module.stage.payout.PayoutTask;
import fxterm.msg.Messages;
import fxterm.session.Session;
import fxterm.utils.CompatUtils;
import fxterm.utils.FinUtils;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import org.apache.log4j.Logger;
import plfx.screen.CommonScreen;
import plfx.screen.ScreenCreateException;
import plfx.screen.ScreenListener;
import plfx.screen.ScreenStore;
import plfx.shell2.dialog.Dialog;
import plfx.shell2.dialog.DialogListener;
import ru.softlogic.cash.Keeper;
import ru.softlogic.hardware.currency.Sum;
import ru.softlogic.hardware.currency.set.DenominationSet;
import ru.softlogic.hdw.dev.barcode.BarcodeListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.screen.ActionType;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.parser.ParseException;
import ru.softlogic.payout.Payout;
import ru.softlogic.payout.PayoutFacade;
import ru.softlogic.payout.PayoutRequest;
import ru.softlogic.payout.PayoutResult;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.service.ProcessingType;
import ru.softlogic.reference.service.Service;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.service.comission.SumResult;
import ru.softlogic.services.identify.IdentifyService;
import ru.softlogic.storage.cash.BoxId;

public abstract class BasePayoutModule
implements PayoutModule {
    protected Logger log = LoggerId.PAY;
    protected Environment environment;
    protected ScreenDescription smsDescr;

    @Override
    public void startPayout(Environment environment) {
        this.environment = environment;
    }

    @Override
    public int getInactivityTimeout() {
        return -1;
    }

    @Override
    public BarcodeListener getBarcodeScannerListener() {
        return null;
    }

    protected void processChange() {
        int ct = this.getChangeTypes(this.environment.getPack());
        String cts = String.format("%02x", ct &= 0xF);
        ru.softlogic.cash.Sum ch = this.getChangeSize(this.environment.getPack());
        Session.setItem("sum_change", ch);
        this.log.info((Object)("Process change, types: " + Messages.getChangeFlags(ct) + "(0x" + cts + ")"));
        int cnt = this.getChangeCounts(ct);
        this.log.debug((Object)("Change count: " + cnt));
        if (cnt < 2) {
            switch (ct) {
                case 2: {
                    this.changeToSrv();
                    break;
                }
                case 4: {
                    this.changeToCash();
                    break;
                }
                case 8: {
                    this.changeToMob();
                    break;
                }
                default: {
                    this.pinToSms();
                    break;
                }
            }
        } else if (cnt == 2 || cnt == 3) {
            String did = "module/payout/payout_" + cnt + "_" + cts;
            this.log.info((Object)("Open " + did));
            Dialog.show((String)did, (DialogListener)new ChangeTypeListener());
        } else {
            this.log.error((Object)"Too many change variants");
            this.pinToSms();
        }
    }

    protected int getChangeCounts(int mask) {
        long count = IntStream.range(0, 4).filter(i -> (mask & 1 << i) > 0).count();
        return (int)count;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int getChangeTypes(Pack pack) {
        ru.softlogic.cash.Sum ch;
        PayoutRequest create;
        Payout precalc;
        int ct = Session.getService().getChangeType();
        this.log.info((Object)("Change Types : " + Integer.toBinaryString(ct)));
        if ((ct & 4) != 0 && (precalc = PayoutFacade.precalc((PayoutRequest)(create = new PayoutRequest.Builder(new Sum((ch = this.getChangeSize(this.environment.getPack())).getValue(), ch.getCurrency())).setAlgoritm("greedy").create()))).getCounts().isEmpty()) {
            this.log.error((Object)"Dispenser is not found. Remove cash change.");
            ct &= 0xFFFFFFFB;
        }
        if ((ct & 8) == 0) return ct;
        this.log.info((Object)"Change to mobile is available");
        InputElement chnum = pack.getChangeNumber();
        this.log.info((Object)("Change number: " + (chnum != null ? chnum.getValue() : "-")));
        if (chnum != null) {
            Short idprov = IdentifyService.getOperator((String)chnum.getValue());
            this.log.info((Object)("Provider id: " + idprov));
            MobileSearchVisitor visitor = new MobileSearchVisitor(idprov);
            MenuUtils.processMenu(visitor);
            Service changesrv = null;
            MenuItem mi = visitor.getMenuItem();
            if (mi != null) {
                changesrv = mi.getService();
            }
            this.log.info((Object)("Provider service: " + changesrv));
            if (idprov == -1 || changesrv == null) {
                if ((ct & 0x10) == 0) return ct &= 0xFFFFFFF7;
                changesrv = Session.getService();
                pack.setChangeToSafeService(true);
            } else if (SystemProp.isChangeMobileUseMenuComm()) {
                Keeper keeper = new Keeper();
                keeper.addPayback(pack.getSumResult().getChange());
                Commission personal = PackUtility.getPersonalCommission(changesrv, chnum);
                Commission comm = Optional.ofNullable(personal).orElse(mi.getCommission());
                SumResult sr = BaseCommissionCalculator.calculate(keeper.getCashSum(), keeper.getCashlessSum(), null, comm, changesrv, mi.isIgnoreMinMaxCommission(), null, changesrv.getMaxSum(), null);
                if (sr.getOut().isEmpty() || changesrv.getMinSum().compareTo(sr.getOut()) > 0 || !sr.getChange().isEmpty()) {
                    changesrv = Session.getService();
                    pack.setChangeToSafeService(true);
                }
            } else {
                ru.softlogic.cash.Sum change = pack.getSumResult().getChange();
                if (changesrv.getMinSum().compareTo(change) > 0 || changesrv.getMaxSum().compareTo(change) < 0) {
                    changesrv = Session.getService();
                    pack.setChangeToSafeService(true);
                }
            }
            pack.setPaybackData(chnum);
            pack.setPaybackService(changesrv);
            Session.setItem("chnumber", chnum);
            Session.setItem("chservice", changesrv);
            return ct;
        } else {
            ct &= 0xFFFFFFF7;
        }
        return ct;
    }

    protected boolean isNeedChange(Pack pack) {
        return !this.getChangeSize(pack).isEmpty() && pack.getPaybackType() == 0;
    }

    protected ru.softlogic.cash.Sum getChangeSize(Pack pack) {
        SumResult sr = pack.getSumResult();
        return sr.getChange().sub(Session.getPayEnv().getKeeper().getOutSumTotal());
    }

    protected void changeToSrv() {
        this.log.info((Object)"Payout to service");
        Pack p = this.environment.getPack();
        p.setPaybackType(3);
        Session.getPaymentEndingState().setChType(3);
        PayEnv payEnv = Session.getPayEnv();
        payEnv.getKeeper().setSumOut(this.getChangeSize(p));
        payEnv.setPack(p);
        this.toNextModule();
    }

    protected void pinToSms() {
        if (PackUtility.isNeedSMSCheck(this.environment.getPack())) {
            this.log.info((Object)"Need to send a PIN code by SMS. Enter  phone number");
            try {
                if (this.smsDescr == null) {
                    this.smsDescr = InitModuleHelper.readScreenDesc("payout/pintosms", Session.getLocale(), 1);
                }
                CommonScreen cbc = ScreenStore.getCommonScreen((String)"numeric/sms");
                cbc.init(this.smsDescr, InitModuleHelper.createScreenInit());
                FxEnv.getCustomModule().show(cbc, (ScreenListener)new PinToSMSListener(), 45);
            }
            catch (ScreenCreateException | InitException | ParseException ex) {
                this.log.debug((Object)("Error getting phone number for sending SMS: " + ex.getMessage()));
                Session.getPaymentEndingState().setSmsCheck(false);
                this.changeToPin();
            }
        } else {
            Session.getPaymentEndingState().setSmsCheck(false);
            this.changeToPin();
        }
    }

    protected void changeToCash() {
        this.log.info((Object)"Payout to cash");
        Pack p = this.environment.getPack();
        p.setPaybackType(2);
        Session.getPaymentEndingState().setChType(2);
        Sum sum = new Sum(this.getChangeSize(p).getValue(), Session.getInCurrency());
        this.log.info((Object)("Payout to cash, sum: " + sum));
        new PayoutTask(sum, this).process();
    }

    public static boolean isOnlineProcessing(Pack pack) {
        if (pack == null) {
            return false;
        }
        Service s = Session.getService();
        return (s.getProcessingType() == ProcessingType.Online || s.getProcessingType() == ProcessingType.HalfOnline) && !pack.getSumResult().getOut().isEmpty();
    }

    @Override
    public void cancel(Intent intent) {
    }

    void onPayoutResult(PayoutResult pr) {
        PackUtility.printPack("Curent pack", this.environment.getPack());
        this.log.info((Object)("Result: " + pr));
        Map resultMap = pr.getPayout();
        this.log.info((Object)("Payout: " + resultMap));
        ru.softlogic.cash.Sum totalSum = FinUtils.createVoidSum();
        for (DenominationSet set : resultMap.values()) {
            totalSum = totalSum.add(CompatUtils.convert(set.getTotal(Session.getInCurrency())));
        }
        Pack pack = this.environment.getPack();
        this.log.info((Object)("Expected payout: " + this.getChangeSize(pack) + ", obtained=" + pr.getTotals().getTotals()));
        IssuedCashBackCard cbc = null;
        if (this.getChangeSize(pack).compareTo(totalSum) > 0) {
            ru.softlogic.cash.Sum rest = this.getChangeSize(pack).sub(totalSum);
            this.log.info((Object)("Failed to give full payout, rest=" + rest));
            if (!pr.hasAmbiguity()) {
                this.log.info((Object)"Generate cbc");
                cbc = FinUtils.generate(rest);
            } else {
                this.log.error((Object)"Payout has ambiguity, skip cbc");
            }
        }
        this.onCashChangeResult(resultMap, cbc);
    }

    void onPayoutFailure() {
        this.changeToPin();
    }

    protected abstract void toNextModule();

    protected abstract void changeToPin();

    protected abstract void changeToTimeOut();

    protected abstract void changeToMob();

    protected abstract void onCashChangeResult(Map<BoxId, DenominationSet> var1, IssuedCashBackCard var2);

    private class PinToSMSListener
    extends BaseScreenListener {
        private PinToSMSListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            BasePayoutModule.this.log.info((Object)("Action: " + action + ", data=" + data));
            if (ActionType.isNext((String)action)) {
                BasePayoutModule.this.environment.getPack().getPayments().get(0).getData().putAll(data);
                BasePayoutModule.this.changeToPin();
            } else {
                BasePayoutModule.this.startPayout(BasePayoutModule.this.environment);
            }
        }
    }

    protected class ChangeTypeListener
    implements DialogListener {
        protected ChangeTypeListener() {
        }

        public void onAction(int actionId) {
            BasePayoutModule.this.log.info((Object)("Selected variant: " + actionId));
            if (actionId == 1) {
                BasePayoutModule.this.pinToSms();
            } else if (actionId == 8) {
                BasePayoutModule.this.changeToMob();
            } else if (actionId == 4) {
                BasePayoutModule.this.changeToCash();
            } else if (actionId == -1) {
                BasePayoutModule.this.changeToTimeOut();
            } else {
                BasePayoutModule.this.changeToSrv();
            }
        }
    }
}

