/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.stage.payout;

import fxterm.app.FxEnv;
import fxterm.core.hdw.bvr.oper.IssuedCashBackCard;
import fxterm.core.hdw.bvr.oper.NewKeeper2;
import fxterm.core.hdw.prt.PrnUtils;
import fxterm.module.Environment;
import fxterm.module.ModuleStore;
import fxterm.module.Pack;
import fxterm.module.PackUtility;
import fxterm.module.stage.payout.BasePayoutModule;
import fxterm.session.Session;
import fxterm.utils.FinUtils;
import java.util.Date;
import java.util.Map;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.hardware.currency.set.DenominationSet;
import ru.softlogic.operation.Operation;
import ru.softlogic.service.comission.SumResult;
import ru.softlogic.storage.cash.BoxId;
import ru.softlogic.system.util.PinCodeGenerator;

public class AfterPayoutModule
extends BasePayoutModule {
    @Override
    public void startPayout(Environment environment) {
        Operation ch;
        super.startPayout(environment);
        this.log.info((Object)"\n");
        this.log.info((Object)"***** SELECT PAYOUT MODULE(AFTER PROCESSING) ************************************************");
        ModuleStore.setModule(this);
        Pack pack = environment.getPack();
        PackUtility.printPack("Pack", pack);
        SumResult sr = pack.getSumResult();
        if (!sr.getDonate().isEmpty()) {
            this.log.info((Object)"Generate deferred donate payment");
            ch = PackUtility.createDonateChange(pack);
            this.log.info((Object)("Operation: " + ch + ", result: " + ch.getSumResult()));
            FxEnv.getConnector().putOperation(ch);
            SumResult srNew = new SumResult(sr.getCash(), sr.getCashLess(), sr.getOut(), sr.getOutProv(), sr.getCommission(), sr.getChange().sub(sr.getDonate()), sr.getDonate(), sr.getProviderFee());
            pack.setSumResult(srNew);
        }
        if (pack.getPaybackType() == 5) {
            this.log.info((Object)"Generate deferred mobile payment");
            ch = PackUtility.createMobileChange(pack);
            this.log.info((Object)("Change operation: " + ch));
            FxEnv.getConnector().putOperation(ch);
            if (pack.getService().isPrintSingleCheckOnMobileChange()) {
                FxEnv.getPrintSpooler().print(PrnUtils.createPrinterJob(ch, false).get(0));
            }
            this.toNextModule();
        } else if (this.isNeedChange(pack)) {
            this.log.info((Object)"Process change");
            this.processChange();
        } else {
            this.log.info((Object)"Change is not needed");
            this.toNextModule();
        }
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    protected void changeToPin() {
        this.log.info((Object)"Payout to cash back card");
        Pack pack = this.environment.getPack();
        pack.setFixedSum(false);
        pack.setPaybackType(1);
        Session.getPaymentEndingState().setChType(1);
        Sum cs = this.getChangeSize(pack);
        IssuedCashBackCard issuedCashBackCard = new IssuedCashBackCard(PinCodeGenerator.generate(), cs);
        this.log.info((Object)("Generate issued CashBack Card: " + issuedCashBackCard));
        pack.setIssuedCard(issuedCashBackCard);
        this.setPinCodeToPrint(issuedCashBackCard);
        Operation ost = PackUtility.convert(pack);
        Keeper keeper = new Keeper();
        keeper.addPayback(cs);
        ost.setDate(new Date());
        ost.setKeeper(keeper);
        ost.setSumResult(FinUtils.createFullChange(cs));
        ost.setChangeDate(pack.getDate());
        FxEnv.getConnector().putOperation(ost);
        this.toNextModule();
    }

    @Override
    protected void changeToTimeOut() {
        Pack pack = this.environment.getPack();
        pack.setPaybackType(1);
        Session.getPaymentEndingState().setChType(-1);
        Sum cs = this.getChangeSize(pack);
        IssuedCashBackCard issuedCashBackCard = new IssuedCashBackCard(PinCodeGenerator.generate(), cs);
        pack.setIssuedCard(issuedCashBackCard);
        this.setPinCodeToPrint(issuedCashBackCard);
        Operation ost = PackUtility.convert(pack);
        Keeper keeper = new Keeper();
        keeper.addPayback(cs);
        ost.setDate(new Date());
        ost.setKeeper(keeper);
        ost.setSumResult(FinUtils.createFullChange(cs));
        ost.setChangeDate(pack.getDate());
        FxEnv.getConnector().putOperation(ost);
        this.toNextModule();
    }

    @Override
    protected void changeToMob() {
        this.log.info((Object)"Payout to mobile");
        Pack pack = this.environment.getPack();
        pack.setPaybackType(5);
        Session.getPaymentEndingState().setChType(5);
        Operation ch = PackUtility.createMobileChange(pack);
        FxEnv.getConnector().putOperation(ch);
        if (pack.getService().isPrintSingleCheckOnMobileChange()) {
            FxEnv.getPrintSpooler().print(PrnUtils.createPrinterJob(ch, false).get(0));
        }
        this.toNextModule();
    }

    @Override
    protected void onCashChangeResult(Map<BoxId, DenominationSet> dispensed, IssuedCashBackCard cashBackCard) {
        this.log.info((Object)"Generate new payment");
        Pack pack = this.environment.getPack();
        NewKeeper2 k = Session.getPayEnv().getKeeper();
        for (Map.Entry<BoxId, DenominationSet> entry : dispensed.entrySet()) {
            k.addDispensed(entry.getKey(), entry.getValue());
        }
        k.setIssuedCard(cashBackCard);
        pack.setIssuedCard(cashBackCard);
        Operation ost = PackUtility.convert(pack);
        Keeper inKeeper = new Keeper();
        Sum cs = this.getChangeSize(pack);
        FinUtils.add(inKeeper, cs);
        ost.setKeeper(inKeeper);
        Keeper chKeeper = new Keeper();
        ost.setChange(chKeeper);
        ost.setSumResult(FinUtils.createFullChange(cs));
        ost.setChangeDate(pack.getDate());
        FxEnv.getConnector().putOperation(ost);
        this.toNextModule();
    }

    @Override
    protected void toNextModule() {
        this.environment.getModules().getPrintModule().print(this.environment);
    }

    private void setPinCodeToPrint(IssuedCashBackCard issuedCashBackCard) {
        if (this.environment.getPrintOperation() != null) {
            this.environment.getPrintOperation().setPinCode(issuedCashBackCard.getPincode());
            this.environment.getPrintOperation().setPinCodeNominal(issuedCashBackCard.getNominal());
        }
    }
}

