/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.stage.payment.keeper;

import fxterm.app.id.LoggerId;
import fxterm.core.menu.GroupByMenuItemVisitor;
import fxterm.core.menu.MenuByServiceIdVisitor;
import fxterm.core.menu.MenuUtils;
import fxterm.module.Environment;
import fxterm.module.EnvironmentFactory;
import fxterm.module.Pack;
import fxterm.module.Payment;
import fxterm.module.PaymentModules;
import fxterm.module.input.InputModule;
import fxterm.module.input.ModuleCreateException;
import fxterm.module.input.keeper.KeeperContext;
import fxterm.module.input.keeper.KeeperHelper;
import fxterm.module.stage.ending.keeper.KeeperEndingModule;
import fxterm.module.stage.payment.keeper.KeeperCashPaymentModule;
import fxterm.module.stage.payout.keeper.KeeperAfterPayoutModule;
import fxterm.module.stage.payout.keeper.KeeperBeforePayoutModule;
import fxterm.module.stage.processing.keeper.KeeperProcessingModule;
import fxterm.session.Session;
import fxterm.utils.FormatUtils;
import java.util.HashMap;
import org.apache.log4j.Logger;
import plfx.GuiNotifier;
import plfx.shell2.dialog.Dialog;
import ru.slkf.atm.AtmPaymentListener;
import ru.softlogic.cash.Sum;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.service.ServiceType;

public class KeeperPaymentLauncher {
    private static final Logger log = LoggerId.PAY;
    private static final KeeperCashPaymentModule payment = new KeeperCashPaymentModule();
    private static final KeeperBeforePayoutModule beforePayout = new KeeperBeforePayoutModule();
    private static final KeeperProcessingModule processing = new KeeperProcessingModule();
    private static final KeeperAfterPayoutModule afterPayout = new KeeperAfterPayoutModule();
    private static final KeeperEndingModule ending = new KeeperEndingModule();

    public static void launch(Short serviceId, String keeperLogin, Integer sum, AtmPaymentListener l, KeeperContext context) {
        ServiceType serviceType = Session.getServiceType();
        MenuItem menuItem = Session.getSelectedItem();
        Runnable restore = () -> {
            Session.setServiceType(serviceType);
            Session.setSelectedItem(menuItem);
            context.restore();
        };
        Adapter listener = new Adapter(restore, l);
        try {
            MenuItem mi;
            if (serviceId != null) {
                MenuByServiceIdVisitor mbsiv = new MenuByServiceIdVisitor(serviceId);
                MenuUtils.processMenu(mbsiv);
                mi = mbsiv.getMenuItem();
            } else {
                mi = context.getKeeperMenuItem();
            }
            if (mi == null) {
                throw new ModuleCreateException("Menu item with id " + serviceId + " not founded");
            }
            log.info((Object)("Found service: " + mi.getService().getName()));
            log.info((Object)"-------------------------------------------------------------------------------");
            log.info((Object)"Launch payment");
            log.info((Object)("    Service      : " + FormatUtils.srvToString(mi.getService())));
            log.info((Object)("    Commission   : " + FormatUtils.commToString(mi.getCommission())));
            log.info((Object)("    Keeper login : " + keeperLogin));
            log.info((Object)("    Sum          : " + sum));
            GroupByMenuItemVisitor gbmiv = new GroupByMenuItemVisitor(mi);
            MenuUtils.processMenu(gbmiv);
            Session.setServiceType(gbmiv.getServiceType());
            Session.setSelectedItem(mi);
            Environment env = EnvironmentFactory.getInstance().create(mi, Session.getLocale());
            PaymentModules modules = env.getModules();
            payment.setGlobalListener(listener, context::cancel, context::getModuleData);
            modules.setInputModule((InputModule)((Object)context.getLastIM()));
            modules.setPaymentModule(payment);
            modules.setBeforePayoutModule(beforePayout);
            modules.setProcessingModule(processing);
            modules.setAfterPayoutModule(afterPayout);
            ending.setListener(listener);
            modules.setEndingModule(ending);
            env.setModules(modules);
            Pack pack = env.getPack();
            pack.getPayments().clear();
            Payment p = new Payment();
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("id1", new InputElement("id1", "Keeper login", keeperLogin));
            p.setData(m);
            pack.getPayments().add(p);
            pack.setMinSum(sum != null ? new Sum(sum.intValue(), Session.getInCurrency()) : null);
            pack.setCommission(Session.getCommission());
            pack.setService(Session.getService());
            pack.setServiceType(Session.getServiceType());
            env.setPack(pack);
            log.info((Object)"Start save pament template");
            env.getModules().getSavePamentTemplateModule().start(env, KeeperHelper.getCommonSumScreen(env, p), context);
        }
        catch (Exception ex) {
            log.error((Object)"Can't create module", (Throwable)ex);
            Dialog.show((String)"module/input/error_exit");
            GuiNotifier.notifyError((Throwable)ex);
            listener.onExit();
        }
    }

    private static class Adapter
    implements AtmPaymentListener {
        private final AtmPaymentListener listener;
        private final Runnable restore;

        public Adapter(Runnable restore, AtmPaymentListener listener) {
            this.restore = restore;
            this.listener = listener;
        }

        public void onBack() {
            log.info((Object)"Send back action to keeper");
            this.restore.run();
            this.listener.onBack();
        }

        public void onExit() {
            log.info((Object)"Send exit action to keeper");
            this.restore.run();
            this.listener.onExit();
        }

        public void onPay(int i) {
            log.info((Object)"Send pay action to keeper");
            this.restore.run();
            this.listener.onPay(i);
        }

        public void onAction(String string) {
            log.info((Object)("Send " + string + " action to keeper"));
            this.restore.run();
            this.listener.onAction(string);
        }
    }
}

