/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.stage.payment.keeper;

import fxterm.module.Intent;
import fxterm.module.stage.payment.CashPaymentModule;
import fxterm.session.Session;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import plfx.shell2.dialog.Dialog;
import ru.slkf.atm.AtmPaymentListener;

public class KeeperCashPaymentModule
extends CashPaymentModule {
    private AtmPaymentListener globalListener;
    private Consumer<Intent> onTimeout;
    private Supplier<Optional<Map<String, Object>>> dataSupplier;

    public void setGlobalListener(AtmPaymentListener globalListener, Consumer<Intent> onTimeout, Supplier<Optional<Map<String, Object>>> dataSupplier) {
        this.globalListener = globalListener;
        this.onTimeout = onTimeout;
        this.dataSupplier = dataSupplier;
    }

    @Override
    protected void onUnknownAction(String action, Map<String, Object> data, Runnable cancelListener) {
        this.cancel(null, action);
    }

    @Override
    public void cancel(Intent intent) {
        this.cancel(intent, null);
    }

    private void cancel(Intent intent, String action) {
        this.log.info((Object)("Cancel was requested on payment module, intent =" + (intent != null ? Integer.valueOf(intent.getType()) : null)));
        this.cm.disable(true);
        if (this.cashInOperation.getSum().isEmpty()) {
            this.log.info((Object)"Keeper is empty. Process intent");
            if (intent != null && intent.getType() == 0) {
                this.log.info((Object)"Payment cancel by timeout");
                this.onTimeout.accept(intent);
            } else if (intent != null && intent.getType() == 3) {
                this.globalListener.onBack();
            } else if (action != null) {
                this.globalListener.onAction(action);
            } else {
                this.globalListener.onExit();
            }
        } else {
            this.log.info((Object)"Keeper is not empty. Ask user");
            Dialog.show((String)"module/payment/cash/cancel_continue", actionId -> {
                this.log.info((Object)("User make choice " + actionId));
                if (actionId == -1) {
                    this.log.info((Object)"Process cancel by time out action");
                    Session.getPaymentEndingState().setChType(-1);
                    this.process(actionId, true);
                } else if (actionId == 0) {
                    this.log.info((Object)"Process cancel by usser action");
                    this.process(actionId, false);
                } else {
                    this.log.info((Object)"Enable devices again");
                    this.enableCashManager();
                    this.cancelListener.run();
                }
            });
        }
    }

    @Override
    public Optional<Map<String, Object>> getModuleData() {
        return this.dataSupplier.get();
    }
}

