/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.stage.payment;

import fxterm.app.FxEnv;
import fxterm.app.id.LoggerId;
import fxterm.core.BaseScreenListener;
import fxterm.core.hdw.bvr.CashManager;
import fxterm.core.hdw.bvr.oper.BaseCashInOperation;
import fxterm.module.stage.payment.PincodeActivator;
import fxterm.session.Session;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.screen.ActionType;

class PincodeListener
extends BaseScreenListener {
    private final BaseCashInOperation operation;
    private final Runnable cancelListener;
    private final Runnable exitToMain;
    private final CashManager cm = FxEnv.getCashManager();
    private final Logger log = LoggerId.PAY;

    public PincodeListener(BaseCashInOperation operation, Runnable exitToMain, Runnable cancelListener) {
        this.operation = operation;
        this.cancelListener = cancelListener;
        this.exitToMain = exitToMain;
    }

    public void onAction(String action, Map<String, Object> data, Runnable cl) {
        boolean isEnableCM;
        this.log.info((Object)("Action on cbc screen: " + action + ", data: " + data));
        this.cancelListener.run();
        boolean bl = isEnableCM = (Session.getService().getPaymentSchemaFlags() & 1) != 0;
        if (ActionType.isExit((String)action)) {
            if (isEnableCM) {
                this.cm.enable(this.operation);
            }
            this.exitToMain.run();
        } else if (ActionType.isPrev((String)action) || ActionType.isTimeout((String)action)) {
            if (isEnableCM) {
                this.cm.enable(this.operation);
            }
        } else if (ActionType.isNext((String)action)) {
            InputElement ie = (InputElement)data.get("pincode");
            new PincodeActivator(ie.getValue(), this.operation).process();
        }
    }
}

