/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.stage.payment;

import fxterm.app.FxEnv;
import fxterm.app.id.LoggerId;
import fxterm.core.Sequence;
import fxterm.core.hdw.bvr.CashManager;
import fxterm.core.hdw.bvr.oper.ActivatedCashBackCard;
import fxterm.core.hdw.bvr.oper.BaseCashInOperation;
import fxterm.core.task.Task;
import fxterm.session.Session;
import fxterm.utils.CompatUtils;
import org.apache.log4j.Logger;
import plfx.shell2.dialog.Dialog;
import ru.softlogic.cash.Sum;
import ru.softlogic.srv.api.cbc.ActivationResult;
import ru.softlogic.srv.api.cbc.ActivationResultType;

class PincodeActivator
extends Task {
    private final String pin;
    private final BaseCashInOperation operation;
    private final Logger log = LoggerId.PAY;
    private final CashManager cm = FxEnv.getCashManager();

    public PincodeActivator(String pin, BaseCashInOperation operation) {
        this.pin = pin;
        this.operation = operation;
    }

    @Override
    protected String getWaitId() {
        return "payment.activate.cbc";
    }

    protected Object execute() throws Exception {
        Sum allowed = CompatUtils.convertNull(this.operation.getAllowedSum());
        this.log.info((Object)("Allowed rest: " + allowed));
        if (allowed == null || allowed.isEmpty()) {
            this.log.info((Object)"Allowed sum is not specify or is empty. Return error");
            return new ActivationResult(ActivationResultType.ErrSum, 0, null);
        }
        return FxEnv.getConnector().acivateCashBackCard(this.pin, new Sum(0, this.operation.getCurrency()), allowed, Sequence.getCbcId());
    }

    protected void onResult(Object object) {
        this.log.info((Object)("Result: " + object));
        ActivationResult ar = (ActivationResult)object;
        this.log.info((Object)("ar:" + ar));
        if (ar.getError() == ActivationResultType.Ok) {
            ActivatedCashBackCard ncbc = new ActivatedCashBackCard(ar.getRest(), ar.getIdOperation());
            this.operation.add(ncbc);
        } else {
            Session.setItem("pay_cbc_error", ar.getError().getCode());
            Dialog.show((String)"module/payment/cash/cbc_error");
        }
        if ((Session.getService().getPaymentSchemaFlags() & 1) != 0) {
            this.cm.enable(this.operation);
        }
    }

    @Override
    protected void onError(Exception ex) {
        this.log.info((Object)"Error on activate cbc", (Throwable)ex);
        Session.setItem("pay_cbc_error", ActivationResultType.ErrNetwork.getCode());
        Dialog.show((String)"module/payment/cash/cbc_error");
    }
}

