/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.stage.payment;

import fxterm.app.FxEnv;
import fxterm.app.id.LoggerId;
import fxterm.core.BaseCommissionCalculator;
import fxterm.core.hdw.bvr.oper.BaseCashInOperation;
import fxterm.core.hdw.bvr.oper.GuiCashInOperationAdapter;
import fxterm.module.PackUtility;
import fxterm.module.Payment;
import fxterm.module.stage.payment.Helper;
import fxterm.session.Session;
import fxterm.utils.CompatUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.log4j.Logger;
import plfx.screen.pay.CommonSumScreen;
import plfx.screen.pay.SumData;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.hardware.currency.set.DenominationSet;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.reference.service.Service;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.service.comission.FeeSum;
import ru.softlogic.service.comission.SumResult;

public class KeeperListener
extends GuiCashInOperationAdapter {
    private final BaseCashInOperation operation;
    private final Commission comm;
    private final Service srv;
    private final Sum min;
    private final Sum max;
    private volatile Sum sumPurchase;
    private volatile Sum requireSum;
    private final CommonSumScreen sumScreen;
    private volatile SumResult result;
    private final Logger log = LoggerId.PAY;
    private final boolean ignoreMinMaxComm;
    private final boolean allowReturn;
    private volatile boolean flagSumFinal;
    private final FeeSum providerFee;

    public KeeperListener(BaseCashInOperation operation, Commission comm, Service srv, Sum min, Sum max, Sum requireSum, Sum sumPurchase, CommonSumScreen sumScreen, boolean immc, boolean allowReturn, FeeSum providerFee) {
        this.operation = operation;
        this.comm = comm;
        this.srv = srv;
        this.min = min;
        this.max = max;
        this.requireSum = requireSum;
        this.sumPurchase = sumPurchase;
        this.sumScreen = sumScreen;
        this.ignoreMinMaxComm = immc;
        this.allowReturn = allowReturn;
        this.providerFee = providerFee;
    }

    public synchronized void updateViews() {
        List<SumResult> srs;
        List<Sum> sopers;
        Sum inCash = this.operation.getKeeper().getInCashSum();
        Sum inCashless = this.operation.getKeeper().getInCashlessSum();
        Sum total = inCash.add(inCashless);
        Sum recommendSum = null;
        HashMap<CashUnit, Integer> denoms = new HashMap<CashUnit, Integer>();
        for (DenominationSet denominationSet : this.operation.getKeeper().getInputCash().values()) {
            Map<CashUnit, Integer> convertToMap = CompatUtils.convertToMap(denominationSet.getCounts());
            for (Map.Entry<CashUnit, Integer> entry : convertToMap.entrySet()) {
                Integer count = denoms.getOrDefault(entry.getKey(), 0);
                denoms.put(entry.getKey(), count + entry.getValue());
            }
        }
        boolean groupDivComm = Boolean.TRUE.equals(this.srv.getGpDivComm());
        boolean dividePayment = this.srv.getDivideSum() != null && !this.srv.getDivideSum().isEmpty();
        boolean dividePaymentRandom = this.srv.getDivideSumFrom() != null && !this.srv.getDivideSumFrom().isEmpty() && this.srv.getDivideSumTo() != null && !this.srv.getDivideSumTo().isEmpty();
        List<Payment> payments = Session.getPayments();
        List<Sum> paymentSums = PackUtility.getPaymentSums(Session.getPayments());
        if (groupDivComm && paymentSums != null) {
            if (this.sumPurchase == null || this.sumPurchase.isEmpty()) {
                recommendSum = BaseCommissionCalculator.calculate(paymentSums, this.comm, this.srv, this.ignoreMinMaxComm, this.providerFee);
                this.requireSum = BaseCommissionCalculator.calculate(payments.get(0).getOperationSum(), this.comm, this.srv, this.ignoreMinMaxComm, this.providerFee);
            } else {
                this.requireSum = BaseCommissionCalculator.calculate(paymentSums, this.comm, this.srv, this.ignoreMinMaxComm, this.providerFee);
            }
            List<SumResult> srs2 = BaseCommissionCalculator.calculateGroupResults(total, this.comm, denoms, this.srv, this.ignoreMinMaxComm, paymentSums, this.sumPurchase, this.max);
            this.result = BaseCommissionCalculator.calculateGroupResult(srs2, inCash, inCashless);
            IntStream.range(0, payments.size()).forEach(i -> {
                SumResult r = (SumResult)srs2.get(i);
                Payment payment = (Payment)payments.get(i);
                payment.setSumOut(r.getOut());
                payment.setSumComm(r.getCommission());
            });
            Session.setPayments(payments);
        } else if ((dividePayment || dividePaymentRandom) && groupDivComm) {
            sopers = null;
            if (this.sumPurchase != null && !this.sumPurchase.isEmpty()) {
                sopers = dividePaymentRandom ? PackUtility.getRandomDivideSums(this.sumPurchase, this.srv) : PackUtility.getDivideSums(this.sumPurchase, this.srv.getDivideSum());
                this.requireSum = BaseCommissionCalculator.calculate(sopers, this.comm, this.srv, this.ignoreMinMaxComm, this.providerFee);
                srs = BaseCommissionCalculator.calculateDivideResults(total, denoms, this.comm, this.srv.getMinComm(), this.srv.getMaxComm(), this.max, this.ignoreMinMaxComm, sopers, this.sumPurchase, this.srv.getDivideSum());
            } else {
                srs = dividePaymentRandom ? BaseCommissionCalculator.calculateRandomDivideResults(total, denoms, this.comm, this.srv.getMinComm(), this.srv.getMaxComm(), this.srv, this.ignoreMinMaxComm) : BaseCommissionCalculator.calculateDivideResults(total, denoms, this.comm, this.srv.getMinComm(), this.srv.getMaxComm(), this.ignoreMinMaxComm, this.srv.getDivideSum());
            }
            this.result = BaseCommissionCalculator.calculateGroupResult(srs, inCash, inCashless);
            Payment payment = payments.get(0);
            payments.clear();
            for (int i2 = 0; i2 < srs.size(); ++i2) {
                Payment p = new Payment(payment);
                if (total.compareTo(this.requireSum) >= 0) {
                    if (this.sumPurchase != null && !this.sumPurchase.isEmpty()) {
                        p.setOperationSum(sopers.get(i2));
                    }
                    p.setSumOut(srs.get(i2).getOut());
                    p.setSumComm(srs.get(i2).getCommission());
                }
                p.getData().put("name", new InputElement("name", "name", Session.getServiceLang().getName(), Session.getServiceLang().getName(), 0));
                payments.add(p);
            }
            Session.setPayments(payments);
        } else if (dividePayment || dividePaymentRandom) {
            sopers = null;
            Sum totalWithoutComm = total;
            Commission comm0 = new Commission(1);
            this.result = BaseCommissionCalculator.calculate(inCash, inCashless, denoms, this.comm, this.srv, this.ignoreMinMaxComm, this.sumPurchase, this.max, this.providerFee);
            Commission realComm = Session.getCommission();
            Sum sumComm = this.result.getCommission();
            if (total.compareTo(sumComm) >= 0) {
                totalWithoutComm = total.sub(sumComm);
            }
            if (this.sumPurchase != null && !this.sumPurchase.isEmpty()) {
                sopers = dividePaymentRandom ? PackUtility.getRandomDivideSums(this.sumPurchase, this.srv) : PackUtility.getDivideSums(this.sumPurchase, this.srv.getDivideSum());
                srs = BaseCommissionCalculator.calculateDivideResults(totalWithoutComm, denoms, comm0, comm0, comm0, this.max, this.ignoreMinMaxComm, sopers, this.sumPurchase, this.srv.getDivideSum());
            } else {
                srs = dividePaymentRandom ? BaseCommissionCalculator.calculateRandomDivideResults(totalWithoutComm, denoms, comm0, comm0, comm0, this.srv, this.ignoreMinMaxComm) : BaseCommissionCalculator.calculateDivideResults(totalWithoutComm, denoms, comm0, comm0, comm0, this.ignoreMinMaxComm, this.srv.getDivideSum());
            }
            Session.setCommission(realComm);
            SumResult srtmp = srs.get(0);
            if (srtmp != null) {
                SumResult sres = Helper.setSRComm(srtmp, sumComm);
                srs.set(0, sres);
            }
            this.result = BaseCommissionCalculator.calculateGroupResult(srs, inCash, inCashless);
            this.result = Helper.setSRComm(this.result, sumComm);
            Payment payment = payments.get(0);
            payments.clear();
            for (int i3 = 0; i3 < srs.size(); ++i3) {
                Payment p = new Payment(payment);
                if (total.compareTo(this.requireSum) >= 0) {
                    if (this.sumPurchase != null && !this.sumPurchase.isEmpty()) {
                        p.setOperationSum(sopers.get(i3));
                    }
                    p.setSumOut(srs.get(i3).getOut());
                    p.setSumComm(srs.get(i3).getCommission());
                }
                p.getData().put("name", new InputElement("name", "name", Session.getServiceLang().getName(), Session.getServiceLang().getName(), 0));
                payments.add(p);
            }
            Session.setPayments(payments);
        } else {
            this.result = BaseCommissionCalculator.calculate(inCash, inCashless, denoms, this.comm, this.srv, this.ignoreMinMaxComm, this.sumPurchase, this.max, this.providerFee);
        }
        Sum ch = this.result.getChange();
        this.log.info((Object)("Result: " + this.result));
        Session.setItem("sum_income", total);
        Session.setItem("sum_outcome", this.result.getOut());
        Session.setItem("sum_comm", this.result.getCommission());
        Session.setItem("sum_change", !ch.isEmpty() ? ch : null);
        Sum needs = null;
        if (this.requireSum != null) {
            needs = this.requireSum.compareTo(total) > 0 ? this.requireSum.sub(total) : null;
        }
        Sum recommend = null;
        if (recommendSum != null) {
            recommend = recommendSum.compareTo(total) > 0 ? recommendSum.sub(total) : null;
        }
        Session.setItem("sum_min", this.requireSum != null && !this.requireSum.isEmpty() ? this.requireSum : null);
        Session.setItem("sum_need", needs != null && !needs.isEmpty() ? needs : null);
        Session.setItem("sum_recommend", recommend != null && !recommend.isEmpty() ? recommend : null);
        Session.setItem("sum_purchase", this.sumPurchase);
        boolean disable = this.isDisableTakeBills(total);
        this.operation.setEnable(!disable);
        Session.setItem("cash_dev_enabled", !disable);
        SumData sd = new SumData(this.canPay(), total.isEmpty() || this.allowReturn, total.isEmpty() || !this.srv.isFlagExist(8L));
        if (Session.getReturnService() != null && Session.getReturnService().getUserAction() != null) {
            Session.getReturnService().getUserAction().update();
        }
        Session.notifyUpdate();
        this.sumScreen.updateSums(sd);
    }

    private void printSr(SumResult sr) {
        System.out.println("\nSumResult");
        System.out.println("Cash " + sr.getCash());
        System.out.println("CashLess " + sr.getCashLess());
        System.out.println("Change " + sr.getChange());
        System.out.println("Commission " + sr.getCommission());
        System.out.println("Donate " + sr.getDonate());
        System.out.println("Income " + sr.getIncome());
        System.out.println("Out " + sr.getOut());
        System.out.println("OutProv " + sr.getOutProv());
    }

    @Override
    public void _onChangeKeeper() {
        if (!this.flagSumFinal) {
            this.updateViews();
            Session.getPayEnv().getPack().setSumResult(this.result);
            Session.getPayEnv().getPack().setCommission(Session.getCommission());
            Session.getPayEnv().save();
            FxEnv.refreshScreen();
        }
    }

    public boolean canPay() {
        if (this.result == null) {
            this.updateViews();
        }
        return !(this.result.getOut().isEmpty() || this.requireSum != null && this.result.getOut().add(this.result.getCommission()).compareTo(this.requireSum) < 0 || this.min != null && this.result.getOut().compareTo(this.min) < 0);
    }

    public SumResult getResult() {
        this.updateViews();
        this.flagSumFinal = true;
        return this.result;
    }

    private boolean isDisableTakeBills(Sum all) {
        Integer use = this.srv.getNotTakeMoneyReachesAmount();
        if (use == null || use == 0) {
            return false;
        }
        return this.result != null && !this.result.getOut().isEmpty() && this.requireSum != null && all.compareTo(this.requireSum) >= 0;
    }

    public boolean isFixedSum() {
        return this.sumPurchase != null && !this.sumPurchase.isEmpty();
    }

    public void setSumPurchase(Sum sumPurchase) {
        this.sumPurchase = sumPurchase;
    }

    public Sum getSumPurchase() {
        return this.sumPurchase;
    }

    public void setRequireSum(Sum requireSum) {
        this.requireSum = requireSum;
    }
}

