/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.stage.payment;

import fxterm.app.FxEnv;
import fxterm.core.BaseCommissionCalculator;
import fxterm.core.hdw.bvr.oper.BaseCashInOperation;
import fxterm.module.input.InitModuleHelper;
import fxterm.module.stage.payment.CommListener;
import fxterm.module.stage.payment.DistribListener;
import fxterm.module.stage.payment.PinCodeValidator;
import fxterm.module.stage.payment.PincodeListener;
import fxterm.session.Session;
import fxterm.session.SumFormatter;
import java.util.Arrays;
import plfx.GuiNotifier;
import plfx.screen.CommonScreen;
import plfx.screen.ScreenCreateException;
import plfx.screen.ScreenListener;
import plfx.screen.ScreenStore;
import ru.softlogic.cash.Sum;
import ru.softlogic.input.model.field.FieldSequence;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.InputField;
import ru.softlogic.input.model.field.numeric.NumericField;
import ru.softlogic.input.model.field.text.EmptyValidator;
import ru.softlogic.input.model.field.text.Filter;
import ru.softlogic.input.model.field.text.Formatter;
import ru.softlogic.input.model.field.text.Keyboard;
import ru.softlogic.input.model.field.text.KeyboardType;
import ru.softlogic.input.model.field.text.NumericExternalValidator;
import ru.softlogic.input.model.field.text.NumericFormatter;
import ru.softlogic.input.model.field.text.OrValidator;
import ru.softlogic.input.model.field.text.RegexFormatter;
import ru.softlogic.input.model.field.text.TextField;
import ru.softlogic.input.model.field.text.Validator;
import ru.softlogic.input.model.field.text.VoidFilter;
import ru.softlogic.input.model.screen.description.InfoScreenDescription;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.input.model.screen.description.SumScreenDescription;
import ru.softlogic.parser.ParseException;
import ru.softlogic.reference.service.Service;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.service.comission.FeeSum;
import ru.softlogic.service.comission.SumResult;

public class Helper {
    public static final String CBC_BUTTON_VISIBLE = "cbcButtonVisible";
    public static final String CBC_BUTTON_DISABLE = "cbcButtonDisable";
    private static ScreenDescription cbcSD;
    private static ScreenDescription distribSD;

    public static synchronized void showCbcScreen(BaseCashInOperation operation, Runnable exitToMain, Runnable cancelListener) {
        if (cbcSD == null) {
            ScreenDescription sdTmp = null;
            try {
                sdTmp = InitModuleHelper.readScreenDesc("input/cbc", Session.getLocale(), 1);
            }
            catch (ParseException ex) {
                TextField tf = new TextField();
                tf.setId("pincode");
                RegexFormatter fmt = new RegexFormatter();
                fmt.setDefaultMask("****-****-****-****");
                fmt.setByStep(true);
                tf.setFormatter((Formatter)fmt);
                tf.setKeyboard(new Keyboard(KeyboardType.Digital));
                tf.setMaxLength(16);
                tf.setValidator((Validator)new PinCodeValidator());
                FieldSequence fs = new FieldSequence();
                fs.setFields(Arrays.asList(tf));
                sdTmp = new ScreenDescription();
                sdTmp.setSequence(fs);
            }
            cbcSD = sdTmp;
        }
        try {
            CommonScreen cbc = ScreenStore.getCommonScreen((String)"numeric/cbc");
            cbc.init(cbcSD, InitModuleHelper.createScreenInit());
            FxEnv.getCustomModule().show(cbc, (ScreenListener)new PincodeListener(operation, exitToMain, cancelListener), 60);
        }
        catch (ScreenCreateException | InitException ex) {
            GuiNotifier.notifyError((Throwable)ex);
            cancelListener.run();
        }
    }

    public static synchronized void showDistribScreen(Sum opr, DistribListener dl, Runnable cancelListener) {
        if (distribSD == null) {
            ScreenDescription sdTmp = null;
            try {
                sdTmp = InitModuleHelper.readScreenDesc("input/distrib", Session.getLocale(), 1);
            }
            catch (ParseException ex) {
                NumericField sumField = new NumericField();
                sumField.setId("sum_purchase");
                sumField.setKeyboard(new Keyboard(KeyboardType.Digital, Character.valueOf(',')));
                sumField.setDecimalCount(2);
                sumField.setUnitCount(5);
                sumField.setFilter((Filter)new VoidFilter());
                sumField.setFormatter((Formatter)new NumericFormatter(",", ","));
                sumField.setValidator((Validator)new OrValidator(new Validator[]{new NumericExternalValidator(), new EmptyValidator()}));
                FieldSequence fs = new FieldSequence();
                fs.setFields(Arrays.asList(sumField));
                sdTmp = new SumScreenDescription();
                sdTmp.setSequence(fs);
            }
            distribSD = sdTmp;
        }
        try {
            InputField field = (InputField)distribSD.getSequence().getFields().get(0);
            field.setValue(Helper.formatSumView(opr));
            field.setDefaultValue(Helper.formatSumView(opr));
            CommonScreen distrib = ScreenStore.getCommonScreen((String)"numeric/distrib");
            distrib.init(distribSD, InitModuleHelper.createScreenInit());
            FxEnv.getCustomModule().show(distrib, (ScreenListener)dl, 60);
        }
        catch (ScreenCreateException | InitException ex) {
            GuiNotifier.notifyError((Throwable)ex);
            cancelListener.run();
        }
    }

    public static void showComm(Runnable cancelListener) {
        try {
            CommonScreen cbc = ScreenStore.getCommonScreen((String)"info/comm");
            InfoScreenDescription sd = new InfoScreenDescription();
            sd.setInfo(Session.getData().get("commission_view_full").toString());
            cbc.init((ScreenDescription)sd, InitModuleHelper.createScreenInit());
            FxEnv.getCustomModule().show(cbc, (ScreenListener)new CommListener(cancelListener), 30);
        }
        catch (ScreenCreateException | InitException ex) {
            GuiNotifier.notifyError((Throwable)ex);
            cancelListener.run();
        }
    }

    public static SumResult setSRComm(SumResult sr, Sum commission) {
        return new SumResult(sr.getCash(), sr.getCashLess(), sr.getOut(), sr.getOutProv(), commission, sr.getChange(), sr.getDonate(), sr.getProviderFee());
    }

    public static Sum getSum(String s) {
        return new Sum((int)Math.round(Double.parseDouble(s.replace(",", ".")) * 100.0), Session.getInCurrency());
    }

    public static Sum getSumRequireSum(Sum opr, Sum min, Commission c, Service s, FeeSum pFee) {
        boolean ignoreMinMaxComm = Session.getActiveItem().isIgnoreMinMaxCommission();
        Sum requireSum = null;
        if (opr != null && !opr.isEmpty()) {
            requireSum = BaseCommissionCalculator.calculate(opr, c, s, ignoreMinMaxComm, pFee);
        }
        if (requireSum == null) {
            requireSum = BaseCommissionCalculator.calculate(min, c, s, ignoreMinMaxComm, pFee);
        }
        return requireSum;
    }

    public static String formatSumView(Sum s) {
        if (s == null || s.isEmpty()) {
            return "";
        }
        return SumFormatter.format("{0,number,#.##}", s).replace(",", ".");
    }
}

