/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.stage.payment;

import fxterm.app.id.LoggerId;
import fxterm.core.BaseScreenListener;
import fxterm.module.Pack;
import fxterm.module.stage.payment.Helper;
import fxterm.module.stage.payment.KeeperListener;
import fxterm.session.Session;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.cash.Sum;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.screen.ActionType;

public class DistribListener
extends BaseScreenListener {
    private final Runnable cancelListener;
    private final Runnable exitToMain;
    private final KeeperListener listener;
    private final Sum min;
    private final Pack pack;
    private final Logger log = LoggerId.PAY;

    public DistribListener(Runnable cl, Runnable etm, KeeperListener l, Sum min, Pack pack) {
        this.cancelListener = cl;
        this.exitToMain = etm;
        this.listener = l;
        this.min = min;
        this.pack = pack;
    }

    public void onAction(String action, Map<String, Object> data, Runnable cl) {
        this.log.info((Object)("Action on distrib screen: " + action + ", data: " + data));
        this.cancelListener.run();
        if (ActionType.isExit((String)action)) {
            this.exitToMain.run();
        } else if ("distrib".equals(action)) {
            InputElement ie = (InputElement)data.get("sum_purchase");
            if (ie != null && ie.getValue() != null && !ie.getValue().isEmpty()) {
                Sum s = Helper.getSum(ie.getValue());
                this.pack.setOperationSum(s);
                this.listener.setSumPurchase(s);
                this.listener.setRequireSum(Helper.getSumRequireSum(s, this.min, Session.getCommission(), Session.getService(), this.pack.getProviderFee()));
            } else {
                this.pack.setOperationSum(null);
                this.listener.setSumPurchase(null);
                this.listener.setRequireSum(Helper.getSumRequireSum(null, this.min, Session.getCommission(), Session.getService(), this.pack.getProviderFee()));
            }
            this.listener.updateViews();
        }
    }
}

