/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.stage.payment;

import fxterm.app.FxEnv;
import fxterm.core.hdw.bvr.CashManager;
import fxterm.module.Environment;
import fxterm.module.Intent;
import fxterm.module.Pack;
import fxterm.module.PackUtility;
import fxterm.module.card.CardModuleHandler;
import fxterm.module.stage.payment.BasePaymentModule;
import fxterm.module.stage.payment.CardPaymentModule;
import fxterm.module.stage.payment.CashPaymentModule;
import fxterm.session.Session;
import plfx.screen.pay.CommonSumScreen;
import plfx.shell2.dialog.Dialog;

public class DispatchPaymentModule
extends BasePaymentModule {
    private static BasePaymentModule cashPaymentModule;
    private static BasePaymentModule cardPaymentModule;
    private BasePaymentModule curentPaymentModule;
    private Pack restore;

    public DispatchPaymentModule() {
        cashPaymentModule = new CashPaymentModule();
        cardPaymentModule = new CardPaymentModule();
    }

    @Override
    public void _startPayment(Environment environment, CommonSumScreen sumScreen, Pack restore) {
        this.restore = restore;
        CardModuleHandler cardHandler = FxEnv.getCardModuleHandler();
        if (cardHandler != null && cardHandler.isInit() && cardHandler.isReady() && Session.getPayEnv().getKeeper().isEmpty()) {
            boolean isCashSource;
            int schemaFlags = Session.getService().getPaymentSchemaFlags();
            CashManager cashManager = FxEnv.getCashManager();
            String inCurrency = Session.getService().getInCurrency();
            boolean currencyAvailable = cashManager.currencySupport(inCurrency);
            boolean isCardSource = (schemaFlags & 4) != 0;
            boolean bl = isCashSource = currencyAvailable && ((schemaFlags & 1) != 0 || (schemaFlags & 2) != 0);
            if (isCardSource && isCashSource) {
                Dialog.show((String)"module/payment/dispatch/cash_source", ac -> {
                    if (ac == 1) {
                        this.log.info((Object)"User select payment to card");
                        this.toCard(environment, sumScreen);
                    } else {
                        this.log.info((Object)"User select payment to cash");
                        this.toCash(environment, sumScreen);
                    }
                });
            } else if (isCardSource) {
                this.toCard(environment, sumScreen);
            } else if (isCashSource) {
                this.toCash(environment, sumScreen);
            }
        } else {
            this.toCash(environment, sumScreen);
        }
    }

    @Override
    public void toCash(Environment environment, CommonSumScreen sumScreen) {
        this.log.info((Object)"Dispatcher: open cash payment module");
        this.curentPaymentModule = cashPaymentModule;
        Session.setCurrentPaymentSource(PackUtility.getPaymentSource(0));
        cashPaymentModule._startPayment(environment, sumScreen, this.restore);
    }

    @Override
    public void toCard(Environment environment, CommonSumScreen sumScreen) {
        this.log.info((Object)"Dispathcher: open card payment module");
        this.curentPaymentModule = cardPaymentModule;
        Session.setCurrentPaymentSource(PackUtility.getPaymentSource(2));
        cardPaymentModule._startPayment(environment, sumScreen, this.restore);
    }

    @Override
    public void cancel(Intent intent) {
        if (this.curentPaymentModule != null) {
            this.curentPaymentModule.cancel(intent);
        }
    }

    @Override
    public void initPaymentSchema() {
        this.curentPaymentModule.initPaymentSchema();
    }
}

