/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.stage.payment;

import fxterm.app.FxEnv;
import fxterm.app.id.LoggerId;
import fxterm.core.AppSumFormatter;
import fxterm.core.BaseCommissionCalculator;
import fxterm.core.BaseScreenListener;
import fxterm.core.hdw.bvr.CashManager;
import fxterm.core.hdw.bvr.oper.BaseCashInOperation;
import fxterm.core.hdw.bvr.oper.FraudListener;
import fxterm.core.hdw.bvr.oper.OperationFactory;
import fxterm.core.hdw.bvr.oper.SumLimits;
import fxterm.module.Environment;
import fxterm.module.ExitIntent;
import fxterm.module.Intent;
import fxterm.module.ModuleHelper;
import fxterm.module.ModuleStore;
import fxterm.module.Pack;
import fxterm.module.PackUtility;
import fxterm.module.Payment;
import fxterm.module.card.CardModuleHandler;
import fxterm.module.input.adv.AdvancedInputModule;
import fxterm.module.stage.payment.BackIntent;
import fxterm.module.stage.payment.BasePaymentModule;
import fxterm.module.stage.payment.DistribListener;
import fxterm.module.stage.payment.Helper;
import fxterm.module.stage.payment.KeeperListener;
import fxterm.session.Session;
import fxterm.utils.FinUtils;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import plfx.AudioPlayerFx;
import plfx.GuiNotifier;
import plfx.screen.Screen;
import plfx.screen.ScreenListener;
import plfx.screen.pay.CommonSumScreen;
import plfx.shell2.dialog.Dialog;
import ru.softlogic.cash.Sum;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hardware.currency.set.DenominationSet;
import ru.softlogic.input.model.screen.ActionType;
import ru.softlogic.reference.References;
import ru.softlogic.reference.fraud.FraudControlRule;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.service.Service;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.service.comission.SumResult;
import ru.softlogic.storage.cash.BoxId;

public class CashPaymentModule
extends BasePaymentModule {
    protected Environment environment;
    protected Runnable cancelListener;
    protected Sum min;
    protected Sum max;
    protected final CashManager cm = FxEnv.getCashManager();
    protected BaseCashInOperation cashInOperation;
    protected KeeperListener listener;
    private boolean init;

    @Override
    public int getInactivityTimeout() {
        Service service = Session.getService();
        if (service != null && service.getAutoProcessDueToInactivity() != null && service.getAutoProcessDueToInactivity() >= 20 && service.getAutoProcessDueToInactivity() <= 120 && this.listener != null && this.listener.canPay()) {
            return service.getAutoProcessDueToInactivity();
        }
        return super.getInactivityTimeout();
    }

    @Override
    public void _startPayment(Environment environment, CommonSumScreen sumScreen, Pack restore) {
        Sum maxDepositSum;
        this.environment = environment;
        ModuleStore.setModule(this);
        this.init = false;
        Pack pack = environment.getPack();
        PackUtility.printPack("Payment pack", pack);
        String curr = Session.getInCurrency();
        Service s = Session.getService();
        MenuItem mi = Session.getActiveItem();
        Commission c = Session.getCommission();
        Session.setPayments(pack.getPayments());
        Sum maxSumPurchase = (Sum)Session.getData().get("max_sum_purchase");
        if (!(pack.getMaxSum() == null || pack.getMaxSum().isEmpty() || maxSumPurchase != null && maxSumPurchase.compareTo(pack.getMaxSum()) <= 0)) {
            maxSumPurchase = pack.getMaxSum();
        }
        Session.setItem("dis_opr_modif", true);
        Session.setItem("vis_opr_modif", false);
        FraudControlRule fcr = ModuleHelper.getFraudControlRule(s.getId());
        pack.setFraudControlRule(fcr);
        this.min = s.getMinSum();
        if (!(pack.getMinSum() == null || pack.getMinSum().isEmpty() || this.min != null && this.min.compareTo(pack.getMinSum()) >= 0)) {
            this.min = pack.getMinSum();
        }
        if ((maxDepositSum = pack.getMaxDepositSum()) == null) {
            maxDepositSum = s.getMaxInputSum();
        }
        if (maxDepositSum == null) {
            maxDepositSum = s.getMaxSum();
        }
        this.max = s.getMaxInputSum();
        if (!CashPaymentModule.isSet(this.max)) {
            this.max = s.getMaxSum();
        } else if (CashPaymentModule.isSet(s.getMaxSum())) {
            Sum sum = this.max = s.getMaxSum().compareTo(this.max) < 0 ? s.getMaxSum() : this.max;
        }
        if (this.max == null || this.max.isEmpty()) {
            GuiNotifier.notifyProblemOnce((String)("Max sum is not set for service: " + Session.getService().getName() + "," + Session.getService().getId()));
            this.exit(new IllegalArgumentException("Max sum is not set for service: " + Session.getService().getName() + "," + Session.getService().getId()));
            return;
        }
        Sum opr = pack.getOperationSum();
        if (this.min == null || this.min.isEmpty()) {
            this.min = new Sum(1, curr);
        }
        if (opr != null && !opr.isEmpty() && opr.compareTo(this.min) < 0) {
            this.log.info((Object)("Fix min sum to=" + opr));
            this.min = opr;
        }
        Sum requireSum = null;
        if (opr != null && !opr.isEmpty()) {
            requireSum = BaseCommissionCalculator.calculate(opr, c, s, mi.isIgnoreMinMaxCommission(), pack.getProviderFee());
        }
        if (requireSum == null) {
            requireSum = BaseCommissionCalculator.calculate(this.min, c, s, mi.isIgnoreMinMaxCommission(), pack.getProviderFee());
        }
        this.log.info((Object)"Sums restrictions");
        this.log.info((Object)("    Min          : " + AppSumFormatter.asStr(this.min) + "(in srv=" + AppSumFormatter.asStr(s.getMinSum()) + ")"));
        this.log.info((Object)("    Max          : " + AppSumFormatter.asStr(this.max)));
        this.log.info((Object)("    Operation    : " + AppSumFormatter.asStr(opr)));
        this.log.info((Object)("    Required     : " + AppSumFormatter.asStr(requireSum)));
        this.log.info((Object)("    Max pay      : " + AppSumFormatter.asStr(s.getMaxSum())));
        this.log.info((Object)("    Max input    : " + AppSumFormatter.asStr(s.getMaxInputSum())));
        this.log.info((Object)("    Max sum purchase: " + AppSumFormatter.asStr(maxSumPurchase)));
        SumLimits sumLimits = new SumLimits(this.min, pack.getMinSumWithNoteLimit(), pack.getMaxDepositSum(), maxDepositSum);
        this.log.info((Object)("Limits: " + sumLimits));
        Session.setItem("sum_max", this.max);
        Set<Denomination> hdw = this.cm.getHdwDenomination(curr);
        this.log.info((Object)"Supported hardware denominations:");
        if (hdw != null) {
            hdw.stream().forEach(dn -> this.log.info((Object)("    id=" + dn.getId() + ", " + (dn.getType() == 0 ? "NOTE" : "COIN") + ", " + dn.getNominal() + ", " + dn.getCurrency())));
        }
        this.log.info((Object)"Another options");
        this.log.info((Object)("    Disable exit on depositing funds: " + s.isFlagExist(8L)));
        this.log.info((Object)("    Not take money reaches amount   : " + s.getNotTakeMoneyReachesAmount()));
        this.cashInOperation = OperationFactory.createDefaultOperation(Session.getPayEnv().getKeeper(), sumLimits, PackUtility.getToken(pack));
        this.cashInOperation.addFraudListener(new DefaultFraudListener(fcr));
        Session.calculatePurchaseRange(this.min, maxSumPurchase);
        String dialogId = null;
        String errorMsg = null;
        if (opr != null && opr.isEmpty()) {
            errorMsg = "Operation sum can not be 0. Service id:" + s.getId();
            dialogId = "module/payment/cash/empty_sum";
        } else if (maxSumPurchase != null && !maxSumPurchase.isEmpty()) {
            if (requireSum.compareTo(this.max) > 0) {
                errorMsg = "Required sum exceeds the MAX_SUM = " + AppSumFormatter.asStr(this.max) + ". Service id:" + s.getId() + ". Required sum: " + AppSumFormatter.asStr(requireSum);
                dialogId = "module/payment/cash/exceeds_max_sum";
            }
            if (opr != null && !opr.isEmpty() && opr.compareTo(maxSumPurchase) > 0) {
                errorMsg = "Operation sum exceeds the MAX_SUM = " + AppSumFormatter.asStr(maxSumPurchase) + ". Service id:" + s.getId() + ". Oparation sum: " + AppSumFormatter.asStr(opr);
                dialogId = "module/payment/cash/exceeds_sum";
            }
            if (this.min.compareTo(maxSumPurchase) > 0) {
                errorMsg = "Max sum is less than min sum = " + AppSumFormatter.asStr(this.min) + ". Service id:" + s.getId() + ". Max sum: " + AppSumFormatter.asStr(maxSumPurchase);
                dialogId = "module/payment/cash/less_sum";
            }
        }
        if (errorMsg != null) {
            if (environment.getModules().getInputModule() instanceof AdvancedInputModule) {
                Session.getPayEnv().setPack(restore);
                Dialog.show((String)dialogId, actionId -> this.cancel(new BackIntent(environment.getModules().getSavePamentTemplateModule())));
            } else {
                this.exit(new IllegalArgumentException(errorMsg));
            }
            return;
        }
        this.listener = new KeeperListener(this.cashInOperation, c, s, this.min, maxSumPurchase, requireSum, opr, sumScreen, mi.isIgnoreMinMaxCommission(), pack.isAllowReturn(), pack.getProviderFee());
        this.listener.updateViews();
        this.cashInOperation.addOperationListener(this.listener);
        sumScreen.setListener((ScreenListener)new CashScreenListener());
        FxEnv.showScreen((Screen)sumScreen);
        AudioPlayerFx.getInstance().play("pay_data.mp3");
        this.init = true;
    }

    @Override
    public void initPaymentSchema() {
        if (this.init) {
            int schemaFlags = Session.getService().getPaymentSchemaFlags();
            boolean isCashSource = (schemaFlags & 1) != 0;
            boolean isCbcSource = (schemaFlags & 2) != 0;
            boolean isShowCashback = true;
            if (References.getPointOptions() != null && !References.getPointOptions().isShowCashback()) {
                isShowCashback = false;
            }
            if (isCashSource && isCbcSource) {
                this.log.info((Object)"Enable cash devices and cashback card button");
                this.enableCashManager();
                Session.setItem("cbcButtonDisable", false);
                Session.setItem("cbcButtonVisible", isShowCashback);
            } else if (isCashSource) {
                this.log.info((Object)"Enable cash devices");
                this.enableCashManager();
                Session.setItem("cbcButtonDisable", true);
                Session.setItem("cbcButtonVisible", isShowCashback);
            } else {
                this.log.info((Object)"Enable cashback card button");
                Session.setItem("cbcButtonDisable", false);
                Session.setItem("cbcButtonVisible", true);
            }
            Session.notifyUpdate();
        } else {
            this.log.warn((Object)"Skip init payment schema");
        }
    }

    @Override
    public boolean canRedirect() {
        this.log.info((Object)"Request for permission to redirect from PaymentModule");
        if (this.cashInOperation.getSum().isEmpty()) {
            this.log.info((Object)"Keeper is empty. Disable cash devices");
            this.cm.disable(true);
            if (this.cashInOperation.getSum().isEmpty()) {
                this.log.info((Object)"Keeper is empty. Process redirect");
                return true;
            }
            this.log.info((Object)"Current keeper is not empty");
            this.initPaymentSchema();
            return false;
        }
        this.log.info((Object)"Current keeper is not empty. Skip redirect");
        return false;
    }

    protected void enableCashManager() {
        this.cm.enable(this.cashInOperation);
    }

    @Override
    public void cancel(Intent intent) {
        this.log.info((Object)("Cancel was requested on payment module, intent =" + intent.getType()));
        boolean timeout = intent.getType() == 0;
        Service service = null;
        if (Session.getService() != null) {
            service = Session.getService();
        }
        if (timeout) {
            this.log.info((Object)"Payment cancel by timeout");
            Session.getPaymentEndingState().setChType(-1);
        }
        if (this.cashInOperation.getSum().isEmpty()) {
            this.log.info((Object)"Keeper is empty. Disable cash devices");
            this.cm.disable(true);
            if (this.cashInOperation.getSum().isEmpty()) {
                this.log.info((Object)"Keeper is empty. Process intent");
                CardModuleHandler cmh = FxEnv.getCardModuleHandler();
                if (cmh != null && cmh.getCashRequireListener() != null) {
                    cmh.getCashRequireListener().onCancel();
                }
                if (cmh != null && cmh.getBankCashRequireListener() != null) {
                    cmh.getBankCashRequireListener().onCancel();
                }
                if (intent.getType() == 3) {
                    intent.process();
                } else {
                    this.exit();
                }
            } else {
                this.log.info((Object)("New keeper state: " + this.cashInOperation.getSum()));
                if (intent.getType() == 3) {
                    this.log.info((Object)"Can't do back action");
                    this.initPaymentSchema();
                } else if (this.listener.canPay()) {
                    if (timeout && service != null && service.getAutoProcessDueToInactivity() != null) {
                        this.log.info((Object)"Exit by timeout, but payment can be processed. Process payment without question.");
                        this.process(0, timeout);
                    } else {
                        this.log.info((Object)"Payment can be processed, ask question");
                        Dialog.show((String)(timeout ? "module/payment/cash/empty_payment_cancel" : "module/payment/cash/empty_payment_timeout"), actionId -> {
                            this.log.info((Object)("User make choice " + actionId));
                            if (actionId == 0) {
                                this.log.info((Object)"Process cancel");
                                this.process(actionId, timeout);
                            } else {
                                this.initPaymentSchema();
                                this.cancelListener.run();
                            }
                        });
                    }
                } else {
                    this.log.info((Object)"Payment can't be processed. Cancel payment");
                    this.process(1, timeout);
                }
            }
        } else {
            this.log.info((Object)"Keeper is not empty. Disable cash devices");
            if (this.listener.canPay()) {
                this.cm.disable(true);
                if (timeout && service != null && service.getAutoProcessDueToInactivity() != null) {
                    this.log.info((Object)"Exit by timeout, but the amount is sufficient for the payment. Process payment without question.");
                    this.process(0, timeout);
                } else if (intent.getType() == 3) {
                    this.log.info((Object)"Process BACK intent");
                    intent.process();
                } else {
                    this.log.info((Object)"The amount is sufficient for the payment, ask question");
                    Dialog.show((String)(timeout ? "module/payment/cash/filled_payment_cancel" : "module/payment/cash/filled_payment_timeout"), actionId -> {
                        this.log.info((Object)("User make choice " + actionId));
                        this.process(actionId, timeout);
                    });
                }
            } else {
                this.cm.disable(true);
                if (intent.getType() == 3) {
                    this.log.info((Object)"Process BACK intent");
                    intent.process();
                } else {
                    this.log.info((Object)"The amount is NOT sufficient for the payment, ask question");
                    Dialog.show((String)"module/payment/cash/cancel_continue", actionId -> {
                        this.log.info((Object)("User make choice " + actionId));
                        if (actionId == 0) {
                            this.initPaymentSchema();
                            this.cancelListener.run();
                        } else {
                            this.process(actionId, timeout);
                        }
                    });
                }
            }
        }
    }

    protected void process(int actionId, boolean timeout) {
        this.log.info((Object)("Begin process payment, actionId=" + actionId + ", timeout=" + timeout + ", keeper=" + this.cashInOperation.getSum()));
        if (this.cashInOperation.getKeeper().isEmpty()) {
            GuiNotifier.notifyProblem((String)"#001");
            this.log.error((Object)"Double click?");
            return;
        }
        Pack pack = this.environment.getPack();
        this.log.info((Object)"Update SumResult");
        SumResult sumResult = this.listener.getResult();
        pack.setSumResult(sumResult);
        pack.setFixedSum(this.listener.isFixedSum());
        Service s = Session.getService();
        Sum divSum = s.getDivideSum();
        if (divSum != null && !divSum.isEmpty() && actionId == 0 && pack.getPayments().size() == 1) {
            Sum totalInput = sumResult.getOut();
            this.log.info((Object)("\u041e\u0431\u0449\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 " + totalInput + ", \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0440\u0430\u0437\u0434\u0435\u043b\u0438\u0442\u044c \u043d\u0430 \u0441\u0443\u043c\u043c\u044b: " + divSum));
            int count = totalInput.getValue() / divSum.getValue();
            if (!divSum.mul((double)count).equals((Object)totalInput)) {
                ++count;
            }
            --count;
            Payment payment = pack.getPayments().get(0);
            payment.setOperationSum(divSum);
            for (int i = 0; i < count; ++i) {
                Payment payment1 = new Payment();
                payment1.setData(payment.getData());
                payment1.setOperationSum(divSum);
                pack.getPayments().add(payment1);
            }
            pack.setSumDistributionType("consistent");
        }
        if (pack.getPayments().size() == 1) {
            this.log.info((Object)"Process single operation pack");
            Payment p = pack.getPayments().get(0);
            if (actionId == 0) {
                p.setSumOut(sumResult.getOut());
                Session.getPaymentEndingState().setCancel(false);
            } else {
                PackUtility.cancelPack(pack);
                p.setSumOut(FinUtils.createVoidSum());
                Session.getPaymentEndingState().setCancel(true);
            }
        } else if (s.getDivideSum() != null && !s.getDivideSum().isEmpty() || s.getDivideSumFrom() != null && !s.getDivideSumFrom().isEmpty() && s.getDivideSumTo() != null && !s.getDivideSumTo().isEmpty()) {
            this.log.info((Object)"Process divide operation pack");
            if (actionId == 0) {
                PackUtility.setGroupIds(pack.getPayments());
                pack.setSumResult(sumResult);
                Session.getPaymentEndingState().setCancel(false);
            } else {
                PackUtility.cancelPack(pack);
                Session.getPaymentEndingState().setCancel(true);
            }
        } else {
            this.log.info((Object)("Pack size: " + pack.getPayments().size()));
            if (actionId == 0) {
                if (Boolean.TRUE.equals(s.getGpDivComm()) && PackUtility.getPaymentSums(pack.getPayments()) != null) {
                    PackUtility.setGroupIds(pack.getPayments());
                    pack.setSumResult(sumResult);
                    Session.getPaymentEndingState().setCancel(false);
                } else {
                    pack.setSumResult(sumResult);
                    PackUtility.distributeSum(pack, sumResult);
                    PackUtility.setGroupIds(pack.getPayments());
                    Session.getPaymentEndingState().setCancel(false);
                }
            } else {
                PackUtility.cancelPack(pack);
                Session.getPaymentEndingState().setCancel(true);
            }
        }
        this.startPayout(this.environment);
    }

    protected void onUnknownAction(String action, Map<String, Object> data, Runnable cancelListener) {
        cancelListener.run();
        GuiNotifier.notifyProblem((String)("Unknown action on sumscreen: " + action));
    }

    private static boolean isSet(Sum sum) {
        return sum != null && !sum.isEmpty();
    }

    class DefaultFraudListener
    implements FraudListener {
        private final FraudControlRule fcr;

        public DefaultFraudListener(FraudControlRule fcr) {
            this.fcr = fcr;
        }

        @Override
        public void onFraudAttempt() {
            boolean react;
            if (this.fcr == null) {
                CashPaymentModule.this.log.info((Object)"Fraud-control: disable");
                return;
            }
            Integer minNominalNote = this.fcr.getMinNominalNote() == 0 ? null : Integer.valueOf(this.fcr.getMinNominalNote());
            Integer timeout = this.fcr.getTimeout() == 0 ? null : Integer.valueOf(this.fcr.getTimeout());
            CashPaymentModule.this.log.info((Object)("Fraud min nominal      : " + minNominalNote));
            CashPaymentModule.this.log.info((Object)("Fraud timeout          : " + timeout));
            CashPaymentModule.this.log.info((Object)("Fraud optional success : " + this.fcr.isOptionalSuccess()));
            if (minNominalNote == null || timeout == null) {
                CashPaymentModule.this.log.info((Object)"Fraud-control: disable");
                return;
            }
            CashPaymentModule.this.log.info((Object)"Fraud-control: enable");
            float amountWeight = 0.0f;
            for (Map.Entry<Integer, Integer> e : CashPaymentModule.this.cashInOperation.getFraudData().entrySet()) {
                amountWeight += BaseCashInOperation.getFraudWeight(e.getKey()) * (float)e.getValue().intValue();
            }
            if ((double)amountWeight < 1.0) {
                CashPaymentModule.this.log.info((Object)("Fraud warning. Rate: " + amountWeight));
                return;
            }
            CashPaymentModule.this.log.info((Object)("Fraud detect. Rate: " + amountWeight));
            if (this.fcr.isOptionalSuccess()) {
                CashPaymentModule.this.log.info((Object)"isFraudOptionalSuccess(): true");
                react = true;
            } else {
                react = this.checkMinFroudNominal(CashPaymentModule.this.cashInOperation.getKeeper().getInputCash(), minNominalNote);
            }
            if (react) {
                CashPaymentModule.this.log.info((Object)"Reaction on fraud");
                FxEnv.getConnector().getQueue().onFraudDetect();
                CashPaymentModule.this.environment.getPack().setFraud(true);
                Session.setFraudLock(timeout);
            }
        }

        private boolean checkMinFroudNominal(Map<BoxId, DenominationSet> map, Integer minNominalNote) {
            for (DenominationSet denominations : map.values()) {
                for (Denomination denomination : denominations.getCounts().keySet()) {
                    if (denomination.getType() != 0 || denomination.getNominal() < minNominalNote) continue;
                    return true;
                }
            }
            return false;
        }
    }

    class CashScreenListener
    extends BaseScreenListener {
        private final Logger log = LoggerId.PAY;
        private final CashManager cm = FxEnv.getCashManager();

        CashScreenListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            this.log.info((Object)("Action on sum screen: " + action));
            CashPaymentModule.this.cancelListener = cancelListener;
            Pack pack = CashPaymentModule.this.environment.getPack();
            Runnable exitToMain = () -> {
                this.log.info((Object)"Exit to main menu");
                CashPaymentModule.this.cancel(new ExitIntent(null, 2, 2));
            };
            if (ActionType.isCbc((String)action)) {
                this.cm.disable(false);
                Helper.showCbcScreen(CashPaymentModule.this.cashInOperation, exitToMain, cancelListener);
            } else if (ActionType.isComm((String)action)) {
                this.log.info((Object)"Show commission screen");
                Helper.showComm(cancelListener);
            } else if (ActionType.isExit((String)action)) {
                this.log.info((Object)"Exit to main menu");
                CashPaymentModule.this.cancel(new ExitIntent(null, 2, 2));
            } else if (ActionType.isPrev((String)action)) {
                this.log.info((Object)"Exit to paytpl module");
                pack.setSumResult(CashPaymentModule.this.listener.getResult());
                CashPaymentModule.this.cancel(new BackIntent(CashPaymentModule.this.environment.getModules().getSavePamentTemplateModule()));
                if (cancelListener != null) {
                    cancelListener.run();
                }
            } else if (ActionType.isNext((String)action)) {
                this.cm.disable(true);
                CashPaymentModule.this.process(0, false);
            } else if ("showdistrib".equals(action)) {
                DistribListener dl = new DistribListener(cancelListener, exitToMain, CashPaymentModule.this.listener, CashPaymentModule.this.min, pack);
                this.log.info((Object)"Show distrib screen");
                Helper.showDistribScreen(CashPaymentModule.this.listener.getSumPurchase(), dl, cancelListener);
            } else {
                CashPaymentModule.this.onUnknownAction(action, data, cancelListener);
            }
        }
    }
}

