/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.stage.payment;

import fxterm.app.FxEnv;
import fxterm.core.BaseCommissionCalculator;
import fxterm.core.BaseScreenListener;
import fxterm.module.Environment;
import fxterm.module.Intent;
import fxterm.module.ModuleStore;
import fxterm.module.Pack;
import fxterm.module.Payment;
import fxterm.module.card.CardModuleHandler;
import fxterm.module.card.ReverseTask;
import fxterm.module.input.InitModuleHelper;
import fxterm.module.input.card.BaseCardInputModule;
import fxterm.module.stage.payment.BasePaymentModule;
import fxterm.session.Session;
import fxterm.session.SumFormatter;
import fxterm.utils.FinUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javafx.application.Platform;
import plfx.screen.CommonScreen;
import plfx.screen.Screen;
import plfx.screen.ScreenCreateException;
import plfx.screen.ScreenListener;
import plfx.screen.ScreenStore;
import plfx.screen.pay.CommonSumScreen;
import plfx.shell2.dialog.Dialog;
import ru.softlogic.cards.v2.connector.model.CardData;
import ru.softlogic.cards.v2.connector.model.Currency;
import ru.softlogic.cards.v2.connector.model.FinanceOperation;
import ru.softlogic.cards.v2.connector.model.OperationPurchaseResult;
import ru.softlogic.cards.v2.model.CardModuleError;
import ru.softlogic.cards.v2.module.CardInfo;
import ru.softlogic.cards.v2.module.CardModuleResultListener;
import ru.softlogic.cash.Sum;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.StoreHelper;
import ru.softlogic.input.model.field.FieldSequence;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.numeric.NumericField;
import ru.softlogic.input.model.field.text.Formatter;
import ru.softlogic.input.model.field.text.Keyboard;
import ru.softlogic.input.model.field.text.KeyboardType;
import ru.softlogic.input.model.field.text.NumericExternalValidator;
import ru.softlogic.input.model.field.text.NumericFormatter;
import ru.softlogic.input.model.field.text.Validator;
import ru.softlogic.input.model.screen.ActionType;
import ru.softlogic.input.model.screen.description.ConfirmScreenDescription;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.service.comission.SumResult;

public class CardPaymentModule
extends BasePaymentModule {
    private LocalGuiListener guiListener;
    protected Environment environment;
    private CommonSumScreen sumScreen;
    private Runnable cancelListener;
    private Sum sumIncome;
    private Sum sumOutcome;

    @Override
    public void _startPayment(Environment environment, CommonSumScreen sumScreen, Pack restore) {
        this.log.info((Object)"Open card payment module");
        this.environment = environment;
        this.sumScreen = sumScreen;
        ModuleStore.setModule(this);
        Sum opr = environment.getPack().getOperationSum();
        this.guiListener = new LocalGuiListener();
        this.log.info((Object)("Sum purchase: " + opr));
        if (opr == null || opr.isEmpty()) {
            this.log.info((Object)"Purchase sum is not set, open numeric screen");
            this.showSumScreen();
        } else {
            this.showConfirmScreen(opr);
        }
    }

    @Override
    public void cancel(Intent intent) {
        System.out.println(">>>>>>>>>>>>");
        this.guiListener.cancel(intent);
    }

    @Override
    public void initPaymentSchema() {
    }

    private void showSumScreen() {
        try {
            this.log.info((Object)"Show Sum Screen");
            CommonScreen sumScreen = ScreenStore.getCommonScreen((String)"digital");
            ScreenDescription sd = new ScreenDescription("digital");
            NumericField sumField = new NumericField();
            sumField.setTitle(CardModuleHandler.getMessage("input_sum_title"));
            sumField.setId("sum_purchase");
            sumField.setKeyboard(new Keyboard(KeyboardType.Digital, Character.valueOf('.')));
            sumField.setDecimalCount(2);
            sumField.setUnitCount(5);
            sumField.setFormatter((Formatter)new NumericFormatter(".", "."));
            sumField.setValidator((Validator)new NumericExternalValidator());
            FieldSequence fs = new FieldSequence();
            fs.setFields(Arrays.asList(sumField));
            sd.setSequence(fs);
            Session.setScreenDescription(sd);
            sumScreen.init(sd, InitModuleHelper.buildScreenInit(this.environment, Collections.emptyMap()));
            sumScreen.setListener((ScreenListener)new BaseScreenListener(){

                public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
                    CardPaymentModule.this.log.info((Object)("Action on Sum Screen: " + action));
                    if (ActionType.isNext((String)action)) {
                        InputElement s = (InputElement)data.get("sum_purchase");
                        CardPaymentModule.this.environment.getPack().setOperationSum(new Sum((int)(Double.parseDouble(s.getValue()) * 100.0), Session.getInCurrency()));
                        CardPaymentModule.this.showConfirmScreen(CardPaymentModule.this.environment.getPack().getOperationSum());
                    } else {
                        CardPaymentModule.this.log.info((Object)"User select cancel");
                        CardPaymentModule.this.exit();
                    }
                }
            });
            FxEnv.showScreen((Screen)sumScreen);
        }
        catch (ScreenCreateException | InitException ex) {
            this.guiListener.exit((Exception)ex);
        }
    }

    private void showConfirmScreen(Sum oper) {
        this.log.info((Object)("Show Confirm Screen: sum = " + oper));
        try {
            CommonScreen cs = ScreenStore.getCommonScreen((String)"confirm");
            ConfirmScreenDescription sd = new ConfirmScreenDescription();
            sd.setType("confirm");
            cs.setListener((ScreenListener)new BaseScreenListener(){

                public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
                    CardPaymentModule.this.log.info((Object)("Action on Confirm Screen: " + action));
                    if (ActionType.isNext((String)action)) {
                        CardPaymentModule.this.guiListener.start(CardPaymentModule.this.environment);
                    } else {
                        CardPaymentModule.this.log.info((Object)"User select cancel");
                        CardPaymentModule.this.exit();
                    }
                }
            });
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("sumchange", new InputElement("sum_purchase", CardModuleHandler.getMessage("input_sum_title"), SumFormatter.format(oper), SumFormatter.format(oper), 0));
            Session.setScreenDescription((ScreenDescription)sd);
            cs.init((ScreenDescription)sd, InitModuleHelper.buildScreenInit(this.environment, data));
            this.log.debug((Object)"Show screen");
            FxEnv.showScreen((Screen)cs);
        }
        catch (ScreenCreateException | InitException ex) {
            this.guiListener.exit((Exception)ex);
        }
    }

    private void fillCardInfo(Map<String, Object> data, OperationPurchaseResult t, CardInfo ci) {
        this.log.info((Object)("OperationPurchaseResult: " + t));
        if (t.getAuthIdentResponse() != null) {
            data.put("auth", this.createInputElement("auth", "Module.card.cardinfo.auth", t.getAuthIdentResponse()));
        }
        if (t.getRrn() != null) {
            data.put("rrn", this.createInputElement("rrn", "Module.card.cardinfo.rrn", t.getRrn()));
        }
        data.put("merchant", this.createInputElement("merchant", "Module.card.cardinfo.merchant", t.getMerchant()));
        data.put("stan", this.createInputElement("stan", "Module.card.cardinfo.stan", t.getStan()));
        data.put("terminal", this.createInputElement("terminal", "Module.card.cardinfo.terminal", t.getTerminal()));
        data.put("is-cashless", this.createInputElement("is-cashless", "Module.card.cashless", "true"));
        data.put("account-client", this.createInputElement("account-client", "Module.card.pan", ci.getPan()));
    }

    private InputElement createInputElement(String key, String keyTitleCode, String value) {
        return new InputElement(key, CardModuleHandler.getMessage(keyTitleCode), value);
    }

    private class LocalPurchaseListener
    implements CardModuleResultListener<OperationPurchaseResult> {
        private LocalPurchaseListener() {
        }

        public void onError(CardModuleError cme, String message) {
            CardPaymentModule.this.log.error((Object)("onError: " + cme + ", " + message));
            Platform.runLater(() -> {
                new Thread(new ReverseTask()).start();
                if (cme == CardModuleError.ERROR_USER_CANCEL) {
                    CardPaymentModule.this.log.info((Object)"Operation canceled by user, show dialog");
                    Dialog.show((String)"module/card/error_cancel_user", ac -> CardPaymentModule.this.guiListener.cancel(null));
                } else if ((Session.getService().getPaymentSchemaFlags() & 1) > 0) {
                    CardPaymentModule.this.log.info((Object)"Can payment by cash. Show question");
                    Dialog.show((String)"module/payment/cardcard_error_tocash", ac -> {
                        if (ac == 0) {
                            CardPaymentModule.this.log.info((Object)"User select to cash");
                            CardPaymentModule.this.cancelListener = () -> {
                                CardPaymentModule.this.environment.getModules().getPaymentModule().toCash(CardPaymentModule.this.environment, CardPaymentModule.this.sumScreen);
                                CardPaymentModule.this.cancelListener = null;
                            };
                        } else {
                            CardPaymentModule.this.log.info((Object)"User select to cancel");
                            CardPaymentModule.this.guiListener.cancel(null);
                        }
                    });
                } else {
                    CardPaymentModule.this.log.info((Object)("Show dialog with message = " + message));
                    Session.setItem("card_error_msg", message);
                    Dialog.show((String)"module/card/error", ac -> CardPaymentModule.this.guiListener.cancel(null));
                }
            });
        }

        public void onResult(OperationPurchaseResult r, CardInfo ci) {
            CardPaymentModule.this.log.info((Object)("onSuccess: " + r + ", " + ci));
            Session.getPayEnv().getKeeper().setIncome(CardPaymentModule.this.sumIncome);
            Pack pack = Session.getPayEnv().getPack();
            Payment p = pack.getPayments().get(0);
            p.setSumOut(CardPaymentModule.this.sumOutcome);
            Sum s0 = FinUtils.createVoidSum();
            CardPaymentModule.this.fillCardInfo(p.getData(), r, ci);
            pack.setSumResult(new SumResult(s0, CardPaymentModule.this.sumIncome, CardPaymentModule.this.sumOutcome, CardPaymentModule.this.sumOutcome, CardPaymentModule.this.sumIncome.sub(CardPaymentModule.this.sumOutcome), s0, pack.getProviderFee()));
            pack.setPaymentTool(ci.isIinCard() ? 2 : 3);
            CardPaymentModule.this.cancelListener = () -> {
                CardPaymentModule.this.environment.getModules().getProcessingModule().process(CardPaymentModule.this.environment);
                CardPaymentModule.this.cancelListener = null;
            };
            FxEnv.getCardModuleHandler().closeSession(true);
        }

        public void onCardData(CardData cd) {
        }
    }

    private class LocalGuiListener
    extends BaseCardInputModule {
        private LocalGuiListener() {
        }

        public void startPayment(Environment environment) {
            super._start(environment);
        }

        @Override
        protected void _startOperation() {
            Sum opr = CardPaymentModule.this.environment.getPack().getOperationSum();
            this.log.info((Object)("Start card operation, sum purchase=" + opr));
            CardPaymentModule.this.sumOutcome = opr;
            CardPaymentModule.this.sumIncome = BaseCommissionCalculator.calculate(opr, Session.getCommission(), Session.getService(), Session.getActiveItem().isIgnoreMinMaxCommission(), CardPaymentModule.this.environment.getPack().getProviderFee());
            Sum com = CardPaymentModule.this.sumIncome.sub(opr);
            this.log.info((Object)("Sum comission: " + com));
            FinanceOperation financeOperation = new FinanceOperation(StoreHelper.convertDep(CardPaymentModule.this.environment.getPack().getPayments().get(0).getData()), (long)CardPaymentModule.this.sumIncome.getValue(), (long)com.getValue(), Currency.getInstance((String)Session.getInCurrency()), (String)Session.getAttribute("mcc"));
            this.cm.purchase(financeOperation, (CardModuleResultListener)new LocalPurchaseListener());
        }

        @Override
        protected synchronized void onClosed() {
            if (CardPaymentModule.this.cancelListener != null) {
                CardPaymentModule.this.cancelListener.run();
            } else {
                this.exit();
            }
        }
    }
}

