/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.stage.payment;

import fxterm.app.id.LoggerId;
import fxterm.core.menu.VisitMenuCounter;
import fxterm.module.Environment;
import fxterm.module.ModuleStore;
import fxterm.module.Pack;
import fxterm.module.TimeoutManager;
import fxterm.module.input.BaseModule;
import fxterm.module.stage.payment.PaymentModule;
import fxterm.session.Session;
import fxterm.utils.FinUtils;
import org.apache.log4j.Logger;
import plfx.screen.pay.CommonSumScreen;
import ru.softlogic.cash.Sum;
import ru.softlogic.service.comission.SumResult;

public abstract class BasePaymentModule
extends BaseModule
implements PaymentModule {
    protected Logger log = LoggerId.PAY;

    @Override
    public int getInactivityTimeout() {
        return TimeoutManager.getInstance().getTimeout(this.getType());
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public final void startPayment(Environment environment, CommonSumScreen sumScreen) {
        this.log.info((Object)"\n");
        this.log.info((Object)"***** SELECT PAYMENT MODULE ***************************************************");
        ModuleStore.setModule(this);
        Pack pack = environment.getPack();
        Pack restore = Session.getPayEnv().getPack();
        Session.getPayEnv().setPack(pack);
        if (pack.getService().isFlagExist(0x200000L)) {
            this.log.info((Object)"The service is configured to send the payment with zero-sum");
            pack.setZeroAmount(true);
            Sum s0 = FinUtils.createVoidSum();
            pack.setSumResult(new SumResult(s0, s0, s0, s0, s0, s0, s0, null));
            Session.getPayEnv().save();
            VisitMenuCounter.reset();
            environment.getModules().getProcessingModule().process(environment);
        } else {
            this._startPayment(environment, sumScreen, restore);
            this.initPaymentSchema();
            VisitMenuCounter.reset();
        }
    }

    public abstract void _startPayment(Environment var1, CommonSumScreen var2, Pack var3);

    protected void startPayout(Environment environment) {
        environment.getModules().getBeforePayoutModule().startPayout(environment);
    }
}

