/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.stage.ending;

import fxterm.app.FxEnv;
import fxterm.core.menu.MenuByServiceIdVisitor;
import fxterm.core.menu.MenuUtils;
import fxterm.core.menu.utils.ButtonInitFactory;
import fxterm.module.Environment;
import fxterm.module.Intent;
import fxterm.module.stage.ending.SimpleEndingModule;
import fxterm.session.Session;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import plfx.msg.MessageTemplate;
import plfx.msg.SimpleMessageTemplate;
import plfx.msg.screen.ScreenProcessor;
import plfx.screen.FxScreenTemplate;
import plfx.screen.ScreenAdapter;
import plfx.screen.ScreenListener;
import plfx.screen.ScreenListenerAdapter;
import plfx.screen.ScreenStore;
import plfx.screen.TemplateCreateException;
import plfx.screen.menu.MenuTemplate;
import plfx.screen.menu.MenuTemplateListener;
import plfx.screen.menu.button.MenuButtonInit;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.menu.MenuItemState;

public class SuggestServiceEndingModule
extends SimpleEndingModule {
    @Override
    public void _end(Environment environment) {
        this.environment = environment;
        List<Short> tsids = this.getTogetherServiceIds(environment.getPack().getService().getTogetherServicesId());
        if (tsids != null && !tsids.isEmpty()) {
            this.log.info((Object)("Together services ids: " + tsids));
            StringBuilder sb = new StringBuilder();
            ArrayList<MenuItem> services = new ArrayList<MenuItem>();
            for (Short tsid : tsids) {
                MenuByServiceIdVisitor visitor = new MenuByServiceIdVisitor(tsid);
                MenuUtils.processMenu(visitor);
                if (visitor.getMenuItem() == null) continue;
                services.add(visitor.getMenuItem());
                sb.append(tsid).append(' ');
            }
            this.log.info((Object)("Find together services in menu: " + sb.toString().trim()));
            if (services.isEmpty()) {
                super._end(environment);
            } else {
                this.toShowScreen(services);
            }
        } else {
            super._end(environment);
        }
    }

    private void toShowScreen(List<MenuItem> items) {
        try {
            HashMap<String, Map<String, String>> messages = new HashMap<String, Map<String, String>>();
            MenuTemplate ending = ScreenStore.getMenuTemplate((String)"ending");
            ArrayList<MenuButtonInit> inits = new ArrayList<MenuButtonInit>();
            int i = 0;
            for (MenuItem mi : items) {
                MenuButtonInit mbi = ButtonInitFactory.createButtonInit(mi, MenuItemState.DEFAULT, () -> {
                    this.log.info((Object)("Redirect to service id=" + mi.getService().getId()));
                    Session.setRedirectItem(mi);
                    this.environment.getModules().getPresentModule().takePresent(this.environment);
                });
                messages.put("mixed" + i, mbi.getTexts());
                inits.add(mbi);
                ++i;
            }
            Session.setMenuTitles(messages);
            ending.getMixedArea().fill(inits);
            ending.setListener((MenuTemplateListener)new ScreenListenerAdapter((ScreenListener)new ScreenAdapter()){

                public void onAction(String action) {
                    SuggestServiceEndingModule.this.log.info((Object)("Action on redirect ending screen: " + action));
                    SuggestServiceEndingModule.this.environment.getModules().getPresentModule().takePresent(SuggestServiceEndingModule.this.environment);
                }
            });
            SimpleMessageTemplate smt = new SimpleMessageTemplate(this.getDialogId());
            ScreenProcessor.process((String)"dlg", (MessageTemplate)smt);
            Session.setItem("ending_message", smt.getValue());
            ScreenProcessor.process((FxScreenTemplate)ending, (String)"dlg");
            this.log.info((Object)"Show redirect ending screen");
            FxEnv.showScreen((FxScreenTemplate)ending);
        }
        catch (TemplateCreateException ex) {
            this.log.error((Object)ex, (Throwable)ex);
            super._end(this.environment);
        }
    }

    @Override
    protected String getDialogId() {
        String did;
        switch (did = super.getDialogId()) {
            case "module/ending/cancel_sms": {
                return "cancel_sms";
            }
            case "module/ending/cancel_timeout": {
                return "cancel_timeout";
            }
            case "module/ending/cancel_pin": {
                return "cancel_pin";
            }
            case "module/ending/cancel_mobile": {
                return "payment_complete_mobile";
            }
            case "module/ending/cancel_srv": {
                return "cancel_service";
            }
            case "module/ending/complete_sms": {
                return "payment_complete_sms";
            }
            case "module/ending/complete_cbc": {
                return "payment_complete_cbc";
            }
            case "module/ending/complete_srv": {
                return "payment_complete_srv";
            }
            case "module/ending/complete_mobile": {
                return "payment_complete_mobile";
            }
        }
        return "payment_complete";
    }

    @Override
    public int getInactivityTimeout() {
        return 45;
    }

    @Override
    public void cancel(Intent intent) {
        this.log.info((Object)"Timeout on redirect ending screen");
        this.environment.getModules().getPresentModule().takePresent(this.environment);
    }

    private List<Short> getTogetherServiceIds(String src) {
        if (src == null || src.trim().isEmpty()) {
            return null;
        }
        String[] srvs = src.split(",");
        ArrayList<Short> res = new ArrayList<Short>();
        for (String s : srvs) {
            try {
                res.add(Short.parseShort(s.trim()));
            }
            catch (NumberFormatException ex) {
                this.log.debug((Object)ex, (Throwable)ex);
            }
        }
        return res;
    }
}

